/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.toad.cfparse;

import com.ibm.toad.cfparse.ConstantPool;
import com.ibm.toad.cfparse.FieldInfoList;
import com.ibm.toad.cfparse.InterfaceList;
import com.ibm.toad.cfparse.MethodInfoList;
import com.ibm.toad.cfparse.attributes.AttrInfoList;
import com.ibm.toad.cfparse.attributes.SourceFileAttrInfo;
import com.ibm.toad.cfparse.utils.Access;
import com.ibm.toad.cfparse.utils.CPUtils;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.BitSet;

public final class ClassFile {
    private int d_magic;
    private int d_minorVersion;
    private int d_majorVersion;
    private int d_accessFlags;
    private int d_thisClass;
    private int d_superClass;
    private ConstantPool d_constants;
    private InterfaceList d_interfaces;
    private FieldInfoList d_fields;
    private MethodInfoList d_methods;
    private AttrInfoList d_attributes;

    public InterfaceList getInterfaces() {
        return this.d_interfaces;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Magic: 0x" + Integer.toHexString(this.d_magic) + "\n" + "Compiler Version: " + this.d_majorVersion + "." + this.d_minorVersion + "\n");
        stringBuffer.append(this.d_constants.toString() + "Class: \n" + Access.getClassAsString(this.d_accessFlags));
        String string = this.d_constants.getAsString(this.d_thisClass);
        String string2 = CPUtils.slashes2dots(string);
        stringBuffer.append(string2);
        if (this.d_superClass != 0) {
            string = this.d_constants.getAsString(this.d_superClass);
            string2 = CPUtils.slashes2dots(string);
            stringBuffer.append(" extends " + string2);
        }
        stringBuffer.append("\n");
        stringBuffer.append("" + this.d_interfaces + "\n" + this.d_fields + "\n" + this.d_methods + "\n" + this.d_attributes + "\n");
        return stringBuffer.toString();
    }

    public ClassFile() {
        this.d_constants = new ConstantPool();
        this.d_interfaces = new InterfaceList(this.d_constants);
        this.d_fields = new FieldInfoList(this.d_constants);
        this.d_methods = new MethodInfoList(this.d_constants);
        this.d_attributes = new AttrInfoList(this.d_constants, 1);
        this.d_magic = -889275714;
        this.d_minorVersion = 3;
        this.d_majorVersion = 45;
        this.d_accessFlags = 33;
        this.d_thisClass = this.d_constants.addClass("Default");
        this.d_superClass = this.d_constants.addClass("java.lang.Object");
    }

    public ClassFile(String string) throws FileNotFoundException, IOException {
        this(new FileInputStream(string));
    }

    public ClassFile(InputStream inputStream) throws IOException {
        this(inputStream, null);
    }

    public ClassFile(InputStream inputStream, ConstantPool constantPool) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        this.d_constants = constantPool == null ? new ConstantPool() : constantPool;
        this.d_interfaces = new InterfaceList(this.d_constants);
        this.d_fields = new FieldInfoList(this.d_constants);
        this.d_methods = new MethodInfoList(this.d_constants);
        this.d_attributes = new AttrInfoList(this.d_constants, 1);
        this.d_magic = dataInputStream.readInt();
        this.d_minorVersion = dataInputStream.readShort();
        this.d_majorVersion = dataInputStream.readShort();
        if (constantPool == null) {
            this.d_constants.read(dataInputStream);
        } else {
            ConstantPool constantPool2 = new ConstantPool();
            constantPool2.read(dataInputStream);
        }
        this.d_accessFlags = dataInputStream.readShort();
        this.d_thisClass = dataInputStream.readShort();
        this.d_superClass = dataInputStream.readShort();
        this.d_interfaces.read(dataInputStream);
        this.d_fields.read(dataInputStream);
        this.d_methods.read(dataInputStream);
        this.d_attributes.read(dataInputStream);
    }

    public void sortCF(int[] nArray) {
        this.d_thisClass = nArray[this.d_thisClass];
        this.d_superClass = nArray[this.d_superClass];
    }

    public int getAccess() {
        return this.d_accessFlags;
    }

    public String getSuperName() {
        if (this.d_superClass == 0) {
            return "";
        }
        return this.d_constants.getAsJava(this.d_superClass);
    }

    public void setSuperName(String string) {
        string = string.replace('.', '/');
        this.d_constants.editClass(this.d_superClass, string);
    }

    public void setAccess(int n) {
        this.d_accessFlags = n;
    }

    public void sort(int[] nArray) {
        this.d_constants.sort(nArray);
        this.d_thisClass = nArray[this.d_thisClass];
        this.d_superClass = nArray[this.d_superClass];
        this.d_interfaces.sort(nArray);
        this.d_fields.sort(nArray);
        this.d_methods.sort(nArray);
        this.d_attributes.sort(nArray);
    }

    public int getMagic() {
        return this.d_magic;
    }

    public void setMagic(int n) {
        this.d_magic = n;
    }

    public MethodInfoList getMethods() {
        return this.d_methods;
    }

    public FieldInfoList getFields() {
        return this.d_fields;
    }

    public void write(String string) throws FileNotFoundException, IOException {
        File file = new File(string);
        File file2 = file.getParentFile();
        if (file2 != null) {
            file2.mkdirs();
        }
        file.createNewFile();
        DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(file));
        this.write(dataOutputStream);
    }

    public AttrInfoList getAttrs() {
        return this.d_attributes;
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.d_magic);
        dataOutputStream.writeShort(this.d_minorVersion);
        dataOutputStream.writeShort(this.d_majorVersion);
        this.d_constants.write(dataOutputStream);
        dataOutputStream.writeShort(this.d_accessFlags);
        dataOutputStream.writeShort(this.d_thisClass);
        dataOutputStream.writeShort(this.d_superClass);
        this.d_interfaces.write(dataOutputStream);
        this.d_fields.write(dataOutputStream);
        this.d_methods.write(dataOutputStream);
        this.d_attributes.write(dataOutputStream);
    }

    public BitSet usesCF() {
        BitSet bitSet = new BitSet(this.d_constants.length());
        bitSet.set(this.d_thisClass);
        bitSet.set(this.d_superClass);
        return bitSet;
    }

    public int getMajor() {
        return this.d_majorVersion;
    }

    public void setMajor(int n) {
        this.d_majorVersion = n;
    }

    public BitSet uses() {
        BitSet bitSet = new BitSet(this.d_constants.length());
        bitSet.set(this.d_thisClass);
        bitSet.set(this.d_superClass);
        bitSet.or(this.d_interfaces.uses());
        bitSet.or(this.d_constants.uses());
        bitSet.or(this.d_methods.uses());
        bitSet.or(this.d_fields.uses());
        bitSet.or(this.d_attributes.uses());
        return bitSet;
    }

    public String getName() {
        return this.d_constants.getAsJava(this.d_thisClass);
    }

    public void setName(String string) {
        string = string.replace('.', '/');
        this.d_constants.editClass(this.d_thisClass, string);
    }

    public int getMinor() {
        return this.d_minorVersion;
    }

    public void setMinor(int n) {
        this.d_minorVersion = n;
    }

    public ConstantPool getCP() {
        return this.d_constants;
    }

    public void setCP(ConstantPool constantPool) {
        this.d_constants = constantPool;
    }

    public String getSourceFilename() {
        SourceFileAttrInfo sourceFileAttrInfo = (SourceFileAttrInfo)this.d_attributes.get("SourceFile");
        if (sourceFileAttrInfo == null) {
            return null;
        }
        return sourceFileAttrInfo.get();
    }
}

