/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.toad.cfparse;

import com.ibm.toad.cfparse.ConstantPoolEntry;
import com.ibm.toad.cfparse.utils.CPUtils;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Hashtable;

public final class ConstantPool {
    public static final int CONSTANT_Utf8 = 1;
    public static final int CONSTANT_Integer = 3;
    public static final int CONSTANT_Float = 4;
    public static final int CONSTANT_Long = 5;
    public static final int CONSTANT_Double = 6;
    public static final int CONSTANT_Class = 7;
    public static final int CONSTANT_String = 8;
    public static final int CONSTANT_Fieldref = 9;
    public static final int CONSTANT_Methodref = 10;
    public static final int CONSTANT_InterfaceMethodref = 11;
    public static final int CONSTANT_NameAndType = 12;
    private int d_numConstants = 1;
    private ConstantPoolEntry[] d_constants = new ConstantPoolEntry[1];
    private HashMap d_hashN2C;
    private HashMap d_hashC2i;

    public int addField(String string) {
        int n;
        String string2 = string.substring(0, string.indexOf(" "));
        String string3 = string.substring(string.indexOf(" ") + 1, string.lastIndexOf(" "));
        String string4 = string.substring(string.lastIndexOf(" ") + 1, string.length());
        int n2 = this.find(7, string2);
        if (n2 == -1) {
            n2 = this.addClass(string2);
        }
        if ((n = this.find(12, string3 + " " + string4)) == -1) {
            n = this.addNameAndType(string3, string4);
        }
        return this.addNewElement(new FieldrefEntry(n2, n));
    }

    public int addMethod(String string) {
        int n;
        String string2 = string.substring(0, string.indexOf(" "));
        String string3 = string.substring(string.indexOf(" ") + 1, string.lastIndexOf(" "));
        String string4 = string.substring(string.lastIndexOf(" ") + 1, string.length());
        int n2 = this.find(7, string2);
        if (n2 == -1) {
            n2 = this.addClass(string2);
        }
        if ((n = this.find(12, string3 + " " + string4)) == -1) {
            n = this.addNameAndType(string3, string4);
        }
        return this.addNewElement(new MethodrefEntry(n2, n));
    }

    public int addNameAndType(String string, String string2) {
        int n;
        int n2 = this.find(1, string);
        if (n2 == -1) {
            n2 = this.addUtf8(string);
        }
        if ((n = this.find(1, string2)) == -1) {
            n = this.addUtf8(string2);
        }
        return this.addNewElement(new NameAndTypeEntry(n2, n));
    }

    public void editMethodName(int n, String string) {
        ConstantPoolEntry constantPoolEntry = this.d_constants[n];
        if (!(constantPoolEntry instanceof MethodrefEntry)) {
            return;
        }
        this.d_hashN2C.remove(this.getType(constantPoolEntry) + constantPoolEntry.getAsString());
        ConstantPoolEntry constantPoolEntry2 = this.d_constants[constantPoolEntry.getIndices()[1]];
        Utf8Entry utf8Entry = (Utf8Entry)this.d_constants[constantPoolEntry2.getIndices()[0]];
        this.d_hashN2C.remove(this.getType(utf8Entry) + utf8Entry.getAsString());
        utf8Entry.setValue(string);
        this.d_hashN2C.put(this.getType(utf8Entry) + utf8Entry.getAsString(), utf8Entry);
        this.d_hashN2C.put(this.getType(constantPoolEntry) + constantPoolEntry.getAsString(), constantPoolEntry);
    }

    public int addUtf8(String string) {
        return this.addNewElement(new Utf8Entry(string));
    }

    void read(DataInputStream dataInputStream) throws IOException {
        this.d_numConstants = dataInputStream.readShort();
        this.d_constants = new ConstantPoolEntry[this.d_numConstants];
        this.d_constants[0] = new Utf8Entry("<dummy Entry>");
        int n = 1;
        while (n < this.d_numConstants) {
            if (this.readConstant(dataInputStream, n)) {
                ++n;
            }
            ++n;
        }
        n = 1;
        while (n < this.d_numConstants) {
            if (this.d_constants[n] != null) {
                this.d_hashN2C.put(this.getType(n) + this.d_constants[n].getAsString(), this.d_constants[n]);
                this.d_hashC2i.put(this.d_constants[n], new Integer(n));
            }
            ++n;
        }
    }

    public void editString(int n, String string) {
        ConstantPoolEntry constantPoolEntry = this.d_constants[n];
        if (!(constantPoolEntry instanceof StringEntry)) {
            return;
        }
        this.d_hashN2C.remove(this.getType(constantPoolEntry) + constantPoolEntry.getAsString());
        Utf8Entry utf8Entry = (Utf8Entry)this.d_constants[constantPoolEntry.getIndices()[0]];
        this.d_hashN2C.remove(this.getType(utf8Entry) + utf8Entry.getAsString());
        utf8Entry.setValue(string);
        this.d_hashN2C.put(this.getType(utf8Entry) + utf8Entry.getAsString(), utf8Entry);
        this.d_hashN2C.put(this.getType(constantPoolEntry) + constantPoolEntry.getAsString(), constantPoolEntry);
    }

    public int addInteger(int n) {
        return this.addNewElement(new IntegerEntry(n));
    }

    public void editNameAndType(int n, Hashtable hashtable, Hashtable hashtable2) {
        ConstantPoolEntry constantPoolEntry = this.d_constants[n];
        if (!(constantPoolEntry instanceof NameAndTypeEntry)) {
            return;
        }
        Utf8Entry utf8Entry = (Utf8Entry)this.d_constants[constantPoolEntry.getIndices()[0]];
        String string = (String)hashtable.get(utf8Entry.getAsString());
        if (string != null) {
            utf8Entry.setValue(string);
        }
        utf8Entry = (Utf8Entry)this.d_constants[constantPoolEntry.getIndices()[1]];
        String string2 = utf8Entry.getAsString();
        int n2 = 0;
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            int n3;
            if ((n3 = string2.indexOf("L", n2)) == -1) break;
            int n4 = string2.indexOf(";", n3);
            stringBuffer.append(string2.substring(n2, n3 + 1));
            Hashtable hashtable3 = (Hashtable)hashtable2.get(string2.substring(n3 + 1, n4).replace('/', '.'));
            String string3 = string2.substring(n3 + 1, n4);
            if (hashtable3 != null) {
                String string4 = (String)hashtable3.get(string2.substring(n3 + 1, n4).replace('/', '.'));
                if (string4 != null) {
                    string3 = string4;
                }
                bl = true;
            }
            stringBuffer.append(string3);
            n2 = n4;
        }
        stringBuffer.append(string2.substring(n2, string2.length()));
        if (stringBuffer.toString() != null) {
            utf8Entry.setValue(stringBuffer.toString());
        }
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.d_numConstants);
        int n = 1;
        while (n < this.d_numConstants) {
            ConstantPoolEntry constantPoolEntry = this.d_constants[n];
            if (constantPoolEntry != null) {
                constantPoolEntry.write(dataOutputStream);
            }
            ++n;
        }
    }

    public BitSet uses() {
        BitSet bitSet = new BitSet(this.d_numConstants);
        bitSet.set(0);
        int n = 1;
        while (n < this.d_numConstants) {
            ConstantPoolEntry constantPoolEntry = this.get(n);
            if (constantPoolEntry != null) {
                int[] nArray = constantPoolEntry.getIndices();
                if (nArray != null) {
                    int n2 = 0;
                    while (n2 < nArray.length) {
                        bitSet.set(nArray[n2]);
                        ++n2;
                    }
                }
            } else {
                bitSet.set(n);
            }
            ++n;
        }
        return bitSet;
    }

    public int getType(int n) {
        if (n < 0 || n > this.d_numConstants) {
            return -1;
        }
        return this.getType(this.get(n));
    }

    public int getType(ConstantPoolEntry constantPoolEntry) {
        if (constantPoolEntry instanceof ClassEntry) {
            return 7;
        }
        if (constantPoolEntry instanceof FieldrefEntry) {
            return 9;
        }
        if (constantPoolEntry instanceof MethodrefEntry) {
            return 10;
        }
        if (constantPoolEntry instanceof InterfaceMethodrefEntry) {
            return 11;
        }
        if (constantPoolEntry instanceof StringEntry) {
            return 8;
        }
        if (constantPoolEntry instanceof IntegerEntry) {
            return 3;
        }
        if (constantPoolEntry instanceof FloatEntry) {
            return 4;
        }
        if (constantPoolEntry instanceof LongEntry) {
            return 5;
        }
        if (constantPoolEntry instanceof DoubleEntry) {
            return 6;
        }
        if (constantPoolEntry instanceof NameAndTypeEntry) {
            return 12;
        }
        if (constantPoolEntry instanceof Utf8Entry) {
            return 1;
        }
        return -1;
    }

    public int length() {
        return this.d_numConstants;
    }

    public String getAsString(int n) {
        return this.get(n).getAsString();
    }

    public int addString(String string) {
        int n = this.find(1, string);
        if (n == -1) {
            n = this.addUtf8(string);
        }
        return this.addNewElement(new StringEntry(n));
    }

    public void remove(int n) {
        if (n < 0 || n >= this.d_numConstants - 1) {
            return;
        }
        int n2 = n;
        while (n2 < this.d_numConstants - 1) {
            this.d_constants[n2] = this.d_constants[n2 + 1];
            ++n2;
        }
        this.d_numConstants += -1;
    }

    public void removeAll() {
        ConstantPoolEntry[] constantPoolEntryArray = new ConstantPoolEntry[]{new Utf8Entry("<dummy Entry>")};
        this.d_numConstants = 1;
        this.d_hashN2C = new HashMap();
        this.d_hashC2i = new HashMap();
    }

    public void editClass(int n, String string) {
        ConstantPoolEntry constantPoolEntry = this.d_constants[n];
        if (!(constantPoolEntry instanceof ClassEntry)) {
            return;
        }
        this.d_hashN2C.remove(this.getType(constantPoolEntry) + constantPoolEntry.getAsString());
        Utf8Entry utf8Entry = (Utf8Entry)this.d_constants[constantPoolEntry.getIndices()[0]];
        this.d_hashN2C.remove(this.getType(utf8Entry) + utf8Entry.getAsString());
        utf8Entry.setValue(string);
        this.d_hashN2C.put(this.getType(utf8Entry) + utf8Entry.getAsString(), utf8Entry);
        this.d_hashN2C.put(this.getType(constantPoolEntry) + constantPoolEntry.getAsString(), constantPoolEntry);
    }

    public ConstantPoolEntry get(int n) {
        return this.d_constants[n];
    }

    public int addFloat(float f) {
        return this.addNewElement(new FloatEntry(f));
    }

    public int addLong(long l) {
        return this.addNewElement(new LongEntry(l));
    }

    public ConstantPool() {
        this.d_constants[0] = new Utf8Entry("<dummy Entry>");
        this.d_hashN2C = new HashMap();
        this.d_hashC2i = new HashMap();
    }

    public ConstantPool(InputStream inputStream) throws IOException {
        this();
        this.read(new DataInputStream(inputStream));
    }

    private boolean readConstant(DataInputStream dataInputStream, int n) throws IOException {
        byte by = dataInputStream.readByte();
        switch (by) {
            case 7: {
                short s = dataInputStream.readShort();
                this.d_constants[n] = new ClassEntry(s);
                break;
            }
            case 8: {
                short s = dataInputStream.readShort();
                this.d_constants[n] = new StringEntry(s);
                break;
            }
            case 9: {
                short s = dataInputStream.readShort();
                short s2 = dataInputStream.readShort();
                this.d_constants[n] = new FieldrefEntry(s, s2);
                break;
            }
            case 10: {
                short s = dataInputStream.readShort();
                short s3 = dataInputStream.readShort();
                this.d_constants[n] = new MethodrefEntry(s, s3);
                break;
            }
            case 11: {
                short s = dataInputStream.readShort();
                short s4 = dataInputStream.readShort();
                this.d_constants[n] = new InterfaceMethodrefEntry(s, s4);
                break;
            }
            case 3: {
                int n2 = dataInputStream.readInt();
                this.d_constants[n] = new IntegerEntry(n2);
                break;
            }
            case 4: {
                float f = dataInputStream.readFloat();
                this.d_constants[n] = new FloatEntry(f);
                break;
            }
            case 5: {
                long l = dataInputStream.readLong();
                this.d_constants[n] = new LongEntry(l);
                break;
            }
            case 6: {
                double d = dataInputStream.readDouble();
                this.d_constants[n] = new DoubleEntry(d);
                break;
            }
            case 12: {
                short s = dataInputStream.readShort();
                short s5 = dataInputStream.readShort();
                this.d_constants[n] = new NameAndTypeEntry(s, s5);
                break;
            }
            case 1: {
                String string = dataInputStream.readUTF();
                this.d_constants[n] = new Utf8Entry(string);
                break;
            }
            default: {
                throw new IOException("Unknown class file constant tag <" + by + "> in constant pool");
            }
        }
        return by == 6 || by == 5;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("CONSTANT POOL:\n");
        int n = 1;
        while (n < this.d_numConstants) {
            ConstantPoolEntry constantPoolEntry = this.d_constants[n];
            if (constantPoolEntry != null) {
                stringBuffer.append("  " + n + ": " + constantPoolEntry.toString() + "\n");
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public void sort(int[] nArray) {
        int n = 0;
        int n2 = 1;
        while (n2 < this.d_numConstants) {
            if (nArray[n2] == -1) {
                ++n;
            }
            ++n2;
        }
        ConstantPoolEntry[] constantPoolEntryArray = new ConstantPoolEntry[this.d_numConstants - n + 1];
        constantPoolEntryArray[0] = new Utf8Entry("<dummy Entry>");
        int n3 = 1;
        while (n3 < this.d_numConstants) {
            if (nArray[n3] != -1) {
                ConstantPoolEntry constantPoolEntry = this.get(n3);
                if (constantPoolEntry == null) {
                    constantPoolEntryArray[nArray[n3]] = null;
                } else {
                    int[] nArray2 = constantPoolEntry.getIndices();
                    switch (this.getType(constantPoolEntry)) {
                        case 7: 
                        case 8: {
                            constantPoolEntry.setIndices(new int[]{nArray[nArray2[0]]});
                            break;
                        }
                        case 9: 
                        case 10: 
                        case 11: 
                        case 12: {
                            constantPoolEntry.setIndices(new int[]{nArray[nArray2[0]], nArray[nArray2[1]]});
                            break;
                        }
                    }
                    constantPoolEntryArray[nArray[n3]] = constantPoolEntry;
                }
            }
            ++n3;
        }
        this.d_numConstants -= n;
        this.d_constants = constantPoolEntryArray;
        this.d_hashN2C = new HashMap();
        this.d_hashC2i = new HashMap();
        n3 = 1;
        while (n3 < this.d_numConstants) {
            if (this.d_constants[n3] != null) {
                this.d_hashN2C.put(this.getType(n3) + this.d_constants[n3].getAsString(), this.d_constants[n3]);
                this.d_hashC2i.put(this.d_constants[n3], new Integer(n3));
            }
            ++n3;
        }
    }

    public int addDouble(double d) {
        return this.addNewElement(new DoubleEntry(d));
    }

    public void editInterfaceName(int n, String string) {
        ConstantPoolEntry constantPoolEntry = this.d_constants[n];
        if (!(constantPoolEntry instanceof InterfaceMethodrefEntry)) {
            return;
        }
        this.d_hashN2C.remove(this.getType(constantPoolEntry) + constantPoolEntry.getAsString());
        ConstantPoolEntry constantPoolEntry2 = this.d_constants[constantPoolEntry.getIndices()[1]];
        Utf8Entry utf8Entry = (Utf8Entry)this.d_constants[constantPoolEntry2.getIndices()[0]];
        this.d_hashN2C.remove(this.getType(utf8Entry) + utf8Entry.getAsString());
        utf8Entry.setValue(string);
        this.d_hashN2C.put(this.getType(utf8Entry) + utf8Entry.getAsString(), utf8Entry);
        this.d_hashN2C.put(this.getType(constantPoolEntry) + constantPoolEntry.getAsString(), constantPoolEntry);
    }

    private void resize() {
        ConstantPoolEntry[] constantPoolEntryArray = new ConstantPoolEntry[this.d_numConstants + 10];
        if (this.d_constants != null) {
            System.arraycopy(this.d_constants, 0, constantPoolEntryArray, 0, this.d_numConstants);
        }
        this.d_constants = constantPoolEntryArray;
    }

    public int addClass(String string) {
        int n = this.find(1, string = string.replace('.', '/'));
        if (n == -1) {
            n = this.addUtf8(string);
        }
        return this.addNewElement(new ClassEntry(n));
    }

    public int addInterface(String string) {
        int n;
        String string2 = string.substring(0, string.indexOf(" "));
        String string3 = string.substring(string.indexOf(" ") + 1, string.lastIndexOf(" "));
        String string4 = string.substring(string.lastIndexOf(" ") + 1, string.length());
        int n2 = this.find(7, string2);
        if (n2 == -1) {
            n2 = this.addClass(string2);
        }
        if ((n = this.find(12, string3 + " " + string4)) == -1) {
            n = this.addNameAndType(string3, string4);
        }
        return this.addNewElement(new InterfaceMethodrefEntry(n2, n));
    }

    private int addNewElement(ConstantPoolEntry constantPoolEntry) {
        if (this.d_constants == null || this.d_numConstants == this.d_constants.length) {
            this.resize();
        }
        this.d_constants[this.d_numConstants] = constantPoolEntry;
        int n = this.d_numConstants++;
        if (constantPoolEntry instanceof LongEntry || constantPoolEntry instanceof DoubleEntry) {
            if (this.d_numConstants == this.d_constants.length) {
                this.resize();
            }
            ++this.d_numConstants;
        }
        this.d_hashN2C.put(this.getType(constantPoolEntry) + constantPoolEntry.getAsString(), constantPoolEntry);
        this.d_hashC2i.put(constantPoolEntry, new Integer(n));
        return n;
    }

    public int find(int n, String string) {
        int n2 = -1;
        ConstantPoolEntry constantPoolEntry = (ConstantPoolEntry)this.d_hashN2C.get(n + string);
        if (constantPoolEntry != null) {
            Integer n3 = (Integer)this.d_hashC2i.get(constantPoolEntry);
            if (n3 == null) {
                System.out.println("Whoops: " + constantPoolEntry);
            }
            n2 = n3;
        }
        return n2;
    }

    public int find(ConstantPoolEntry constantPoolEntry) {
        return this.find(this.getType(constantPoolEntry), constantPoolEntry.getAsString());
    }

    public int find(float f) {
        int n = 1;
        while (n < this.d_numConstants) {
            if (this.getType(n) == 4 && f == ((FloatEntry)this.get(n)).getValue()) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int find(int n) {
        int n2 = 1;
        while (n2 < this.d_numConstants) {
            if (this.getType(n2) == 3 && n == ((IntegerEntry)this.get(n2)).getValue()) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public int find(double d) {
        int n = 1;
        while (n < this.d_numConstants) {
            if (this.getType(n) == 6 && d == ((DoubleEntry)this.get(n)).getValue()) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public String getAsJava(int n) {
        return this.get(n).getAsJava();
    }

    public void editFieldName(int n, String string) {
        ConstantPoolEntry constantPoolEntry = this.d_constants[n];
        if (!(constantPoolEntry instanceof FieldrefEntry)) {
            return;
        }
        this.d_hashN2C.remove(this.getType(constantPoolEntry) + constantPoolEntry.getAsString());
        ConstantPoolEntry constantPoolEntry2 = this.d_constants[constantPoolEntry.getIndices()[1]];
        Utf8Entry utf8Entry = (Utf8Entry)this.d_constants[constantPoolEntry2.getIndices()[0]];
        this.d_hashN2C.remove(this.getType(utf8Entry) + utf8Entry.getAsString());
        utf8Entry.setValue(string);
        this.d_hashN2C.put(this.getType(utf8Entry) + utf8Entry.getAsString(), utf8Entry);
        this.d_hashN2C.put(this.getType(constantPoolEntry) + constantPoolEntry.getAsString(), constantPoolEntry);
    }

    public final class FieldrefEntry
    extends ConstantPoolEntry {
        private int d_idxClass;
        private int d_idxNameAndType;

        public String toString() {
            return "Fieldref: " + this.d_idxClass + " " + this.d_idxNameAndType + " (" + this.getAsJava() + ")";
        }

        FieldrefEntry(int n, int n2) {
            ConstantPool.this.getClass();
            this.d_idxClass = n;
            this.d_idxNameAndType = n2;
        }

        void write(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeByte(9);
            dataOutputStream.writeShort(this.d_idxClass);
            dataOutputStream.writeShort(this.d_idxNameAndType);
        }

        public boolean equals(Object object) {
            if (!(object instanceof FieldrefEntry)) {
                return false;
            }
            ConstantPoolEntry constantPoolEntry = (ConstantPoolEntry)object;
            int[] nArray = constantPoolEntry.getIndices();
            return ConstantPool.this.get(this.d_idxClass).equals(ConstantPool.this.get(nArray[0])) && ConstantPool.this.get(this.d_idxNameAndType).equals(ConstantPool.this.get(nArray[1]));
        }

        public int[] getIndices() {
            return new int[]{this.d_idxClass, this.d_idxNameAndType};
        }

        void setIndices(int[] nArray) {
            this.d_idxClass = nArray[0];
            this.d_idxNameAndType = nArray[1];
        }

        public String getAsString() {
            return ConstantPool.this.getAsString(this.d_idxClass) + " " + ConstantPool.this.getAsString(this.d_idxNameAndType);
        }

        public String getAsJava() {
            NameAndTypeEntry nameAndTypeEntry = (NameAndTypeEntry)ConstantPool.this.get(this.d_idxNameAndType);
            String string = nameAndTypeEntry.getTypeAsJava();
            String string2 = nameAndTypeEntry.getNameAsJava();
            return string + " " + ConstantPool.this.getAsJava(this.d_idxClass) + "." + string2;
        }
    }

    public final class MethodrefEntry
    extends ConstantPoolEntry {
        private int d_idxClass;
        private int d_idxNameAndType;

        public String toString() {
            return "Methodref: " + this.d_idxClass + " " + this.d_idxNameAndType + " (" + this.getAsJava() + ")";
        }

        MethodrefEntry(int n, int n2) {
            ConstantPool.this.getClass();
            this.d_idxClass = n;
            this.d_idxNameAndType = n2;
        }

        void write(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeByte(10);
            dataOutputStream.writeShort(this.d_idxClass);
            dataOutputStream.writeShort(this.d_idxNameAndType);
        }

        public boolean equals(Object object) {
            if (!(object instanceof MethodrefEntry)) {
                return false;
            }
            ConstantPoolEntry constantPoolEntry = (ConstantPoolEntry)object;
            int[] nArray = constantPoolEntry.getIndices();
            return ConstantPool.this.get(this.d_idxClass).equals(ConstantPool.this.get(nArray[0])) && ConstantPool.this.get(this.d_idxNameAndType).equals(ConstantPool.this.get(nArray[1]));
        }

        public int[] getIndices() {
            return new int[]{this.d_idxClass, this.d_idxNameAndType};
        }

        void setIndices(int[] nArray) {
            this.d_idxClass = nArray[0];
            this.d_idxNameAndType = nArray[1];
        }

        public String getAsString() {
            return ConstantPool.this.getAsString(this.d_idxClass) + " " + ConstantPool.this.getAsString(this.d_idxNameAndType);
        }

        public String getAsJava() {
            String string;
            NameAndTypeEntry nameAndTypeEntry = (NameAndTypeEntry)ConstantPool.this.get(this.d_idxNameAndType);
            String string2 = nameAndTypeEntry.getTypeAsJava();
            int n = string2.indexOf(" ");
            String string3 = "";
            if (n == -1) {
                string = string2;
            } else {
                string3 = string2.substring(0, n);
                string = string2.substring(n + 1);
            }
            String string4 = nameAndTypeEntry.getNameAsJava();
            return string3 + " " + ConstantPool.this.getAsJava(this.d_idxClass) + "." + string4 + string;
        }
    }

    public final class NameAndTypeEntry
    extends ConstantPoolEntry {
        private int d_idxName;
        private int d_idxType;

        public String toString() {
            return "NameAndType: " + this.d_idxName + " " + this.d_idxType + " (" + this.getAsJava() + ")";
        }

        NameAndTypeEntry(int n, int n2) {
            ConstantPool.this.getClass();
            this.d_idxName = n;
            this.d_idxType = n2;
        }

        String getNameAsJava() {
            return ConstantPool.this.getAsString(this.d_idxName);
        }

        String getTypeAsJava() {
            return CPUtils.internal2java(ConstantPool.this.getAsString(this.d_idxType));
        }

        void write(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeByte(12);
            dataOutputStream.writeShort(this.d_idxName);
            dataOutputStream.writeShort(this.d_idxType);
        }

        public boolean equals(Object object) {
            if (!(object instanceof NameAndTypeEntry)) {
                return false;
            }
            ConstantPoolEntry constantPoolEntry = (ConstantPoolEntry)object;
            int[] nArray = constantPoolEntry.getIndices();
            return ConstantPool.this.get(this.d_idxName).equals(ConstantPool.this.get(nArray[0])) && ConstantPool.this.get(this.d_idxType).equals(ConstantPool.this.get(nArray[1]));
        }

        public int[] getIndices() {
            return new int[]{this.d_idxName, this.d_idxType};
        }

        void setIndices(int[] nArray) {
            this.d_idxName = nArray[0];
            this.d_idxType = nArray[1];
        }

        public String getAsString() {
            return ConstantPool.this.getAsString(this.d_idxName) + " " + ConstantPool.this.getAsString(this.d_idxType);
        }

        public String getAsJava() {
            return this.getNameAsJava() + "." + this.getTypeAsJava();
        }
    }

    public static final class Utf8Entry
    extends ConstantPoolEntry {
        private String d_string;
        private String d_rewrite;

        public void setValue(String string) {
            this.d_string = string;
            this.d_rewrite = this.rewrite(string);
        }

        public String getValue() {
            return this.d_string;
        }

        public String toString() {
            return "Utf8: " + this.d_rewrite;
        }

        Utf8Entry(String string) {
            this.d_string = string;
            this.d_rewrite = this.rewrite(string);
        }

        void write(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeByte(1);
            dataOutputStream.writeUTF(this.d_string);
        }

        private String rewrite(String string) {
            StringBuffer stringBuffer = new StringBuffer(string.length() + 10);
            int n = 0;
            while (n < string.length()) {
                switch (string.charAt(n)) {
                    case '\b': {
                        stringBuffer.append('\\');
                        stringBuffer.append('b');
                        break;
                    }
                    case '\t': {
                        stringBuffer.append('\\');
                        stringBuffer.append('t');
                        break;
                    }
                    case '\n': {
                        stringBuffer.append('\\');
                        stringBuffer.append('n');
                        break;
                    }
                    case '\f': {
                        stringBuffer.append('\\');
                        stringBuffer.append('f');
                        break;
                    }
                    case '\r': {
                        stringBuffer.append('\\');
                        stringBuffer.append('r');
                        break;
                    }
                    case '\"': {
                        stringBuffer.append('\\');
                        stringBuffer.append('\"');
                        break;
                    }
                    case '\'': {
                        stringBuffer.append('\\');
                        stringBuffer.append('n');
                        break;
                    }
                    case '\\': {
                        stringBuffer.append('\\');
                        stringBuffer.append('\\');
                        break;
                    }
                    default: {
                        stringBuffer.append(string.charAt(n));
                        break;
                    }
                }
                ++n;
            }
            return stringBuffer.toString();
        }

        public boolean equals(Object object) {
            return object instanceof Utf8Entry && this.d_rewrite.equals(((Utf8Entry)object).getAsString());
        }

        public String getAsString() {
            return this.d_rewrite;
        }

        public String getAsJava() {
            return "\"" + this.d_rewrite + "\"";
        }
    }

    public final class StringEntry
    extends ConstantPoolEntry {
        private int d_index;

        public String toString() {
            return "String: " + this.d_index + " (" + this.getAsJava() + ")";
        }

        StringEntry(int n) {
            ConstantPool.this.getClass();
            this.d_index = n;
        }

        void write(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeByte(8);
            dataOutputStream.writeShort(this.d_index);
        }

        public boolean equals(Object object) {
            if (!(object instanceof StringEntry)) {
                return false;
            }
            ConstantPoolEntry constantPoolEntry = (ConstantPoolEntry)object;
            int[] nArray = constantPoolEntry.getIndices();
            return ConstantPool.this.get(this.d_index).equals(ConstantPool.this.get(nArray[0]));
        }

        public int[] getIndices() {
            return new int[]{this.d_index};
        }

        void setIndices(int[] nArray) {
            this.d_index = nArray[0];
        }

        public String getAsString() {
            return ConstantPool.this.get(this.d_index).getAsString();
        }

        public String getAsJava() {
            return ConstantPool.this.get(this.d_index).getAsJava();
        }
    }

    public static final class IntegerEntry
    extends ConstantPoolEntry {
        private int d_integer;

        public void setValue(int n) {
            this.d_integer = n;
        }

        public int getValue() {
            return this.d_integer;
        }

        public String toString() {
            return "Integer: " + this.d_integer;
        }

        IntegerEntry(int n) {
            this.d_integer = n;
        }

        void write(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeByte(3);
            dataOutputStream.writeInt(this.d_integer);
        }

        public boolean equals(Object object) {
            return object instanceof IntegerEntry && this.d_integer == ((IntegerEntry)object).getValue();
        }

        public String getAsString() {
            return String.valueOf(this.d_integer);
        }

        public String getAsJava() {
            return "#" + this.d_integer;
        }
    }

    public final class ClassEntry
    extends ConstantPoolEntry {
        private int d_index;

        public String toString() {
            return "Class: " + this.d_index + " (" + this.getAsJava() + ")";
        }

        ClassEntry(int n) {
            ConstantPool.this.getClass();
            this.d_index = n;
        }

        void write(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeByte(7);
            dataOutputStream.writeShort(this.d_index);
        }

        public boolean equals(Object object) {
            if (!(object instanceof ClassEntry)) {
                return false;
            }
            ConstantPoolEntry constantPoolEntry = (ConstantPoolEntry)object;
            int[] nArray = constantPoolEntry.getIndices();
            return ConstantPool.this.get(this.d_index).equals(ConstantPool.this.get(nArray[0]));
        }

        public int[] getIndices() {
            return new int[]{this.d_index};
        }

        void setIndices(int[] nArray) {
            this.d_index = nArray[0];
        }

        public String getAsString() {
            return ConstantPool.this.getAsString(this.d_index);
        }

        public String getAsJava() {
            String string = ConstantPool.this.getAsString(this.d_index);
            if (!string.startsWith("[")) {
                return CPUtils.slashes2dots(this.getAsString());
            }
            StringBuffer stringBuffer = new StringBuffer();
            CPUtils.descriptor2java(string, 0, stringBuffer);
            return stringBuffer.toString();
        }
    }

    public final class InterfaceMethodrefEntry
    extends ConstantPoolEntry {
        private int d_idxClass;
        private int d_idxNameAndType;

        public String toString() {
            return "InterfaceMethodref: " + this.d_idxClass + " " + this.d_idxNameAndType + " (" + this.getAsJava() + ")";
        }

        InterfaceMethodrefEntry(int n, int n2) {
            ConstantPool.this.getClass();
            this.d_idxClass = n;
            this.d_idxNameAndType = n2;
        }

        void write(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeByte(11);
            dataOutputStream.writeShort(this.d_idxClass);
            dataOutputStream.writeShort(this.d_idxNameAndType);
        }

        public boolean equals(Object object) {
            if (!(object instanceof InterfaceMethodrefEntry)) {
                return false;
            }
            ConstantPoolEntry constantPoolEntry = (ConstantPoolEntry)object;
            int[] nArray = constantPoolEntry.getIndices();
            return ConstantPool.this.get(this.d_idxClass).equals(ConstantPool.this.get(nArray[0])) && ConstantPool.this.get(this.d_idxNameAndType).equals(ConstantPool.this.get(nArray[1]));
        }

        public int[] getIndices() {
            return new int[]{this.d_idxClass, this.d_idxNameAndType};
        }

        void setIndices(int[] nArray) {
            this.d_idxClass = nArray[0];
            this.d_idxNameAndType = nArray[1];
        }

        public String getAsString() {
            return ConstantPool.this.getAsString(this.d_idxClass) + " " + ConstantPool.this.getAsString(this.d_idxNameAndType);
        }

        public String getAsJava() {
            String string;
            NameAndTypeEntry nameAndTypeEntry = (NameAndTypeEntry)ConstantPool.this.get(this.d_idxNameAndType);
            String string2 = nameAndTypeEntry.getTypeAsJava();
            int n = string2.indexOf(" ");
            String string3 = "";
            if (n == -1) {
                string = string2;
            } else {
                string3 = string2.substring(0, n);
                string = string2.substring(n + 1);
            }
            String string4 = nameAndTypeEntry.getNameAsJava();
            return string3 + " " + ConstantPool.this.getAsJava(this.d_idxClass) + "." + string4 + string;
        }
    }

    public static final class FloatEntry
    extends ConstantPoolEntry {
        private float d_float;

        public void setValue(float f) {
            this.d_float = f;
        }

        public float getValue() {
            return this.d_float;
        }

        public String toString() {
            return "Float: " + this.d_float;
        }

        FloatEntry(float f) {
            this.d_float = f;
        }

        void write(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeByte(4);
            dataOutputStream.writeFloat(this.d_float);
        }

        public boolean equals(Object object) {
            return object instanceof FloatEntry && this.d_float == ((FloatEntry)object).getValue();
        }

        public String getAsString() {
            return String.valueOf(this.d_float);
        }

        public String getAsJava() {
            return "F" + this.d_float;
        }
    }

    public static final class LongEntry
    extends ConstantPoolEntry {
        private long d_long;

        public void setValue(long l) {
            this.d_long = l;
        }

        public long getValue() {
            return this.d_long;
        }

        public String toString() {
            return "Long: " + this.d_long;
        }

        LongEntry(long l) {
            this.d_long = l;
        }

        void write(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeByte(5);
            dataOutputStream.writeLong(this.d_long);
        }

        public boolean equals(Object object) {
            return object instanceof LongEntry && this.d_long == ((LongEntry)object).getValue();
        }

        public String getAsString() {
            return String.valueOf(this.d_long);
        }

        public String getAsJava() {
            return "L" + this.d_long;
        }
    }

    public static final class DoubleEntry
    extends ConstantPoolEntry {
        private double d_double;

        public void setValue(double d) {
            this.d_double = d;
        }

        public double getValue() {
            return this.d_double;
        }

        public String toString() {
            return "Double: " + this.d_double;
        }

        DoubleEntry(double d) {
            this.d_double = d;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        void write(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeByte(6);
            dataOutputStream.writeDouble(this.d_double);
        }

        public boolean equals(Object object) {
            return object instanceof DoubleEntry && this.toString().equals(((DoubleEntry)object).toString());
        }

        public String getAsString() {
            return String.valueOf(this.d_double);
        }

        public String getAsJava() {
            return "D" + this.d_double;
        }
    }
}

