/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.toad.cfparse;

import com.ibm.toad.cfparse.ClassFile;
import com.ibm.toad.cfparse.ConstantPool;
import com.ibm.toad.cfparse.MethodInfo;
import com.ibm.toad.cfparse.MethodInfoList;
import com.ibm.toad.cfparse.attributes.AttrInfoList;
import com.ibm.toad.cfparse.attributes.CodeAttrInfo;
import com.ibm.toad.cfparse.attributes.ConstantValueAttrInfo;
import com.ibm.toad.cfparse.instruction.BaseInstruction;
import com.ibm.toad.cfparse.instruction.InstructionFormatException;
import com.ibm.toad.cfparse.instruction.MutableCodeSegment;
import com.ibm.toad.cfparse.instruction.StringInstructionFactory;
import com.ibm.toad.cfparse.utils.Access;
import com.ibm.toad.cfparse.utils.BadJavaError;
import com.ibm.toad.cfparse.utils.CPUtils;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.BitSet;
import java.util.Vector;

public final class FieldInfo {
    private ConstantPool d_cp;
    private int d_accessFlags;
    private int d_idxName;
    private int d_idxDescriptor;
    private AttrInfoList d_attrs;

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (Access.isPublic(this.d_accessFlags)) {
            stringBuffer.append("public ");
        }
        if (Access.isPrivate(this.d_accessFlags)) {
            stringBuffer.append("private ");
        }
        if (Access.isProtected(this.d_accessFlags)) {
            stringBuffer.append("protected ");
        }
        if (Access.isFinal(this.d_accessFlags)) {
            stringBuffer.append("final ");
        }
        if (Access.isStatic(this.d_accessFlags)) {
            stringBuffer.append("static ");
        }
        if (Access.isVolatile(this.d_accessFlags)) {
            stringBuffer.append("volatile ");
        }
        if (Access.isTransient(this.d_accessFlags)) {
            stringBuffer.append("transient ");
        }
        String string = this.d_cp.getAsString(this.d_idxDescriptor);
        String string2 = CPUtils.internal2java(string);
        stringBuffer.append(string2 + " " + this.d_cp.getAsString(this.d_idxName) + ";\n" + this.d_attrs);
        return stringBuffer.toString();
    }

    FieldInfo(ConstantPool constantPool) {
        this.d_cp = constantPool;
        this.d_accessFlags = -1;
        this.d_idxName = -1;
        this.d_idxDescriptor = -1;
        this.d_attrs = new AttrInfoList(constantPool, 2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    FieldInfo(ClassFile classFile, ConstantPool constantPool, String string) {
        int n;
        this.d_cp = constantPool;
        string = string.trim();
        this.d_accessFlags = Access.getFromString(string);
        if (!Access.isStatic(this.d_accessFlags)) {
            throw new BadJavaError("Incorrect method for non-static initialiser");
        }
        int n2 = 0;
        while ((n = string.indexOf(" ", n2)) != -1) {
            if (!Access.isFlag(string.substring(n2, n).trim())) break;
            n2 = n + 1;
        }
        string = string.substring(n2, string.length());
        int n3 = string.indexOf(" ");
        if (n3 == -1) {
            throw new BadJavaError("Bad Field Description : no whitespace");
        }
        String string2 = string.substring(0, n3).trim();
        int n4 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        String string3 = string.substring(n3 + 1).trim();
        if (!Character.isJavaIdentifierStart(string3.charAt(0))) {
            throw new BadJavaError("Bad Field Description : Invalid field identifier");
        }
        stringBuffer.append(string3.charAt(0));
        int n5 = 1;
        while (n5 < string3.length()) {
            if (!Character.isJavaIdentifierPart(string3.charAt(n5))) {
                n4 = n5;
                break;
            }
            stringBuffer.append(string3.charAt(n5));
            ++n5;
        }
        if (n4 == 0) {
            throw new BadJavaError("Bad Field Description : Static definition with no initialiser");
        }
        String string4 = stringBuffer.toString();
        if (string4.equals("")) {
            throw new BadJavaError("Bad Field Description : no identifier");
        }
        String string5 = CPUtils.java2internal(string2);
        this.d_idxName = constantPool.find(1, string4);
        if (this.d_idxName == -1) {
            this.d_idxName = constantPool.addUtf8(string4);
        }
        this.d_idxDescriptor = constantPool.find(1, string5);
        if (this.d_idxDescriptor == -1) {
            this.d_idxDescriptor = constantPool.addUtf8(string5);
        }
        this.d_attrs = new AttrInfoList(constantPool, 2);
        String string6 = string3.substring(n4).trim();
        if (string6.charAt(0) != '=') {
            throw new BadJavaError("Bad Field Description: Incorrect initializer");
        }
        string6 = string6.substring(1).trim();
        if (Access.isFinal(this.d_accessFlags)) {
            ConstantValueAttrInfo constantValueAttrInfo = (ConstantValueAttrInfo)this.d_attrs.add("ConstantValue");
            if (string5.equals("B")) {
                byte by = Byte.parseByte(string6);
                constantValueAttrInfo.set(by);
                return;
            } else if (string5.equals("C")) {
                if (string6.charAt(0) != '\'') {
                    throw new BadJavaError("Bad Field Description: unquoted character");
                }
                constantValueAttrInfo.set(string6.charAt(1));
                return;
            } else if (string5.equals("D")) {
                double d = Double.parseDouble(string6);
                constantValueAttrInfo.set(d);
                return;
            } else if (string5.equals("F")) {
                float f = Float.parseFloat(string6);
                constantValueAttrInfo.set(f);
                return;
            } else if (string5.equals("I")) {
                int n6 = Integer.parseInt(string6);
                constantValueAttrInfo.set(n6);
                return;
            } else if (string5.equals("J")) {
                long l = Long.parseLong(string6);
                constantValueAttrInfo.set(l);
                return;
            } else if (string5.equals("S")) {
                short s = Short.parseShort(string6);
                constantValueAttrInfo.set(s);
                return;
            } else if (string5.equals("Z")) {
                boolean bl = Boolean.valueOf(string6);
                constantValueAttrInfo.set(bl ? 1 : 0);
                return;
            } else {
                if (!string5.equals("Ljava/lang/String;")) throw new BadJavaError("Cannot initialise final variable of type " + string2);
                if (string6.charAt(0) != '\"' || string6.charAt(string6.length() - 1) != '\"') {
                    throw new BadJavaError("Bad Field Description: unquoted String");
                }
                constantValueAttrInfo.set(string6.substring(1, string6.length() - 1));
            }
            return;
        }
        MethodInfoList methodInfoList = classFile.getMethods();
        MethodInfo methodInfo = null;
        int n7 = 0;
        while (n7 < methodInfoList.length()) {
            methodInfo = methodInfoList.get(n7);
            if (methodInfo.getName().equals("<clinit>")) break;
            ++n7;
        }
        if (methodInfo == null) {
            methodInfo = methodInfoList.add("static void <clinit>()");
        }
        CodeAttrInfo codeAttrInfo = (CodeAttrInfo)methodInfo.getAttrs().get("Code");
        MutableCodeSegment mutableCodeSegment = new MutableCodeSegment(this.d_cp, codeAttrInfo, false);
        mutableCodeSegment.setInstructionFactory(new StringInstructionFactory());
        Vector vector = mutableCodeSegment.getInstructions();
        if (vector.lastElement().toString().trim().equals("return")) {
            vector.removeElement(vector.lastElement());
        }
        BaseInstruction baseInstruction = null;
        try {
            if (string5.equals("B")) {
                byte by = Byte.parseByte(string6);
                baseInstruction = mutableCodeSegment.create("bipush #" + by);
                vector.addElement(baseInstruction);
                baseInstruction = mutableCodeSegment.create("putstatic byte " + classFile.getName() + "." + string4);
                vector.addElement(baseInstruction);
            } else if (string5.equals("C")) {
                if (string6.charAt(0) != '\'') {
                    throw new BadJavaError("Bad Field Description: unquoted character");
                }
                baseInstruction = mutableCodeSegment.create("bipush #" + string6.charAt(0));
                vector.addElement(baseInstruction);
                baseInstruction = mutableCodeSegment.create("putstatic char " + classFile.getName() + "." + string4);
                vector.addElement(baseInstruction);
            } else if (string5.equals("D")) {
                double d = Double.parseDouble(string6);
                baseInstruction = mutableCodeSegment.create("ldc2_w D" + d);
                vector.addElement(baseInstruction);
                baseInstruction = mutableCodeSegment.create("putstatic double " + classFile.getName() + "." + string4);
                vector.addElement(baseInstruction);
            } else if (string5.equals("F")) {
                float f = Float.parseFloat(string6);
                baseInstruction = mutableCodeSegment.create("ldc F" + f);
                vector.addElement(baseInstruction);
                baseInstruction = mutableCodeSegment.create("putstatic float " + classFile.getName() + "." + string4);
                vector.addElement(baseInstruction);
            } else if (string5.equals("I")) {
                int n8 = Integer.parseInt(string6);
                baseInstruction = mutableCodeSegment.create("bipush #" + n8);
                vector.addElement(baseInstruction);
                baseInstruction = mutableCodeSegment.create("putstatic int " + classFile.getName() + "." + string4);
                vector.addElement(baseInstruction);
            } else if (string5.equals("J")) {
                long l = Long.parseLong(string6);
                baseInstruction = mutableCodeSegment.create("ldc2_w L" + l);
                vector.addElement(baseInstruction);
                baseInstruction = mutableCodeSegment.create("putstatic long " + classFile.getName() + "." + string4);
                vector.addElement(baseInstruction);
            } else if (string5.equals("S")) {
                short s = Short.parseShort(string6);
                baseInstruction = mutableCodeSegment.create("bipush #" + s);
                vector.addElement(baseInstruction);
                baseInstruction = mutableCodeSegment.create("putstatic short " + classFile.getName() + "." + string4);
                vector.addElement(baseInstruction);
            } else if (string5.equals("Z")) {
                boolean bl = Boolean.valueOf(string6);
                baseInstruction = mutableCodeSegment.create(bl ? "iconst_1" : "iconst_0");
                vector.addElement(baseInstruction);
                baseInstruction = mutableCodeSegment.create("putstatic boolean " + classFile.getName() + "." + string4);
                vector.addElement(baseInstruction);
            } else {
                if (!string5.equals("Ljava/lang/String;")) throw new BadJavaError("Cannot initialise variable of type " + string2);
                baseInstruction = mutableCodeSegment.create("ldc " + string6);
                vector.addElement(baseInstruction);
                baseInstruction = mutableCodeSegment.create("putstatic java.lang.String " + classFile.getName() + "." + string4);
                vector.addElement(baseInstruction);
            }
            vector.addElement(mutableCodeSegment.create("return"));
        }
        catch (NumberFormatException numberFormatException) {
            throw new BadJavaError("Unparsed initialiser <" + string6 + ">");
        }
        catch (InstructionFormatException instructionFormatException) {
            throw new BadJavaError("Bad Instruction in static initialiser <" + instructionFormatException + ">");
        }
        codeAttrInfo.setCode(mutableCodeSegment.getCode());
        codeAttrInfo.setExceptions(mutableCodeSegment.getExcTable());
    }

    FieldInfo(ConstantPool constantPool, String string) {
        int n;
        this.d_cp = constantPool;
        string = string.trim();
        this.d_accessFlags = Access.getFromString(string);
        int n2 = 0;
        while ((n = string.indexOf(" ", n2)) != -1) {
            if (!Access.isFlag(string.substring(n2, n).trim())) break;
            n2 = n + 1;
        }
        string = string.substring(n2, string.length());
        int n3 = string.indexOf(" ");
        if (n3 == -1) {
            throw new BadJavaError("Bad Field Description");
        }
        String string2 = string.substring(0, n3).trim();
        int n4 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        String string3 = string.substring(n3 + 1).trim();
        if (!Character.isJavaIdentifierStart(string3.charAt(0))) {
            throw new BadJavaError("Invalid field identifier");
        }
        int n5 = 1;
        while (n5 < string3.length()) {
            if (!Character.isJavaIdentifierPart(string3.charAt(n5))) {
                n4 = n5;
                break;
            }
            stringBuffer.append(string3.charAt(n5));
            ++n5;
        }
        if (Access.isStatic(this.d_accessFlags) && n4 > 0) {
            throw new BadJavaError("Incorrect method for static initialiser");
        }
        String string4 = stringBuffer.toString();
        if (string4.equals("")) {
            throw new BadJavaError("Bad Field Description");
        }
        String string5 = CPUtils.java2internal(string2);
        this.d_idxName = constantPool.find(1, string4);
        if (this.d_idxName == -1) {
            this.d_idxName = constantPool.addUtf8(string4);
        }
        this.d_idxDescriptor = constantPool.find(1, string5);
        if (this.d_idxDescriptor == -1) {
            this.d_idxDescriptor = constantPool.addUtf8(string5);
        }
        this.d_attrs = new AttrInfoList(constantPool, 2);
    }

    void read(DataInputStream dataInputStream) throws IOException {
        this.d_accessFlags = dataInputStream.readShort();
        this.d_idxName = dataInputStream.readShort();
        this.d_idxDescriptor = dataInputStream.readShort();
        this.d_attrs.read(dataInputStream);
    }

    public int getAccess() {
        return this.d_accessFlags;
    }

    void sort(int[] nArray) {
        this.d_idxName = nArray[this.d_idxName];
        this.d_idxDescriptor = nArray[this.d_idxDescriptor];
        this.d_attrs.sort(nArray);
    }

    public void setAccess(int n) {
        this.d_accessFlags = n;
    }

    public String getDesc() {
        return this.d_cp.getAsString(this.d_idxDescriptor);
    }

    void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.d_accessFlags);
        dataOutputStream.writeShort(this.d_idxName);
        dataOutputStream.writeShort(this.d_idxDescriptor);
        this.d_attrs.write(dataOutputStream);
    }

    public AttrInfoList getAttrs() {
        return this.d_attrs;
    }

    public void setAttrs(AttrInfoList attrInfoList) {
        this.d_attrs = attrInfoList;
    }

    BitSet uses() {
        BitSet bitSet = new BitSet(this.d_cp.length());
        bitSet.set(this.d_idxName);
        bitSet.set(this.d_idxDescriptor);
        bitSet.or(this.d_attrs.uses());
        return bitSet;
    }

    public String getName() {
        return this.d_cp.getAsString(this.d_idxName);
    }

    public String getType() {
        return CPUtils.internal2java(this.d_cp.getAsString(this.d_idxDescriptor));
    }

    public void setName(String string) {
        ((ConstantPool.Utf8Entry)this.d_cp.get(this.d_idxName)).setValue(string);
    }

    public void setType(String string) {
        String string2 = CPUtils.java2internal(string);
        ((ConstantPool.Utf8Entry)this.d_cp.get(this.d_idxDescriptor)).setValue(string2);
    }
}

