/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.toad.cfparse;

import com.ibm.toad.cfparse.ClassFile;
import com.ibm.toad.cfparse.ConstantPool;
import com.ibm.toad.cfparse.FieldInfo;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.BitSet;

public final class FieldInfoList {
    private ConstantPool d_cp;
    private int d_numFields;
    private FieldInfo[] d_fields;

    public FieldInfo get(int n) {
        if (n < 0 || n > this.d_numFields) {
            return null;
        }
        return this.d_fields[n];
    }

    public FieldInfo addStatic(ClassFile classFile, String string) {
        if (this.d_fields == null || this.d_numFields == this.d_fields.length) {
            this.resize();
        }
        this.d_fields[this.d_numFields] = new FieldInfo(classFile, this.d_cp, string);
        ++this.d_numFields;
        return this.d_fields[this.d_numFields - 1];
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("FIELDS:\n");
        if (this.d_numFields == 0) {
            stringBuffer.append("  <none>\n");
        } else {
            int n = 0;
            while (n < this.d_numFields) {
                stringBuffer.append("  " + this.d_fields[n]);
                ++n;
            }
        }
        return stringBuffer.toString();
    }

    FieldInfoList(ConstantPool constantPool) {
        this.d_cp = constantPool;
        this.d_numFields = 0;
        this.d_fields = null;
    }

    void read(DataInputStream dataInputStream) throws IOException {
        this.d_numFields = dataInputStream.readShort();
        this.d_fields = new FieldInfo[this.d_numFields];
        int n = 0;
        while (n < this.d_numFields) {
            this.d_fields[n] = new FieldInfo(this.d_cp);
            this.d_fields[n].read(dataInputStream);
            ++n;
        }
    }

    public FieldInfo add(String string) {
        if (this.d_fields == null || this.d_numFields == this.d_fields.length) {
            this.resize();
        }
        this.d_fields[this.d_numFields] = new FieldInfo(this.d_cp, string);
        ++this.d_numFields;
        return this.d_fields[this.d_numFields - 1];
    }

    public void sort(int[] nArray) {
        int n = 0;
        while (n < this.d_numFields) {
            this.d_fields[n].sort(nArray);
            ++n;
        }
    }

    private void resize() {
        FieldInfo[] fieldInfoArray = new FieldInfo[this.d_numFields + 10];
        if (this.d_fields != null) {
            System.arraycopy(this.d_fields, 0, fieldInfoArray, 0, this.d_numFields);
        }
        this.d_fields = fieldInfoArray;
    }

    void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.d_numFields);
        int n = 0;
        while (n < this.d_numFields) {
            this.d_fields[n].write(dataOutputStream);
            ++n;
        }
    }

    public BitSet uses() {
        BitSet bitSet = new BitSet(this.d_cp.length());
        int n = 0;
        while (n < this.d_numFields) {
            bitSet.or(this.d_fields[n].uses());
            ++n;
        }
        return bitSet;
    }

    public int length() {
        return this.d_numFields;
    }

    public void remove(int n) {
        if (n < 0 || n > this.d_numFields - 1) {
            return;
        }
        int n2 = n;
        while (n2 < this.d_numFields - 1) {
            this.d_fields[n2] = this.d_fields[n2 + 1];
            ++n2;
        }
        this.d_numFields += -1;
    }

    public String getFieldName(int n) {
        if (n < 0 || n > this.d_numFields) {
            return null;
        }
        return this.d_fields[n].getName();
    }
}

