/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.toad.cfparse;

import com.ibm.toad.cfparse.ConstantPool;
import com.ibm.toad.cfparse.utils.CPUtils;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.BitSet;

public final class InterfaceList {
    private ConstantPool d_cp;
    private int d_numInterfaces;
    private int[] d_interfaces;

    public String get(int n) {
        if (n < 0 || n > this.d_numInterfaces) {
            return null;
        }
        return this.d_cp.getAsJava(this.d_interfaces[n]);
    }

    public void set(int n, String string) {
        if (n < 0 || n > this.d_numInterfaces - 1) {
            return;
        }
        int n2 = this.d_cp.find(7, string = CPUtils.dots2slashes(string));
        if (n2 == -1) {
            n2 = this.d_cp.addClass(string);
        }
        this.d_interfaces[n] = n2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.d_numInterfaces > 0) {
            stringBuffer.append("implements ");
            int n = 0;
            while (n < this.d_numInterfaces) {
                if (n > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(this.d_cp.getAsJava(this.d_interfaces[n]));
                ++n;
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    InterfaceList(ConstantPool constantPool) {
        this.d_cp = constantPool;
        this.d_numInterfaces = 0;
        this.d_interfaces = null;
    }

    void read(DataInputStream dataInputStream) throws IOException {
        this.d_numInterfaces = dataInputStream.readShort();
        this.d_interfaces = new int[this.d_numInterfaces];
        int n = 0;
        while (n < this.d_numInterfaces) {
            this.d_interfaces[n] = dataInputStream.readShort();
            ++n;
        }
    }

    public void add(String string) {
        int n;
        if (this.d_interfaces == null || this.d_numInterfaces + 1 >= this.d_interfaces.length) {
            this.resize();
        }
        if ((n = this.d_cp.find(7, string = CPUtils.dots2slashes(string))) == -1) {
            n = this.d_cp.addClass(string);
        }
        this.d_interfaces[this.d_numInterfaces++] = n;
    }

    public void sort(int[] nArray) {
        int n = 0;
        while (n < this.d_numInterfaces) {
            this.d_interfaces[n] = nArray[this.d_interfaces[n]];
            ++n;
        }
    }

    private void resize() {
        int[] nArray = new int[this.d_numInterfaces + 10];
        if (this.d_interfaces != null) {
            System.arraycopy(this.d_interfaces, 0, nArray, 0, this.d_numInterfaces);
        }
        this.d_interfaces = nArray;
    }

    public String getInterfaceName(int n) {
        if (n < 0 || n > this.d_numInterfaces) {
            return null;
        }
        return this.d_cp.getAsJava(this.d_interfaces[n]);
    }

    void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.d_numInterfaces);
        int n = 0;
        while (n < this.d_numInterfaces) {
            dataOutputStream.writeShort(this.d_interfaces[n]);
            ++n;
        }
    }

    public BitSet uses() {
        BitSet bitSet = new BitSet(this.d_cp.length());
        int n = 0;
        while (n < this.d_numInterfaces) {
            bitSet.set(this.d_interfaces[n]);
            ++n;
        }
        return bitSet;
    }

    public int length() {
        return this.d_numInterfaces;
    }

    public void remove(int n) {
        if (n < 0 || n > this.d_numInterfaces - 1) {
            return;
        }
        int n2 = n;
        while (n2 < this.d_numInterfaces - 1) {
            this.d_interfaces[n2] = this.d_interfaces[n2 + 1];
            ++n2;
        }
        this.d_numInterfaces += -1;
    }
}

