/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.toad.cfparse;

import com.ibm.toad.cfparse.ConstantPool;
import com.ibm.toad.cfparse.MethodInfo;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.BitSet;

public final class MethodInfoList {
    private ConstantPool d_cp;
    private int d_numMethods;
    private MethodInfo[] d_methods;

    public MethodInfo get(int n) {
        return this.d_methods[n];
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("METHODS:\n");
        if (this.d_numMethods == 0) {
            stringBuffer.append("  <none>\n");
        } else {
            int n = 0;
            while (n < this.d_numMethods) {
                stringBuffer.append("  " + this.d_methods[n]);
                ++n;
            }
        }
        return stringBuffer.toString();
    }

    MethodInfoList(ConstantPool constantPool) {
        this.d_cp = constantPool;
        this.d_numMethods = 0;
        this.d_methods = null;
    }

    void read(DataInputStream dataInputStream) throws IOException {
        this.d_numMethods = dataInputStream.readShort();
        this.d_methods = new MethodInfo[this.d_numMethods];
        int n = 0;
        while (n < this.d_numMethods) {
            this.d_methods[n] = new MethodInfo(this.d_cp);
            this.d_methods[n].read(dataInputStream);
            ++n;
        }
    }

    public MethodInfo add(String string) {
        if (this.d_methods == null || this.d_numMethods == this.d_methods.length) {
            this.resize();
        }
        this.d_methods[this.d_numMethods] = new MethodInfo(this.d_cp, string);
        ++this.d_numMethods;
        return this.d_methods[this.d_numMethods - 1];
    }

    public void sort(int[] nArray) {
        int n = 0;
        while (n < this.d_numMethods) {
            this.d_methods[n].sort(nArray);
            ++n;
        }
    }

    private void resize() {
        MethodInfo[] methodInfoArray = new MethodInfo[this.d_numMethods + 10];
        if (this.d_methods != null) {
            System.arraycopy(this.d_methods, 0, methodInfoArray, 0, this.d_numMethods);
        }
        this.d_methods = methodInfoArray;
    }

    void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.d_numMethods);
        int n = 0;
        while (n < this.d_numMethods) {
            this.d_methods[n].write(dataOutputStream);
            ++n;
        }
    }

    public BitSet uses() {
        BitSet bitSet = new BitSet(this.d_cp.length());
        int n = 0;
        while (n < this.d_numMethods) {
            bitSet.or(this.d_methods[n].uses());
            ++n;
        }
        return bitSet;
    }

    public int length() {
        return this.d_numMethods;
    }

    public void remove(int n) {
        if (n < 0 || n > this.d_numMethods - 1) {
            return;
        }
        int n2 = n;
        while (n2 < this.d_numMethods - 1) {
            this.d_methods[n2] = this.d_methods[n2 + 1];
            ++n2;
        }
        this.d_numMethods += -1;
    }

    public String getMethodName(int n) {
        if (n < 0 || n > this.d_numMethods) {
            return null;
        }
        return this.d_methods[n].getName();
    }
}

