/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.toad.cfparse.attributes;

import com.ibm.toad.cfparse.ConstantPool;
import com.ibm.toad.cfparse.attributes.AttrInfo;
import com.ibm.toad.cfparse.attributes.CodeAttrInfo;
import com.ibm.toad.cfparse.attributes.ConstantValueAttrInfo;
import com.ibm.toad.cfparse.attributes.DeprecatedAttrInfo;
import com.ibm.toad.cfparse.attributes.ExceptionAttrInfo;
import com.ibm.toad.cfparse.attributes.InnerClassesAttrInfo;
import com.ibm.toad.cfparse.attributes.LineNumberAttrInfo;
import com.ibm.toad.cfparse.attributes.LocalVariableAttrInfo;
import com.ibm.toad.cfparse.attributes.SourceDirAttrInfo;
import com.ibm.toad.cfparse.attributes.SourceFileAttrInfo;
import com.ibm.toad.cfparse.attributes.SyntheticAttrInfo;
import com.ibm.toad.cfparse.attributes.UnknownAttrInfo;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.BitSet;

public final class AttrInfoList {
    private ConstantPool d_cp;
    private int d_numAttrs;
    private AttrInfo[] d_attrs;
    private int d_depth;
    private static /* synthetic */ Class class$com$ibm$toad$cfparse$ConstantPool;

    public AttrInfo get(int n) {
        if (n < 0 || n > this.d_attrs.length - 1) {
            return null;
        }
        return this.d_attrs[n];
    }

    public AttrInfo get(String string) {
        int n = 0;
        while (n < this.d_numAttrs) {
            if (this.d_attrs[n].getName().equals(string)) {
                return this.d_attrs[n];
            }
            ++n;
        }
        return null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.d_numAttrs > 0) {
            this.d_depth += -1;
            stringBuffer.append(this.sindent());
            ++this.d_depth;
            stringBuffer.append("ATTRIBUTES:\n");
            int n = 0;
            while (n < this.d_numAttrs) {
                stringBuffer.append(this.d_attrs[n] + "\n");
                ++n;
            }
        }
        return stringBuffer.toString();
    }

    public AttrInfoList(ConstantPool constantPool, int n) {
        this.d_cp = constantPool;
        this.d_numAttrs = 0;
        this.d_attrs = null;
        this.d_depth = n;
    }

    private String sindent() {
        String string = "";
        int n = 0;
        while (n < this.d_depth) {
            string = string + "  ";
            ++n;
        }
        return string;
    }

    public AttrInfo add(String string) {
        int n = 0;
        if (this.d_attrs == null || this.d_numAttrs == this.d_attrs.length) {
            this.resize();
        }
        if ((n = this.d_cp.find(1, string)) == -1) {
            n = this.d_cp.addUtf8(string);
        }
        if (string.equals("SourceFile")) {
            this.d_attrs[this.d_numAttrs] = new SourceFileAttrInfo(this.d_cp, n, this.d_depth);
        } else if (string.equals("SourceDir")) {
            this.d_attrs[this.d_numAttrs] = new SourceDirAttrInfo(this.d_cp, n, this.d_depth);
        } else if (string.equals("ConstantValue")) {
            this.d_attrs[this.d_numAttrs] = new ConstantValueAttrInfo(this.d_cp, n, this.d_depth);
        } else if (string.equals("Code")) {
            this.d_attrs[this.d_numAttrs] = new CodeAttrInfo(this.d_cp, n, this.d_depth);
        } else if (string.equals("Exceptions")) {
            this.d_attrs[this.d_numAttrs] = new ExceptionAttrInfo(this.d_cp, n, this.d_depth);
        } else if (string.equals("LineNumberTable")) {
            this.d_attrs[this.d_numAttrs] = new LineNumberAttrInfo(this.d_cp, n, this.d_depth);
        } else if (string.equals("LocalVariableTable")) {
            this.d_attrs[this.d_numAttrs] = new LocalVariableAttrInfo(this.d_cp, n, this.d_depth);
        } else if (string.equals("InnerClasses")) {
            this.d_attrs[this.d_numAttrs] = new InnerClassesAttrInfo(this.d_cp, n, this.d_depth);
        } else if (string.equals("Synthetic")) {
            this.d_attrs[this.d_numAttrs] = new SyntheticAttrInfo(this.d_cp, n, this.d_depth);
        } else if (string.equals("Deprecated")) {
            this.d_attrs[this.d_numAttrs] = new DeprecatedAttrInfo(this.d_cp, n, this.d_depth);
        } else {
            try {
                Class<?> clazz = Class.forName(string + "AttrInfo");
                Constructor<?> constructor = clazz.getConstructor(class$com$ibm$toad$cfparse$ConstantPool != null ? class$com$ibm$toad$cfparse$ConstantPool : (class$com$ibm$toad$cfparse$ConstantPool = AttrInfoList.class$("com.ibm.toad.cfparse.ConstantPool")), Integer.TYPE, Integer.TYPE);
                this.d_attrs[this.d_numAttrs] = (AttrInfo)constructor.newInstance(this.d_cp, new Integer(n), new Integer(this.d_depth));
            }
            catch (Exception exception) {
                this.d_attrs[this.d_numAttrs] = new UnknownAttrInfo(this.d_cp, n, this.d_depth);
            }
        }
        ++this.d_numAttrs;
        return this.d_attrs[this.d_numAttrs - 1];
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        this.d_numAttrs = dataInputStream.readShort();
        this.d_attrs = new AttrInfo[this.d_numAttrs];
        int n = 0;
        while (n < this.d_numAttrs) {
            short s = dataInputStream.readShort();
            String string = this.d_cp.getAsString(s);
            if (string.equals("SourceFile")) {
                this.d_attrs[n] = new SourceFileAttrInfo(this.d_cp, s, this.d_depth);
            } else if (string.equals("ConstantValue")) {
                this.d_attrs[n] = new ConstantValueAttrInfo(this.d_cp, s, this.d_depth);
            } else if (string.equals("Code")) {
                this.d_attrs[n] = new CodeAttrInfo(this.d_cp, s, this.d_depth);
            } else if (string.equals("Exceptions")) {
                this.d_attrs[n] = new ExceptionAttrInfo(this.d_cp, s, this.d_depth);
            } else if (string.equals("LineNumberTable")) {
                this.d_attrs[n] = new LineNumberAttrInfo(this.d_cp, s, this.d_depth);
            } else if (string.equals("LocalVariableTable")) {
                this.d_attrs[n] = new LocalVariableAttrInfo(this.d_cp, s, this.d_depth);
            } else if (string.equals("InnerClasses")) {
                this.d_attrs[n] = new InnerClassesAttrInfo(this.d_cp, s, this.d_depth);
            } else if (string.equals("SourceDir")) {
                this.d_attrs[n] = new SourceDirAttrInfo(this.d_cp, s, this.d_depth);
            } else if (string.equals("Synthetic")) {
                this.d_attrs[n] = new SyntheticAttrInfo(this.d_cp, s, this.d_depth);
            } else if (string.equals("Deprecated")) {
                this.d_attrs[n] = new DeprecatedAttrInfo(this.d_cp, s, this.d_depth);
            } else {
                try {
                    Class<?> clazz = Class.forName(string + "AttrInfo");
                    Constructor<?> constructor = clazz.getConstructor(class$com$ibm$toad$cfparse$ConstantPool != null ? class$com$ibm$toad$cfparse$ConstantPool : AttrInfoList.class$("com.ibm.toad.cfparse.ConstantPool"), Integer.TYPE, Integer.TYPE);
                    this.d_attrs[n] = (AttrInfo)constructor.newInstance(this.d_cp, new Integer(s), new Integer(this.d_depth));
                }
                catch (Exception exception) {
                    this.d_attrs[n] = new UnknownAttrInfo(this.d_cp, s, this.d_depth);
                }
            }
            this.d_attrs[n].read(dataInputStream);
            ++n;
        }
    }

    public void sort(int[] nArray) {
        int n = 0;
        while (n < this.d_numAttrs) {
            this.d_attrs[n].sort(nArray);
            ++n;
        }
    }

    private void resize() {
        AttrInfo[] attrInfoArray = new AttrInfo[this.d_numAttrs + 10];
        if (this.d_attrs != null) {
            System.arraycopy(this.d_attrs, 0, attrInfoArray, 0, this.d_numAttrs);
        }
        this.d_attrs = attrInfoArray;
    }

    public int size() {
        int n = 2;
        int n2 = 0;
        while (n2 < this.d_numAttrs) {
            n += this.d_attrs[n2].size();
            ++n2;
        }
        return n;
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.d_numAttrs);
        int n = 0;
        while (n < this.d_numAttrs) {
            this.d_attrs[n].write(dataOutputStream);
            ++n;
        }
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BitSet uses() {
        BitSet bitSet = new BitSet(this.d_cp.length());
        int n = 0;
        while (n < this.d_numAttrs) {
            bitSet.or(this.d_attrs[n].uses());
            ++n;
        }
        return bitSet;
    }

    public String getName(int n) {
        if (n < 0 || n > this.d_attrs.length - 1) {
            return null;
        }
        return this.d_attrs[n].getName();
    }

    int depth() {
        return this.d_depth;
    }

    public int length() {
        return this.d_numAttrs;
    }

    public void remove(String string) {
        int n = 0;
        while (n < this.d_numAttrs) {
            if (this.d_attrs[n].getName().equals(string)) {
                this.remove(n);
            }
            ++n;
        }
    }

    public void remove(int n) {
        if (n < 0 || n > this.d_numAttrs - 1) {
            return;
        }
        int n2 = n;
        while (n2 < this.d_numAttrs - 1) {
            this.d_attrs[n2] = this.d_attrs[n2 + 1];
            ++n2;
        }
        this.d_numAttrs += -1;
    }
}

