/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.toad.cfparse.attributes;

import com.ibm.toad.cfparse.ConstantPool;
import com.ibm.toad.cfparse.attributes.AttrInfo;
import com.ibm.toad.cfparse.attributes.AttrInfoList;
import com.ibm.toad.cfparse.instruction.BaseInstruction;
import com.ibm.toad.cfparse.instruction.CodeViewer;
import com.ibm.toad.cfparse.instruction.ImmutableCodeSegment;
import com.ibm.toad.cfparse.instruction.InstructionFactory;
import com.ibm.toad.cfparse.instruction.InstructionFormatException;
import com.ibm.toad.cfparse.instruction.MutableCodeSegment;
import com.ibm.toad.cfparse.instruction.TagFactory;
import com.ibm.toad.cfparse.utils.ByteArray;
import com.ibm.toad.cfparse.utils.CPUtils;
import com.ibm.toad.utils.D;
import com.ibm.toad.utils.HexDump;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.BitSet;
import java.util.Vector;

public final class CodeAttrInfo
extends AttrInfo {
    private int d_maxStack;
    private int d_maxLocals;
    private static CodeViewer d_viewer;
    private byte[] d_code;
    private int d_numExceptions;
    private ExceptionInfo[] d_exceptions;
    private AttrInfoList d_attrs;

    public void setException(ExceptionInfo exceptionInfo, int n) {
        if (n < 0 || n > this.d_numExceptions) {
            return;
        }
        this.d_exceptions[n] = exceptionInfo;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.sindent() + "Attribute: " + this.d_cp.getAsString(this.d_idxName) + "\n" + this.sindent() + "// max_stack: " + this.d_maxStack + "\n" + this.sindent() + "// max_locals: " + this.d_maxLocals + "\n");
        if (d_viewer != null) {
            stringBuffer.append(d_viewer.view(this.d_cp, this.d_code, this.d_exceptions, this.d_numExceptions, this.sindent()));
        } else {
            stringBuffer.append(HexDump.toBytes(this.d_code));
            stringBuffer.append(this.sindent() + "Exception Table:\n");
            if (this.d_numExceptions == 0) {
                stringBuffer.append(this.sindent() + "  <none>\n");
            } else {
                int n = 0;
                while (n < this.d_numExceptions) {
                    stringBuffer.append(this.sindent() + this.d_exceptions[n] + "\n");
                    ++n;
                }
            }
        }
        stringBuffer.append(this.d_attrs + "\n");
        return stringBuffer.toString();
    }

    CodeAttrInfo(ConstantPool constantPool, int n, int n2) {
        super(constantPool, n, n2);
        this.d_len = 0;
        this.d_maxStack = 2;
        this.d_maxLocals = 2;
        this.d_numExceptions = 0;
        this.d_code = new byte[0];
        this.d_exceptions = null;
        this.d_attrs = new AttrInfoList(constantPool, this.d_depth + 1);
    }

    protected void read(DataInputStream dataInputStream) throws IOException {
        this.d_len = dataInputStream.readInt();
        this.d_maxStack = dataInputStream.readShort();
        this.d_maxLocals = dataInputStream.readShort();
        int n = dataInputStream.readInt();
        this.d_code = new byte[n];
        dataInputStream.readFully(this.d_code);
        this.d_numExceptions = dataInputStream.readShort();
        this.d_exceptions = new ExceptionInfo[this.d_numExceptions];
        int n2 = 0;
        while (n2 < this.d_numExceptions) {
            this.d_exceptions[n2] = new ExceptionInfo(this.d_cp);
            this.d_exceptions[n2].read(dataInputStream);
            ++n2;
        }
        this.d_attrs.read(dataInputStream);
        D.assert(this.d_len == 8 + n + 2 + this.d_numExceptions * 8 + this.d_attrs.size(), "d_len != 2 + 2 + 4 + codeLen + 2 + d_numExceptions * 8 + d_attrs.size()\n" + this.d_len + " != 2 + 2 + 4 + " + n + " + 2 + " + this.d_numExceptions + " * 8 + " + this.d_attrs.size());
    }

    public int getMaxLocals() {
        return this.d_maxLocals;
    }

    public void setMaxLocals(int n) {
        this.d_maxLocals = n;
    }

    protected void sort(int[] nArray) {
        super.sort(nArray);
        if (this.d_exceptions != null) {
            int n = 0;
            while (n < this.d_exceptions.length) {
                this.d_exceptions[n].sort(nArray);
                ++n;
            }
        }
        MutableCodeSegment mutableCodeSegment = new MutableCodeSegment(this.d_cp, this, false);
        mutableCodeSegment.setInstructionFactory(new RawByteInstructionFactory());
        Vector vector = mutableCodeSegment.getInstructions();
        int n = 0;
        while (n < vector.size()) {
            BaseInstruction baseInstruction = (BaseInstruction)vector.get(n);
            byte[] byArray = baseInstruction.getCode(null, 0);
            int n2 = byArray[0] & 0xFF;
            switch (n2) {
                case 18: {
                    byte[] byArray2;
                    int n3 = nArray[ByteArray.getByteAtOffset(byArray, 1)];
                    if (n3 > 255) {
                        byArray2 = new byte[]{19, (byte)(n3 >>> 8 & 0xFF), (byte)(n3 & 0xFF)};
                        byArray = byArray2;
                    } else {
                        byArray[1] = (byte)n3;
                    }
                    vector.set(n, new RawByteInstr(byArray, baseInstruction.getTag()));
                    break;
                }
                case 20: 
                case 178: 
                case 179: 
                case 180: 
                case 181: 
                case 182: 
                case 183: 
                case 184: 
                case 185: 
                case 187: 
                case 189: 
                case 192: 
                case 193: 
                case 197: {
                    int n3 = nArray[ByteArray.getShortAtOffset(byArray, 1)];
                    byArray[1] = (byte)(n3 >>> 8 & 0xFF);
                    byArray[2] = (byte)(n3 & 0xFF);
                    vector.set(n, new RawByteInstr(byArray, baseInstruction.getTag()));
                    break;
                }
                case 19: {
                    byte[] byArray2;
                    int n3 = nArray[ByteArray.getShortAtOffset(byArray, 1)];
                    if (n3 < 255) {
                        byArray2 = new byte[]{18, (byte)n3};
                        byArray = byArray2;
                    } else {
                        byArray[1] = (byte)(n3 >>> 8 & 0xFF);
                        byArray[2] = (byte)(n3 & 0xFF);
                    }
                    vector.set(n, new RawByteInstr(byArray, baseInstruction.getTag()));
                    break;
                }
            }
            ++n;
        }
        this.setCode(mutableCodeSegment.getCode());
        if (this.d_exceptions != null) {
            this.d_exceptions = mutableCodeSegment.getExcTable();
        }
        this.d_attrs.sort(nArray);
    }

    public static void setViewer(CodeViewer codeViewer) {
        d_viewer = codeViewer;
    }

    private BitSet codeUses() {
        BitSet bitSet = new BitSet(this.d_cp.length());
        ImmutableCodeSegment immutableCodeSegment = new ImmutableCodeSegment(this.d_code);
        int n = 0;
        while (n < immutableCodeSegment.getNumInstructions()) {
            int n2 = immutableCodeSegment.getOffset(n);
            int n3 = this.d_code[n2] & 0xFF;
            switch (n3) {
                case 18: {
                    bitSet.set(ByteArray.getByteAtOffset(this.d_code, 1 + n2));
                    break;
                }
                case 19: 
                case 20: 
                case 178: 
                case 179: 
                case 180: 
                case 181: 
                case 182: 
                case 183: 
                case 184: 
                case 185: 
                case 187: 
                case 189: 
                case 192: 
                case 193: 
                case 197: {
                    bitSet.set(ByteArray.getShortAtOffset(this.d_code, 1 + n2));
                    break;
                }
            }
            ++n;
        }
        return bitSet;
    }

    private void resize() {
        ExceptionInfo[] exceptionInfoArray = new ExceptionInfo[this.d_numExceptions + 10];
        if (this.d_exceptions != null) {
            System.arraycopy(this.d_exceptions, 0, exceptionInfoArray, 0, this.d_numExceptions);
        }
        this.d_exceptions = exceptionInfoArray;
    }

    protected int size() {
        return 8 + this.d_code.length + 2 + this.d_numExceptions * 8 + this.d_attrs.size();
    }

    protected void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.d_idxName);
        dataOutputStream.writeInt(8 + this.d_code.length + 2 + this.d_numExceptions * 8 + this.d_attrs.size());
        dataOutputStream.writeShort(this.d_maxStack);
        dataOutputStream.writeShort(this.d_maxLocals);
        dataOutputStream.writeInt(this.d_code.length);
        dataOutputStream.write(this.d_code, 0, this.d_code.length);
        dataOutputStream.writeShort(this.d_numExceptions);
        int n = 0;
        while (n < this.d_numExceptions) {
            this.d_exceptions[n].write(dataOutputStream);
            ++n;
        }
        this.d_attrs.write(dataOutputStream);
    }

    public AttrInfoList getAttrs() {
        return this.d_attrs;
    }

    public void setAttrs(AttrInfoList attrInfoList) {
        this.d_attrs = attrInfoList;
    }

    protected BitSet uses() {
        BitSet bitSet = super.uses();
        bitSet.or(this.codeUses());
        if (this.d_exceptions != null) {
            int n = 0;
            while (n < this.d_exceptions.length) {
                String string = this.d_exceptions[n].getCatchType();
                if (!string.equals("all")) {
                    int n2 = this.d_cp.find(7, CPUtils.dots2slashes(string));
                    D.assert(n2 != -1, "Couldn't find " + CPUtils.dots2slashes(string) + "+in ConstantPool");
                    bitSet.set(n2);
                }
                ++n;
            }
        }
        bitSet.or(this.d_attrs.uses());
        return bitSet;
    }

    public int getNumExceptions() {
        return this.d_numExceptions;
    }

    public ExceptionInfo[] getExceptions() {
        return this.d_exceptions;
    }

    public void setExceptions(ExceptionInfo[] exceptionInfoArray) {
        this.d_exceptions = exceptionInfoArray;
        this.d_numExceptions = exceptionInfoArray == null ? 0 : exceptionInfoArray.length;
    }

    public int getMaxStack() {
        return this.d_maxStack;
    }

    public void setMaxStack(int n) {
        this.d_maxStack = n;
    }

    public void createExceptionBlock(int n, int n2, int n3, String string) {
        if (this.d_exceptions == null || this.d_numExceptions == this.d_exceptions.length) {
            this.resize();
        }
        this.d_exceptions[this.d_numExceptions] = new ExceptionInfo(this.d_cp, n, n2, n3, string);
        ++this.d_numExceptions;
    }

    public void setCode(byte[] byArray) {
        D.assert(this.d_code != null, "cannot set null code segment");
        this.d_code = byArray;
    }

    public byte[] getCode() {
        return this.d_code;
    }

    public ExceptionInfo getException(int n) {
        if (n < 0 || n > this.d_numExceptions) {
            return null;
        }
        return this.d_exceptions[n];
    }

    public static class ExceptionInfo {
        private ConstantPool d_cp;
        private int d_startPC;
        private int d_endPC;
        private int d_handlerPC;
        private int d_catchType;

        public int getHandler() {
            return this.d_handlerPC;
        }

        public void setHandler(int n) {
            this.d_handlerPC = n;
        }

        public int getEnd() {
            return this.d_endPC;
        }

        public void setEnd(int n) {
            this.d_endPC = n;
        }

        public String toString() {
            return "(" + this.d_startPC + "," + this.d_endPC + ") ->" + this.d_handlerPC + " on " + (this.d_catchType == 0 ? "all" : this.d_cp.getAsJava(this.d_catchType));
        }

        ExceptionInfo(ConstantPool constantPool) {
            this.d_cp = constantPool;
        }

        public ExceptionInfo(ConstantPool constantPool, int n, int n2, int n3, int n4) {
            this.d_cp = constantPool;
            this.d_startPC = n;
            this.d_endPC = n2;
            this.d_handlerPC = n3;
            this.d_catchType = n4;
        }

        public ExceptionInfo(ConstantPool constantPool, int n, int n2, int n3, String string) {
            this.d_cp = constantPool;
            this.d_startPC = n;
            this.d_endPC = n2;
            this.d_handlerPC = n3;
            if (string.equals("all")) {
                this.d_catchType = 0;
            } else {
                this.d_catchType = this.d_cp.find(7, CPUtils.dots2slashes(string));
                if (this.d_catchType == -1) {
                    this.d_catchType = this.d_cp.addClass(CPUtils.dots2slashes(string));
                }
            }
        }

        protected void read(DataInputStream dataInputStream) throws IOException {
            this.d_startPC = dataInputStream.readShort();
            this.d_endPC = dataInputStream.readShort();
            this.d_handlerPC = dataInputStream.readShort();
            this.d_catchType = dataInputStream.readShort();
        }

        public int getStart() {
            return this.d_startPC;
        }

        public void setStart(int n) {
            this.d_startPC = n;
        }

        protected void sort(int[] nArray) {
            if (this.d_catchType != 0) {
                this.d_catchType = nArray[this.d_catchType];
            }
        }

        public int getCatch() {
            return this.d_catchType;
        }

        public String getCatchType() {
            if (this.d_catchType == 0) {
                return "all";
            }
            return this.d_cp.getAsJava(this.d_catchType);
        }

        public void setCatchType(String string) {
            if (string.equals("all")) {
                this.d_catchType = 0;
            } else {
                this.d_catchType = this.d_cp.find(7, CPUtils.dots2slashes(string));
                if (this.d_catchType == -1) {
                    this.d_catchType = this.d_cp.addClass(CPUtils.dots2slashes(string));
                }
            }
        }

        protected void write(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeShort(this.d_startPC);
            dataOutputStream.writeShort(this.d_endPC);
            dataOutputStream.writeShort(this.d_handlerPC);
            dataOutputStream.writeShort(this.d_catchType);
        }

        public boolean equals(Object object) {
            if (!(object instanceof ExceptionInfo)) {
                return false;
            }
            ExceptionInfo exceptionInfo = (ExceptionInfo)object;
            return exceptionInfo.getStart() == this.d_startPC && exceptionInfo.getEnd() == this.d_endPC && exceptionInfo.getCatchType().equals(this.getCatchType()) && exceptionInfo.getHandler() == this.d_handlerPC;
        }
    }

    class RawByteInstructionFactory
    implements InstructionFactory {
        public BaseInstruction create(TagFactory tagFactory, ConstantPool constantPool, byte[] byArray, int n, int n2) {
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, n, byArray2, 0, n2);
            return new RawByteInstr(byArray2, null);
        }

        public BaseInstruction create(TagFactory tagFactory, ConstantPool constantPool, String string) throws InstructionFormatException {
            throw new InstructionFormatException("Cannot create RawByteInstr from String..");
        }

        RawByteInstructionFactory() {
            CodeAttrInfo.this.getClass();
        }
    }

    class RawByteInstr
    implements BaseInstruction {
        byte[] d_code;
        String d_tag;

        RawByteInstr(byte[] byArray, String string) {
            CodeAttrInfo.this.getClass();
            this.d_code = byArray;
            this.d_tag = string;
        }

        public int getOpCode() {
            return this.d_code[0] & 0xFF;
        }

        public String getTag() {
            return this.d_tag;
        }

        public void setTag(String string) {
            this.d_tag = string;
        }

        public int getLength(int n) {
            return this.d_code.length;
        }

        public byte[] getCode(int[] nArray, int n) {
            return this.d_code;
        }
    }
}

