/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.toad.cfparse.attributes;

import com.ibm.toad.cfparse.ConstantPool;
import com.ibm.toad.cfparse.attributes.AttrInfo;
import com.ibm.toad.utils.D;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.BitSet;

public final class ExceptionAttrInfo
extends AttrInfo {
    private int d_numExceptions;
    private int[] d_exceptions;

    public String get(int n) {
        if (n < 0 || n >= this.d_numExceptions || this.d_exceptions[n] == 0) {
            return "";
        }
        return this.d_cp.getAsJava(this.d_exceptions[n]);
    }

    public void set(int n, String string) {
        if (n < 0 || n >= this.d_numExceptions || this.d_exceptions[n] == 0) {
            return;
        }
        this.d_cp.editClass(this.d_exceptions[n], string);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.sindent() + "Attribute: " + this.d_cp.getAsString(this.d_idxName) + ": ");
        int n = 0;
        while (n < this.d_numExceptions) {
            if (this.d_exceptions[n] != 0) {
                stringBuffer.append(", " + this.d_cp.getAsJava(this.d_exceptions[n]));
            }
            ++n;
        }
        return stringBuffer.append("\n").toString();
    }

    ExceptionAttrInfo(ConstantPool constantPool, int n, int n2) {
        super(constantPool, n, n2);
        this.d_len = 0;
        this.d_numExceptions = 0;
        this.d_exceptions = null;
    }

    public void add(String string) {
        if (this.d_exceptions == null || this.d_numExceptions == this.d_exceptions.length) {
            this.resize();
        }
        this.d_exceptions[this.d_numExceptions] = this.d_cp.addClass(string);
        ++this.d_numExceptions;
    }

    protected void read(DataInputStream dataInputStream) throws IOException {
        this.d_len = dataInputStream.readInt();
        this.d_numExceptions = dataInputStream.readShort();
        D.assert(this.d_len == 2 + this.d_numExceptions * 2, "d_len != 2 + (d_numExceptions * 2)\n" + this.d_len + " != 2 + (" + this.d_numExceptions + "* 2)\n");
        this.d_exceptions = new int[this.d_numExceptions];
        int n = 0;
        while (n < this.d_numExceptions) {
            this.d_exceptions[n] = dataInputStream.readShort();
            ++n;
        }
    }

    protected void sort(int[] nArray) {
        super.sort(nArray);
        int n = 0;
        while (n < this.d_numExceptions) {
            this.d_exceptions[n] = nArray[this.d_exceptions[n]];
            ++n;
        }
    }

    private void resize() {
        int[] nArray = new int[this.d_numExceptions + 10];
        if (this.d_exceptions != null) {
            System.arraycopy(this.d_exceptions, 0, nArray, 0, this.d_numExceptions);
        }
        this.d_exceptions = nArray;
    }

    protected void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.d_idxName);
        dataOutputStream.writeInt(2 + this.d_numExceptions * 2);
        dataOutputStream.writeShort(this.d_numExceptions);
        int n = 0;
        while (n < this.d_numExceptions) {
            dataOutputStream.writeShort(this.d_exceptions[n]);
            ++n;
        }
    }

    protected BitSet uses() {
        BitSet bitSet = super.uses();
        int n = 0;
        while (n < this.d_numExceptions) {
            bitSet.set(this.d_exceptions[n]);
            ++n;
        }
        return bitSet;
    }

    public int length() {
        return this.d_numExceptions;
    }

    public void remove(int n) {
        if (n < 0 || n >= this.d_numExceptions) {
            return;
        }
        int n2 = n;
        while (n2 < this.d_numExceptions - 1) {
            this.d_exceptions[n2] = this.d_exceptions[n2 + 1];
            ++n2;
        }
        this.d_numExceptions += -1;
    }
}

