/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.toad.cfparse.attributes;

import com.ibm.toad.cfparse.ConstantPool;
import com.ibm.toad.cfparse.attributes.AttrInfo;
import com.ibm.toad.utils.D;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class LineNumberAttrInfo
extends AttrInfo {
    private int d_numVars = 0;
    private int[] d_varTable;

    public void setLineNumber(int n, int n2) {
        if (n < 0 || n >= this.d_numVars) {
            return;
        }
        this.d_varTable[2 * n + 1] = n2;
    }

    public int getLineNumber(int n) {
        if (n < 0 || n >= this.d_numVars) {
            return -1;
        }
        return this.d_varTable[2 * n + 1];
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.sindent() + "Attribute: " + this.d_cp.getAsString(this.d_idxName) + ": \n");
        int n = 0;
        while (n < this.d_numVars) {
            int n2 = this.d_varTable[n * 2];
            int n3 = this.d_varTable[n * 2 + 1];
            stringBuffer.append(this.sindent() + "  line " + n3 + ": " + n2 + "\n");
            ++n;
        }
        return stringBuffer.toString();
    }

    LineNumberAttrInfo(ConstantPool constantPool, int n, int n2) {
        super(constantPool, n, n2);
    }

    protected void read(DataInputStream dataInputStream) throws IOException {
        this.d_len = dataInputStream.readInt();
        this.d_numVars = dataInputStream.readShort();
        D.assert(this.d_len == 2 + this.d_numVars * 4, "d_len != 2 + (d_numVars * 4)\n" + this.d_len + " != 2 + (" + this.d_numVars + "* 4)\n");
        this.d_varTable = new int[this.d_numVars * 2];
        int n = 0;
        while (n < this.d_varTable.length) {
            this.d_varTable[n] = dataInputStream.readShort();
            ++n;
        }
    }

    public void add(int n, int n2) {
        int n3 = 0;
        while (n3 < this.d_numVars) {
            if (this.d_varTable[2 * n3] == n2) {
                this.d_varTable[2 * n3 + 1] = n;
                return;
            }
            ++n3;
        }
        if (this.d_varTable == null || this.d_numVars * 2 >= this.d_varTable.length) {
            this.resize();
        }
        this.d_varTable[this.d_numVars * 2] = n2;
        this.d_varTable[this.d_numVars * 2 + 1] = n;
        ++this.d_numVars;
    }

    protected int size() {
        return 8 + this.d_numVars * 4;
    }

    private void resize() {
        int[] nArray = new int[this.d_numVars * 2 + 10];
        if (this.d_varTable != null) {
            System.arraycopy(this.d_varTable, 0, nArray, 0, this.d_numVars * 2);
        }
        this.d_varTable = nArray;
    }

    public int getStartPC(int n) {
        if (n < 0 || n >= this.d_numVars) {
            return -1;
        }
        return this.d_varTable[2 * n];
    }

    public void setStartPC(int n, int n2) {
        if (n < 0 || n >= this.d_numVars) {
            return;
        }
        this.d_varTable[2 * n] = n2;
    }

    protected void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.d_idxName);
        dataOutputStream.writeInt(2 + this.d_numVars * 4);
        dataOutputStream.writeShort(this.d_numVars);
        int n = 0;
        while (n < this.d_numVars * 2) {
            dataOutputStream.writeShort(this.d_varTable[n]);
            ++n;
        }
    }

    public void clear() {
        this.d_numVars = 0;
        this.d_varTable = null;
    }

    public int length() {
        return this.d_numVars;
    }
}

