/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.toad.cfparse.instruction;

import com.ibm.toad.cfparse.ConstantPool;
import com.ibm.toad.cfparse.instruction.BaseInstruction;
import com.ibm.toad.cfparse.instruction.InstructionFormatException;
import com.ibm.toad.cfparse.instruction.JVMInstruction;
import com.ibm.toad.cfparse.instruction.TagFactory;
import com.ibm.toad.cfparse.utils.ByteArray;
import java.util.BitSet;

final class ByteInstruction
implements BaseInstruction {
    private int d_opCode;
    private byte[] d_code;
    private BitSet d_uses;
    private String d_tag;
    private ConstantPool d_cp;
    private TagFactory d_fac;
    private boolean marked = false;

    public String toString() {
        StringBuffer stringBuffer;
        block4: {
            JVMInstruction jVMInstruction;
            block6: {
                block5: {
                    block3: {
                        jVMInstruction = JVMInstruction.d_instrTable[this.d_opCode];
                        stringBuffer = new StringBuffer(jVMInstruction.name() + " ");
                        if (this.d_opCode != 170) break block3;
                        int n = 1;
                        this.sprintOperand(stringBuffer, n, 'A');
                        stringBuffer.append(" ");
                        int n2 = ByteArray.getIntAtOffset(this.d_code, n += 4);
                        this.sprintOperand(stringBuffer, n, 'l');
                        stringBuffer.append("-");
                        int n3 = ByteArray.getIntAtOffset(this.d_code, n += 4);
                        this.sprintOperand(stringBuffer, n, 'l');
                        n += 4;
                        stringBuffer.append(" ");
                        int n4 = n2;
                        while (n4 <= n3) {
                            this.sprintOperand(stringBuffer, n, 'A');
                            n += 4;
                            stringBuffer.append(" ");
                            ++n4;
                        }
                        break block4;
                    }
                    if (this.d_opCode != 171) break block5;
                    int n = 1;
                    this.sprintOperand(stringBuffer, n, 'A');
                    stringBuffer.append(" ");
                    int n5 = ByteArray.getIntAtOffset(this.d_code, n += 4);
                    this.sprintOperand(stringBuffer, n, 'l');
                    n += 4;
                    stringBuffer.append(" ");
                    int n6 = 0;
                    while (n6 < n5) {
                        stringBuffer.append("(");
                        this.sprintOperand(stringBuffer, n, 'l');
                        stringBuffer.append(", ");
                        this.sprintOperand(stringBuffer, n += 4, 'A');
                        n += 4;
                        stringBuffer.append(") ");
                        ++n6;
                    }
                    break block4;
                }
                if (this.d_opCode != 196) break block6;
                int n = ByteArray.getByteAtOffset(this.d_code, 1);
                JVMInstruction jVMInstruction2 = JVMInstruction.d_instrTable[n];
                stringBuffer.append(jVMInstruction2.name() + " ");
                this.sprintOperand(stringBuffer, 2, 'V');
                stringBuffer.append(" ");
                if (n != 132) break block4;
                this.sprintOperand(stringBuffer, 4, 'I');
                break block4;
            }
            int n = 1;
            int n7 = jVMInstruction.d_operandTypes.length();
            int n8 = 0;
            while (n8 < n7) {
                this.sprintOperand(stringBuffer, n, jVMInstruction.d_operandTypes.charAt(n8));
                n += JVMInstruction.argSkip(jVMInstruction.d_operandTypes.charAt(n8));
                stringBuffer.append(" ");
                ++n8;
            }
        }
        return stringBuffer.toString();
    }

    ByteInstruction(TagFactory tagFactory, ConstantPool constantPool, byte[] byArray, int n, int n2) {
        this.d_cp = constantPool;
        this.d_code = new byte[n2];
        System.arraycopy(byArray, n, this.d_code, 0, n2);
        this.d_opCode = byArray[n] & 0xFF;
        this.d_fac = tagFactory;
        this.d_tag = null;
    }

    public int getOpCode() {
        return this.d_code[0] & 0xFF;
    }

    ByteInstruction(TagFactory tagFactory, ConstantPool constantPool, String string) throws InstructionFormatException {
        throw new InstructionFormatException("Cannot create ByteInstruction from String...");
    }

    void sprintOperand(StringBuffer stringBuffer, int n, char c) {
        int n2 = 0;
        switch (c) {
            case 'c': {
                n2 = ByteArray.getByteAtOffset(this.d_code, n);
                stringBuffer.append(this.d_cp.getAsJava(n2));
                break;
            }
            case 'C': {
                n2 = ByteArray.getShortAtOffset(this.d_code, n);
                stringBuffer.append(this.d_cp.getAsJava(n2));
                break;
            }
            case 'v': {
                n2 = ByteArray.getByteAtOffset(this.d_code, n);
                stringBuffer.append("v" + n2);
                break;
            }
            case 'V': {
                n2 = ByteArray.getShortAtOffset(this.d_code, n);
                stringBuffer.append("v" + n2);
                break;
            }
            case '0': 
            case 'i': {
                n2 = ByteArray.getByteAtOffset(this.d_code, n);
                if (n2 > 127) {
                    n2 -= 256;
                }
                stringBuffer.append("#" + n2);
                break;
            }
            case 'I': {
                n2 = ByteArray.getShortAtOffset(this.d_code, n);
                if (n2 > Short.MAX_VALUE) {
                    n2 -= 65536;
                }
                stringBuffer.append("#" + n2);
                break;
            }
            case 'l': {
                n2 = ByteArray.getIntAtOffset(this.d_code, n);
                stringBuffer.append("#" + n2);
                break;
            }
            case 'a': {
                n2 = ByteArray.getSignedShortAtOffset(this.d_code, n);
                stringBuffer.append(this.d_fac.getTag(n2));
                break;
            }
            case 'A': {
                n2 = ByteArray.getIntAtOffset(this.d_code, n);
                stringBuffer.append(this.d_fac.getTag(n2));
                break;
            }
            case 't': {
                n2 = ByteArray.getByteAtOffset(this.d_code, n);
                stringBuffer.append(JVMInstruction.arrayTypeCode2String(n2));
                break;
            }
            default: {
                stringBuffer.append("<unknown operand type: " + c + ">");
                break;
            }
        }
    }

    public String getTag() {
        return this.d_tag;
    }

    public void setTag(String string) {
        this.d_tag = string;
    }

    private BitSet setUses() {
        if (this.marked) {
            return this.d_uses;
        }
        this.marked = true;
        if (this.d_opCode != 170 && this.d_opCode != 171 && this.d_opCode != 196) {
            JVMInstruction jVMInstruction = JVMInstruction.d_instrTable[this.d_opCode];
            int n = jVMInstruction.d_operandTypes.length();
            int n2 = 0;
            while (n2 < n) {
                switch (jVMInstruction.d_operandTypes.charAt(n2)) {
                    case 'c': {
                        if (this.d_uses == null) {
                            this.d_uses = new BitSet(this.d_cp.length());
                        }
                        this.d_uses.set(ByteArray.getByteAtOffset(this.d_code, 1));
                        break;
                    }
                    case 'C': {
                        if (this.d_uses == null) {
                            this.d_uses = new BitSet(this.d_cp.length());
                        }
                        this.d_uses.set(ByteArray.getShortAtOffset(this.d_code, 1));
                        break;
                    }
                }
                ++n2;
            }
        }
        return this.d_uses;
    }

    BitSet uses() {
        return this.setUses();
    }

    public String toBytes() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.d_code.length) {
            int n2 = ByteArray.getByteAtOffset(this.d_code, n);
            if (n2 < 10) {
                stringBuffer.append("0x0" + Integer.toHexString(n2) + " ");
            } else {
                stringBuffer.append("0x" + Integer.toHexString(n2) + " ");
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public int getLength(int n) {
        if (this.d_opCode != 170 && this.d_opCode != 171) {
            return this.d_code.length;
        }
        int n2 = (4 - (n + 1) % 4) % 4;
        return this.d_code.length + n2;
    }

    public byte[] getCode(int[] nArray, int n) {
        byte[] byArray = null;
        JVMInstruction jVMInstruction = JVMInstruction.d_instrTable[this.d_opCode];
        if (jVMInstruction.d_operandTypes.equals("") || nArray == null) {
            return this.d_code;
        }
        block0 : switch (jVMInstruction.d_operandTypes.charAt(0)) {
            case 's': {
                switch (this.d_opCode) {
                    case 171: {
                        int n2 = (4 - (n + 1) % 4) % 4;
                        int n3 = 0;
                        int n4 = 0;
                        byArray = new byte[n2 + this.d_code.length];
                        byArray[n3++] = (byte)this.d_opCode;
                        n4 = 0;
                        while (n4 < n2) {
                            byArray[n3++] = 0;
                            ++n4;
                        }
                        int n5 = ByteArray.getIntAtOffset(this.d_code, 1);
                        int n6 = nArray[n5] - n;
                        byArray[n3++] = (byte)(n6 >>> 24 & 0xFF);
                        byArray[n3++] = (byte)(n6 >>> 16 & 0xFF);
                        byArray[n3++] = (byte)(n6 >>> 8 & 0xFF);
                        byArray[n3++] = (byte)(n6 & 0xFF);
                        n4 = 5;
                        do {
                            byArray[n3++] = this.d_code[n4];
                        } while (++n4 < 9);
                        int n7 = ByteArray.getIntAtOffset(this.d_code, 5);
                        int n8 = 9;
                        int n9 = 0;
                        while (n9 < n7) {
                            n4 = 0;
                            do {
                                byArray[n3++] = this.d_code[n8 + n4];
                            } while (++n4 < 4);
                            n5 = ByteArray.getIntAtOffset(this.d_code, n8 += 4);
                            n6 = nArray[n5] - n;
                            byArray[n3++] = (byte)(n6 >>> 24 & 0xFF);
                            byArray[n3++] = (byte)(n6 >>> 16 & 0xFF);
                            byArray[n3++] = (byte)(n6 >>> 8 & 0xFF);
                            byArray[n3++] = (byte)(n6 & 0xFF);
                            n8 += 4;
                            ++n9;
                        }
                        break block0;
                    }
                    case 170: {
                        int n10 = (4 - (n + 1) % 4) % 4;
                        int n11 = 0;
                        int n12 = 0;
                        byArray = new byte[n10 + this.d_code.length];
                        byArray[n11++] = (byte)this.d_opCode;
                        n12 = 0;
                        while (n12 < n10) {
                            byArray[n11++] = 0;
                            ++n12;
                        }
                        int n13 = ByteArray.getIntAtOffset(this.d_code, 1);
                        int n14 = nArray[n13] - n;
                        byArray[n11++] = (byte)(n14 >>> 24 & 0xFF);
                        byArray[n11++] = (byte)(n14 >>> 16 & 0xFF);
                        byArray[n11++] = (byte)(n14 >>> 8 & 0xFF);
                        byArray[n11++] = (byte)(n14 & 0xFF);
                        n12 = 5;
                        do {
                            byArray[n11++] = this.d_code[n12];
                        } while (++n12 < 13);
                        int n15 = ByteArray.getIntAtOffset(this.d_code, 5);
                        int n16 = ByteArray.getIntAtOffset(this.d_code, 9);
                        int n17 = 13;
                        int n18 = n15;
                        while (n18 <= n16) {
                            n13 = ByteArray.getIntAtOffset(this.d_code, n17);
                            n14 = nArray[n13] - n;
                            byArray[n11++] = (byte)(n14 >>> 24 & 0xFF);
                            byArray[n11++] = (byte)(n14 >>> 16 & 0xFF);
                            byArray[n11++] = (byte)(n14 >>> 8 & 0xFF);
                            byArray[n11++] = (byte)(n14 & 0xFF);
                            n17 += 4;
                            ++n18;
                        }
                        break block0;
                    }
                    case 196: {
                        byArray = this.d_code;
                        break;
                    }
                }
                break;
            }
            case 'a': {
                int n19 = ByteArray.getSignedShortAtOffset(this.d_code, 1);
                int n20 = nArray[n19] - n;
                byArray = new byte[this.d_code.length];
                byArray[0] = (byte)this.d_opCode;
                byArray[1] = (byte)(n20 >>> 8 & 0xFF);
                byArray[2] = (byte)(n20 & 0xFF);
                break;
            }
            case 'A': {
                int n21 = ByteArray.getIntAtOffset(this.d_code, 1);
                int n22 = nArray[n21] - n;
                byArray = new byte[this.d_code.length];
                byArray[0] = (byte)this.d_opCode;
                byArray[1] = (byte)(n22 >>> 24 & 0xFF);
                byArray[2] = (byte)(n22 >>> 16 & 0xFF);
                byArray[3] = (byte)(n22 >>> 8 & 0xFF);
                byArray[4] = (byte)(n22 & 0xFF);
                break;
            }
            default: {
                byArray = this.d_code;
                break;
            }
        }
        return byArray;
    }
}

