/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.toad.cfparse.instruction;

import com.ibm.toad.cfparse.attributes.CodeAttrInfo;
import com.ibm.toad.cfparse.instruction.BaseInstruction;
import com.ibm.toad.cfparse.instruction.ImmutableCodeSegment;
import com.ibm.toad.cfparse.instruction.InstructionEvent;
import com.ibm.toad.cfparse.instruction.InstructionEventListener;
import java.util.Enumeration;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Vector;

public class ImmutableCodeIterator
implements Enumeration,
ListIterator {
    private int d_curInst;
    private Vector d_listeners;
    private ImmutableCodeSegment d_mc;

    public void addInstructionListener(InstructionEventListener instructionEventListener) {
        this.d_listeners.add(instructionEventListener);
    }

    public void step(int n) {
        int n2 = this.d_curInst + n;
        if (n2 < 0 || n2 >= this.d_mc.getNumInstructions()) {
            throw new NoSuchElementException("No instruction number " + n2);
        }
        this.d_curInst = n2;
    }

    public Object nextElement() throws NoSuchElementException {
        return this.next();
    }

    public void set(Object object) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("");
    }

    private void fireInstructionEvent(String string, BaseInstruction baseInstruction) {
        InstructionEvent instructionEvent = new InstructionEvent(string, baseInstruction);
        int n = 0;
        while (n < this.d_listeners.size()) {
            ((InstructionEventListener)this.d_listeners.get(n)).handleInstruction(instructionEvent);
            ++n;
        }
    }

    public ImmutableCodeIterator(CodeAttrInfo codeAttrInfo) {
        this(codeAttrInfo.getCode());
        this.d_curInst = 0;
    }

    public void add(Object object) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("");
    }

    public ImmutableCodeIterator(byte[] byArray) {
        this(new ImmutableCodeSegment(byArray));
    }

    public ImmutableCodeIterator(ImmutableCodeSegment immutableCodeSegment) {
        this.d_mc = immutableCodeSegment;
        this.d_curInst = 0;
    }

    public void rewind() {
        this.d_curInst = 0;
    }

    public boolean hasMoreElements() {
        return this.hasNext();
    }

    public int nextIndex() {
        return this.d_curInst + 1;
    }

    public int previousIndex() {
        return this.d_curInst - 1;
    }

    public boolean hasNext() {
        return this.d_curInst != this.d_mc.getNumInstructions() - 1;
    }

    public Object next() throws NoSuchElementException {
        if (this.d_curInst == this.d_mc.getNumInstructions() - 1) {
            throw new NoSuchElementException("No instruction number " + (this.d_curInst + 1));
        }
        ++this.d_curInst;
        RawByteInstr rawByteInstr = new RawByteInstr(this.d_mc.getInstruction(this.d_curInst));
        this.fireInstructionEvent("next", rawByteInstr);
        return rawByteInstr;
    }

    public boolean hasPrevious() {
        return this.d_curInst != 0;
    }

    public Object previous() throws NoSuchElementException {
        if (this.d_curInst == 0) {
            throw new NoSuchElementException("No instruction number " + (this.d_curInst + 1));
        }
        this.d_curInst += -1;
        RawByteInstr rawByteInstr = new RawByteInstr(this.d_mc.getInstruction(this.d_curInst));
        this.fireInstructionEvent("previous", rawByteInstr);
        return rawByteInstr;
    }

    public int length() {
        return this.d_mc.getNumInstructions();
    }

    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("");
    }

    class RawByteInstr
    implements BaseInstruction {
        private byte[] d_code;

        RawByteInstr(byte[] byArray) {
            ImmutableCodeIterator.this.getClass();
            this.d_code = byArray;
        }

        public int getOpCode() {
            return this.d_code[0] & 0xFF;
        }

        public String getTag() {
            return null;
        }

        public void setTag(String string) {
        }

        public int getLength(int n) {
            return this.d_code.length;
        }

        public byte[] getCode(int[] nArray, int n) {
            return this.d_code;
        }
    }
}

