/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.toad.cfparse.instruction;

import com.ibm.toad.cfparse.ConstantPool;
import com.ibm.toad.cfparse.attributes.CodeAttrInfo;
import com.ibm.toad.cfparse.instruction.CodeViewer;
import com.ibm.toad.cfparse.instruction.InstructionFactory;
import com.ibm.toad.cfparse.instruction.JVMInstruction;
import com.ibm.toad.cfparse.utils.ByteArray;
import com.ibm.toad.utils.D;
import java.util.HashMap;

public class ImmutableCodeSegment {
    private int d_numInstructions;
    private int[] d_instructions;
    private HashMap d_offsets;
    private byte[] d_code;

    public int getNumInstructions() {
        return this.d_numInstructions;
    }

    private int specArgSkip(byte[] byArray, int n, int n2) {
        int n3 = n2;
        int n4 = (4 - n2 % 4) % 4;
        switch (n) {
            case 170: {
                int n5 = ByteArray.getIntAtOffset(byArray, n2 += n4 + 4);
                int n6 = ByteArray.getIntAtOffset(byArray, n2 += 4);
                n2 += 4;
                int n7 = n5;
                while (n7 <= n6) {
                    n2 += 4;
                    ++n7;
                }
                break;
            }
            case 171: {
                int n8 = ByteArray.getIntAtOffset(byArray, n2 += n4 + 4);
                n2 += 4;
                int n9 = 0;
                while (n9 < n8) {
                    n2 += 8;
                    ++n9;
                }
                break;
            }
            case 196: {
                int n10 = ByteArray.getByteAtOffset(byArray, n2);
                n2 += 3;
                if (n10 != 132) break;
                n2 += 2;
                break;
            }
        }
        return n2 - n3;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.d_numInstructions) {
            int n2 = this.d_instructions[n];
            int n3 = n == this.d_numInstructions - 1 ? this.d_code.length : this.d_instructions[n + 1];
            stringBuffer.append(n + "(" + this.getOffset(n) + ") " + this.toBytes(this.d_code, n2, n3) + "\t\t\t" + this.InstrPrint(this.d_code, n2, n3) + "\n");
            ++n;
        }
        return stringBuffer.toString();
    }

    public ImmutableCodeSegment(byte[] byArray) {
        this.d_code = byArray;
        D.assert(byArray != null, "Cannot create null ImmutableCodeSegment");
        this.readCode(this.d_code);
    }

    private void readCode(byte[] byArray) {
        this.d_offsets = new HashMap();
        int[] nArray = new int[byArray.length];
        int n = 0;
        int n2 = 0;
        while (n < byArray.length) {
            nArray[n2] = n;
            this.d_offsets.put(new Integer(n), new Integer(n2));
            int n3 = ByteArray.getByteAtOffset(byArray, n);
            ++n;
            JVMInstruction jVMInstruction = JVMInstruction.d_instrTable[n3];
            int n4 = jVMInstruction.len();
            if (n4 == 0) {
                switch (n3) {
                    case 170: 
                    case 171: {
                        n += this.specArgSkip(byArray, n3, n);
                        break;
                    }
                    case 196: {
                        n += this.specArgSkip(byArray, n3, n);
                        break;
                    }
                    default: {
                        throw new D.AssertionException("Unknown special op code");
                    }
                }
            } else {
                String string = jVMInstruction.operandTypes();
                int n5 = string.length();
                int n6 = 0;
                while (n6 < n5) {
                    n += JVMInstruction.argSkip(string.charAt(n6));
                    ++n6;
                }
            }
            ++n2;
        }
        this.d_numInstructions = n2;
        this.d_instructions = new int[this.d_numInstructions];
        System.arraycopy(nArray, 0, this.d_instructions, 0, this.d_numInstructions);
    }

    void sprintOperand(StringBuffer stringBuffer, int n, char c) {
        int n2 = 0;
        switch (c) {
            case 'c': {
                n2 = ByteArray.getByteAtOffset(this.d_code, n);
                stringBuffer.append(n2);
                break;
            }
            case 'C': {
                n2 = ByteArray.getShortAtOffset(this.d_code, n);
                stringBuffer.append(n2);
                break;
            }
            case 'v': {
                n2 = ByteArray.getByteAtOffset(this.d_code, n);
                stringBuffer.append("v" + n2);
                break;
            }
            case 'V': {
                n2 = ByteArray.getShortAtOffset(this.d_code, n);
                stringBuffer.append("v" + n2);
                break;
            }
            case '0': 
            case 'i': {
                n2 = ByteArray.getByteAtOffset(this.d_code, n);
                if (n2 > 127) {
                    n2 -= 256;
                }
                stringBuffer.append("#" + n2);
                break;
            }
            case 'I': {
                n2 = ByteArray.getShortAtOffset(this.d_code, n);
                if (n2 > Short.MAX_VALUE) {
                    n2 -= 65536;
                }
                stringBuffer.append("#" + n2);
                break;
            }
            case 'l': {
                n2 = ByteArray.getIntAtOffset(this.d_code, n);
                stringBuffer.append("#" + n2);
                break;
            }
            case 'a': {
                n2 = ByteArray.getSignedShortAtOffset(this.d_code, n);
                stringBuffer.append(n + n2 - 1);
                break;
            }
            case 'A': {
                n2 = ByteArray.getIntAtOffset(this.d_code, n);
                stringBuffer.append(n + n2 - 1);
                break;
            }
            case 't': {
                n2 = ByteArray.getByteAtOffset(this.d_code, n);
                stringBuffer.append(JVMInstruction.arrayTypeCode2String(n2));
                break;
            }
            default: {
                stringBuffer.append("<unknown operand type: " + c + ">");
                break;
            }
        }
    }

    public static CodeViewer getViewer() {
        return new CodeViewer(){
            InstructionFactory d_if;

            public void setInstructionType(InstructionFactory instructionFactory) {
                this.d_if = instructionFactory;
            }

            public String view(ConstantPool constantPool, byte[] byArray, CodeAttrInfo.ExceptionInfo[] exceptionInfoArray, int n, String string) {
                StringBuffer stringBuffer = new StringBuffer();
                ImmutableCodeSegment immutableCodeSegment = new ImmutableCodeSegment(byArray);
                int n2 = immutableCodeSegment.getNumInstructions();
                int n3 = 0;
                while (n3 < n2) {
                    int n4 = immutableCodeSegment.getOffset(n3);
                    int n5 = n3 == n2 - 1 ? byArray.length : immutableCodeSegment.getOffset(n3 + 1);
                    stringBuffer.append(n3 + "(" + immutableCodeSegment.getOffset(n3) + ")" + string + " " + immutableCodeSegment.toBytes(byArray, n4, n5) + "\t\t\t" + immutableCodeSegment.InstrPrint(byArray, n4, n5) + "\n");
                    ++n3;
                }
                stringBuffer.append(string + "Exception Table:\n");
                if (n == 0) {
                    stringBuffer.append(string + "  <none>\n");
                } else {
                    n3 = 0;
                    while (n3 < n) {
                        stringBuffer.append(string + exceptionInfoArray[n3] + "\n");
                        ++n3;
                    }
                }
                return stringBuffer.toString();
            }
        };
    }

    public byte[] getInstruction(int n) {
        if (n < 0 || n >= this.d_numInstructions) {
            return null;
        }
        int n2 = n == this.d_numInstructions - 1 ? this.d_code.length : this.d_instructions[n + 1];
        byte[] byArray = new byte[n2 - this.d_instructions[n]];
        System.arraycopy(this.d_code, this.d_instructions[n], byArray, 0, n2 - this.d_instructions[n]);
        return byArray;
    }

    String InstrPrint(byte[] byArray, int n, int n2) {
        StringBuffer stringBuffer;
        block10: {
            JVMInstruction jVMInstruction;
            int n3;
            block9: {
                n3 = n;
                int n4 = byArray[n] & 0xFF;
                jVMInstruction = JVMInstruction.d_instrTable[n4];
                stringBuffer = new StringBuffer(jVMInstruction.name() + " ");
                if (jVMInstruction.len() != 0) break block9;
                switch (n4) {
                    case 170: {
                        n3 += (4 - n3 % 4) % 4;
                        this.sprintOperand(stringBuffer, n3, 'A');
                        stringBuffer.append(" ");
                        int n5 = ByteArray.getIntAtOffset(byArray, n3 += 4);
                        this.sprintOperand(stringBuffer, n3, 'l');
                        stringBuffer.append("-");
                        int n6 = ByteArray.getIntAtOffset(byArray, n3 += 4);
                        this.sprintOperand(stringBuffer, n3, 'l');
                        n3 += 4;
                        stringBuffer.append(" ");
                        int n7 = n5;
                        while (n7 <= n6) {
                            this.sprintOperand(stringBuffer, n3, 'A');
                            n3 += 4;
                            stringBuffer.append(" ");
                            ++n7;
                        }
                        break block10;
                    }
                    case 171: {
                        n3 += (4 - n3 % 4) % 4;
                        this.sprintOperand(stringBuffer, n3, 'A');
                        stringBuffer.append(" ");
                        int n8 = ByteArray.getIntAtOffset(byArray, n3 += 4);
                        this.sprintOperand(stringBuffer, n3, 'l');
                        n3 += 4;
                        stringBuffer.append(" ");
                        int n9 = 0;
                        while (n9 < n8) {
                            stringBuffer.append("(");
                            this.sprintOperand(stringBuffer, n3, 'l');
                            stringBuffer.append(", ");
                            this.sprintOperand(stringBuffer, n3 += 4, 'A');
                            n3 += 4;
                            stringBuffer.append(") ");
                            ++n9;
                        }
                        break block10;
                    }
                    case 196: {
                        int n10 = ByteArray.getByteAtOffset(byArray, n3 + 1);
                        JVMInstruction jVMInstruction2 = JVMInstruction.d_instrTable[n10];
                        stringBuffer.append(jVMInstruction2.name() + " ");
                        this.sprintOperand(stringBuffer, n3 + 2, 'V');
                        stringBuffer.append(" ");
                        if (n10 == 132) {
                            this.sprintOperand(stringBuffer, n3 + 4, 'I');
                            break;
                        }
                        break block10;
                    }
                    default: {
                        throw new D.AssertionException("unknown special op code");
                    }
                }
                break block10;
            }
            ++n3;
            int n11 = jVMInstruction.d_operandTypes.length();
            int n12 = 0;
            while (n12 < n11) {
                this.sprintOperand(stringBuffer, n3, jVMInstruction.d_operandTypes.charAt(n12));
                n3 += JVMInstruction.argSkip(jVMInstruction.d_operandTypes.charAt(n12));
                stringBuffer.append(" ");
                ++n12;
            }
        }
        return stringBuffer.toString();
    }

    public int getInum(int n) {
        Integer n2 = (Integer)this.d_offsets.get(new Integer(n));
        D.assert(n2 != null, "Illegal offset");
        return n2;
    }

    String toBytes(byte[] byArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = n;
        while (n3 < n2) {
            String string = Integer.toHexString(byArray[n3] & 0xFF) + " ";
            if ((byArray[n3] & 0xFF) < 16) {
                stringBuffer.append("0");
            }
            stringBuffer.append(string);
            ++n3;
        }
        return stringBuffer.toString();
    }

    public int getOffset(int n) {
        D.assert(n >= 0 && n < this.d_numInstructions, "Illegal instruction number");
        return this.d_instructions[n];
    }
}

