/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.toad.cfparse.instruction;

import com.ibm.toad.cfparse.ConstantPool;
import com.ibm.toad.cfparse.attributes.AttrInfoList;
import com.ibm.toad.cfparse.attributes.CodeAttrInfo;
import com.ibm.toad.cfparse.attributes.LineNumberAttrInfo;
import com.ibm.toad.cfparse.instruction.BaseInstruction;
import com.ibm.toad.cfparse.instruction.ByteInstruction;
import com.ibm.toad.cfparse.instruction.ByteInstructionFactory;
import com.ibm.toad.cfparse.instruction.CodeViewer;
import com.ibm.toad.cfparse.instruction.InstructionFactory;
import com.ibm.toad.cfparse.instruction.InstructionFormatException;
import com.ibm.toad.cfparse.instruction.JVMInstruction;
import com.ibm.toad.cfparse.instruction.TagFactory;
import com.ibm.toad.cfparse.utils.ByteArray;
import com.ibm.toad.utils.D;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public class MutableCodeSegment
implements TagFactory {
    private static final String baseTag = "TAG_";
    private int d_curTagNum;
    private HashMap d_off2tagNum;
    private HashMap d_off2iNum;
    private HashMap d_tagNum2tagStr;
    private HashMap d_tagStr2tagNum;
    private HashMap d_tagStr2iNum;
    private Vector d_instructions;
    int d_numExceptions;
    CodeAttrInfo.ExceptionInfo[] d_exceptions;
    ConstantPool d_cp;
    private InstructionFactory d_if;

    public CodeAttrInfo.ExceptionInfo getException(int n) {
        if (n < 0 || n > this.d_numExceptions) {
            return null;
        }
        return this.d_exceptions[n];
    }

    private void fixTags() {
        Iterator iterator = this.d_off2tagNum.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Integer n = (Integer)this.d_off2iNum.get((Integer)entry.getKey());
            String string = (String)this.d_tagNum2tagStr.get((Integer)entry.getValue());
            ((BaseInstruction)this.d_instructions.elementAt(n)).setTag(string);
            this.d_tagStr2iNum.put(string, n);
        }
    }

    public int getNumInstructions() {
        return this.d_instructions.size();
    }

    public int tag2Inum(String string) {
        Integer n = (Integer)this.d_tagStr2iNum.get(string);
        if (n == null) {
            return -1;
        }
        return n;
    }

    public String toString() {
        return this.toString(0);
    }

    private MutableCodeSegment(ConstantPool constantPool) {
        this.d_cp = constantPool;
        this.d_curTagNum = 0;
        this.d_off2tagNum = new HashMap();
        this.d_off2iNum = new HashMap();
        this.d_tagNum2tagStr = new HashMap();
        this.d_tagStr2tagNum = new HashMap();
        this.d_tagStr2iNum = new HashMap();
        this.d_instructions = new Vector();
    }

    public MutableCodeSegment(ConstantPool constantPool, byte[] byArray, CodeAttrInfo.ExceptionInfo[] exceptionInfoArray, int n) {
        this(constantPool);
        this.d_if = new ByteInstructionFactory();
        this.init(byArray, exceptionInfoArray, n);
    }

    public MutableCodeSegment(ConstantPool constantPool, CodeAttrInfo codeAttrInfo, boolean bl) {
        this(constantPool);
        this.d_if = new ByteInstructionFactory();
        this.init(codeAttrInfo.getCode(), codeAttrInfo.getExceptions(), codeAttrInfo.getNumExceptions());
        if (bl) {
            this.addLines(codeAttrInfo);
        }
    }

    public MutableCodeSegment(ConstantPool constantPool, byte[] byArray, CodeAttrInfo.ExceptionInfo[] exceptionInfoArray, int n, InstructionFactory instructionFactory) {
        this(constantPool);
        this.d_if = instructionFactory;
        this.init(byArray, exceptionInfoArray, n);
    }

    public String getTag(int n) {
        return (String)this.d_tagNum2tagStr.get(new Integer(n));
    }

    public MutableCodeSegment(ConstantPool constantPool, CodeAttrInfo codeAttrInfo, boolean bl, InstructionFactory instructionFactory) {
        this(constantPool);
        this.d_if = instructionFactory;
        this.init(codeAttrInfo.getCode(), codeAttrInfo.getExceptions(), codeAttrInfo.getNumExceptions());
        if (bl) {
            this.addLines(codeAttrInfo);
        }
    }

    private void readCode(byte[] byArray) {
        int n = 0;
        while (n < byArray.length) {
            int n2 = n;
            int n3 = ByteArray.getByteAtOffset(byArray, n);
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            BaseInstruction baseInstruction = null;
            int n7 = 0;
            int n8 = 0;
            ++n;
            JVMInstruction jVMInstruction = JVMInstruction.d_instrTable[n3];
            switch (n3) {
                case 170: {
                    n4 = (4 - n % 4) % 4;
                    n5 = ByteArray.getIntAtOffset(byArray, n += n4);
                    n7 = this.addTag(n2 + n5);
                    int n9 = ByteArray.getIntAtOffset(byArray, n += 4);
                    int n10 = ByteArray.getIntAtOffset(byArray, n += 4);
                    n += 4;
                    byte[] byArray2 = new byte[13 + (n10 - n9 + 1) * 4];
                    byArray2[0] = (byte)n3;
                    ByteArray.writeInt(byArray2, 1, n7);
                    ByteArray.writeInt(byArray2, 5, n9);
                    ByteArray.writeInt(byArray2, 9, n10);
                    n6 = 13;
                    int n11 = n9;
                    while (n11 <= n10) {
                        n5 = ByteArray.getIntAtOffset(byArray, n);
                        n8 = this.addTag(n2 + n5);
                        ByteArray.writeInt(byArray2, n6, n8);
                        n6 += 4;
                        n += 4;
                        ++n11;
                    }
                    baseInstruction = this.d_if.create(this, this.d_cp, byArray2, 0, byArray2.length);
                    break;
                }
                case 171: {
                    n4 = (4 - n % 4) % 4;
                    n5 = ByteArray.getIntAtOffset(byArray, n += n4);
                    n7 = this.addTag(n2 + n5);
                    int n11 = ByteArray.getIntAtOffset(byArray, n += 4);
                    n += 4;
                    byte[] byArray2 = new byte[9 + n11 * 8];
                    byArray2[0] = (byte)n3;
                    ByteArray.writeInt(byArray2, 1, n7);
                    ByteArray.writeInt(byArray2, 5, n11);
                    n6 = 9;
                    int n12 = 0;
                    while (n12 < n11) {
                        int n13 = ByteArray.getIntAtOffset(byArray, n);
                        ByteArray.writeInt(byArray2, n6, n13);
                        n5 = ByteArray.getIntAtOffset(byArray, n += 4);
                        n8 = this.addTag(n2 + n5);
                        ByteArray.writeInt(byArray2, n6 += 4, n8);
                        n6 += 4;
                        n += 4;
                        ++n12;
                    }
                    baseInstruction = this.d_if.create(this, this.d_cp, byArray2, 0, byArray2.length);
                    break;
                }
                case 196: {
                    int n12 = ByteArray.getByteAtOffset(byArray, n);
                    n += 3;
                    if (n12 == 132) {
                        n += 2;
                    }
                    baseInstruction = this.d_if.create(this, this.d_cp, byArray, n2, n - n2);
                    break;
                }
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: 
                case 167: 
                case 168: 
                case 198: 
                case 199: {
                    n5 = ByteArray.getSignedShortAtOffset(byArray, n);
                    n8 = this.addTag(n2 + n5);
                    byte[] byArray2 = new byte[]{(byte)n3, (byte)(n8 >>> 8 & 0xFF), (byte)(n8 & 0xFF)};
                    n += JVMInstruction.argSkip('a');
                    baseInstruction = this.d_if.create(this, this.d_cp, byArray2, 0, 3);
                    break;
                }
                case 200: 
                case 201: {
                    n5 = ByteArray.getIntAtOffset(byArray, n);
                    n8 = this.addTag(n2 + n5);
                    byte[] byArray2 = new byte[]{(byte)n3, (byte)(n8 >>> 24 & 0xFF), (byte)(n8 >>> 16 & 0xFF), (byte)(n8 >>> 8 & 0xFF), (byte)(n8 & 0xFF)};
                    n += JVMInstruction.argSkip('A');
                    baseInstruction = this.d_if.create(this, this.d_cp, byArray2, 0, 5);
                    break;
                }
                default: {
                    String string = jVMInstruction.operandTypes();
                    int n14 = string.length();
                    int n15 = 0;
                    while (n15 < n14) {
                        n += JVMInstruction.argSkip(string.charAt(n15));
                        ++n15;
                    }
                    baseInstruction = this.d_if.create(this, this.d_cp, byArray, n2, n - n2);
                    break;
                }
            }
            this.d_off2iNum.put(new Integer(n2), new Integer(this.d_instructions.size()));
            if (baseInstruction == null) continue;
            this.d_instructions.addElement(baseInstruction);
        }
    }

    public void fixLineNumberTable(LineNumberAttrInfo lineNumberAttrInfo) {
        int n = 0;
        boolean bl = true;
        lineNumberAttrInfo.clear();
        int n2 = 0;
        while (n2 < this.d_instructions.size()) {
            BaseInstruction baseInstruction = (BaseInstruction)this.d_instructions.elementAt(n2);
            if (baseInstruction.getOpCode() == 254) {
                if (bl) {
                    lineNumberAttrInfo.clear();
                    bl = false;
                }
                int n3 = ByteArray.getShortAtOffset(baseInstruction.getCode(null, 0), 1);
                lineNumberAttrInfo.add(n3, n);
            } else {
                n += baseInstruction.getLength(n);
            }
            ++n2;
        }
    }

    public BaseInstruction create(String string) throws InstructionFormatException {
        BaseInstruction baseInstruction = this.d_if.create(this, this.d_cp, string);
        String string2 = baseInstruction.getTag();
        if (string2 != null) {
            this.tagFor(string2, true);
        }
        return baseInstruction;
    }

    public String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < this.d_instructions.size()) {
            BaseInstruction baseInstruction = (BaseInstruction)this.d_instructions.elementAt(n2);
            String string = baseInstruction.getTag() != null ? baseInstruction.getTag() + ":" : "\t";
            stringBuffer.append(n2 + ":" + string + this.sindent(n) + " " + baseInstruction + "\n");
            ++n2;
        }
        stringBuffer.append(this.sindent(n) + "Exception Table:\n");
        if (this.d_numExceptions == 0) {
            stringBuffer.append(this.sindent(n) + "  <none>\n");
        } else {
            n2 = 0;
            while (n2 < this.d_numExceptions) {
                stringBuffer.append(this.sindent(n) + this.d_exceptions[n2] + "\n");
                ++n2;
            }
        }
        return stringBuffer.toString();
    }

    public Vector getInstructions() {
        return this.d_instructions;
    }

    public void setInstructions(Vector vector) {
        this.d_instructions = vector;
    }

    private String sindent(int n) {
        String string = "";
        int n2 = 0;
        while (n2 < n) {
            string = string + "  ";
            ++n2;
        }
        return string;
    }

    public static CodeViewer getViewer() {
        return new CodeViewer(){
            InstructionFactory d_if;

            public void setInstructionType(InstructionFactory instructionFactory) {
                this.d_if = instructionFactory;
            }

            public String view(ConstantPool constantPool, byte[] byArray, CodeAttrInfo.ExceptionInfo[] exceptionInfoArray, int n, String string) {
                Object object;
                MutableCodeSegment mutableCodeSegment = this.d_if == null ? new MutableCodeSegment(constantPool, byArray, exceptionInfoArray, n) : new MutableCodeSegment(constantPool, byArray, exceptionInfoArray, n, this.d_if);
                StringBuffer stringBuffer = new StringBuffer();
                Vector vector = mutableCodeSegment.getInstructions();
                int n2 = 0;
                while (n2 < vector.size()) {
                    BaseInstruction baseInstruction = (BaseInstruction)vector.elementAt(n2);
                    object = baseInstruction.getTag() != null ? baseInstruction.getTag() + ":" : "\t";
                    stringBuffer.append(n2 + ":" + (String)object + string + " " + baseInstruction + "\n");
                    ++n2;
                }
                n2 = mutableCodeSegment.getNumExceptions();
                stringBuffer.append(string + "Exception Table:\n");
                if (n2 == 0) {
                    stringBuffer.append(string + "  <none>\n");
                } else {
                    int n3 = 0;
                    while (n3 < n2) {
                        object = mutableCodeSegment.getException(n3);
                        stringBuffer.append(string + "start_tag = " + mutableCodeSegment.getTag(((CodeAttrInfo.ExceptionInfo)object).getStart()));
                        stringBuffer.append(", end_tag = " + mutableCodeSegment.getTag(((CodeAttrInfo.ExceptionInfo)object).getEnd()));
                        stringBuffer.append(", handler_tag = " + mutableCodeSegment.getTag(((CodeAttrInfo.ExceptionInfo)object).getHandler()));
                        stringBuffer.append(", catch_type = " + ((CodeAttrInfo.ExceptionInfo)object).getCatchType() + "\n");
                        ++n3;
                    }
                }
                return stringBuffer.toString();
            }
        };
    }

    private void resize() {
        CodeAttrInfo.ExceptionInfo[] exceptionInfoArray = new CodeAttrInfo.ExceptionInfo[this.d_numExceptions + 10];
        if (this.d_exceptions != null) {
            System.arraycopy(this.d_exceptions, 0, exceptionInfoArray, 0, this.d_numExceptions);
        }
        this.d_exceptions = exceptionInfoArray;
    }

    public int tagFor(String string, boolean bl) {
        Integer n = (Integer)this.d_tagStr2tagNum.get(string);
        if (n != null) {
            return n;
        }
        if (!bl) {
            return -1;
        }
        int n2 = this.d_curTagNum++;
        Integer n3 = new Integer(n2);
        this.d_tagNum2tagStr.put(n3, string);
        this.d_tagStr2tagNum.put(string, n3);
        return n2;
    }

    public void updateCodeAttrInfo(CodeAttrInfo codeAttrInfo) {
        codeAttrInfo.setCode(this.getCode());
        codeAttrInfo.setExceptions(this.getExcTable());
        AttrInfoList attrInfoList = codeAttrInfo.getAttrs();
        if (attrInfoList == null) {
            return;
        }
        LineNumberAttrInfo lineNumberAttrInfo = (LineNumberAttrInfo)attrInfoList.get("LineNumberTable");
        if (lineNumberAttrInfo == null) {
            return;
        }
        this.fixLineNumberTable(lineNumberAttrInfo);
    }

    public int getNumExceptions() {
        return this.d_numExceptions;
    }

    private void addLines(CodeAttrInfo codeAttrInfo) {
        AttrInfoList attrInfoList = codeAttrInfo.getAttrs();
        if (attrInfoList == null) {
            return;
        }
        LineNumberAttrInfo lineNumberAttrInfo = (LineNumberAttrInfo)attrInfoList.get("LineNumberTable");
        if (lineNumberAttrInfo == null) {
            return;
        }
        byte[] byArray = new byte[3];
        byArray[0] = -2;
        byte[] byArray2 = byArray;
        int n = 0;
        while (n < lineNumberAttrInfo.length()) {
            ByteArray.writeShort(byArray2, 1, lineNumberAttrInfo.getLineNumber(n));
            ByteInstruction byteInstruction = new ByteInstruction(this, this.d_cp, byArray2, 0, 3);
            Integer n2 = (Integer)this.d_off2iNum.get(new Integer(lineNumberAttrInfo.getStartPC(n)));
            if (n2 == null) {
                System.out.println("Panic, no iNum found for index " + n + " {" + lineNumberAttrInfo.getLineNumber(n) + ", " + lineNumberAttrInfo.getStartPC(n) + "}");
            } else {
                this.d_instructions.insertElementAt(byteInstruction, n2 + n);
            }
            ++n;
        }
    }

    public void createExceptionBlock(String string, String string2, String string3, String string4) {
        if (this.d_exceptions == null || this.d_numExceptions == this.d_exceptions.length) {
            this.resize();
        }
        int n = this.tagFor(string, true);
        int n2 = this.tagFor(string2, true);
        int n3 = this.tagFor(string3, true);
        this.d_exceptions[this.d_numExceptions] = new CodeAttrInfo.ExceptionInfo(this.d_cp, n, n2, n3, string4);
        ++this.d_numExceptions;
    }

    private void init(byte[] byArray, CodeAttrInfo.ExceptionInfo[] exceptionInfoArray, int n) {
        if (byArray != null) {
            this.readCode(byArray);
        }
        this.makeExcTable(exceptionInfoArray, n);
        this.fixTags();
    }

    private int addTag(int n) {
        Integer n2 = (Integer)this.d_off2tagNum.get(new Integer(n));
        if (n2 != null) {
            return n2;
        }
        int n3 = this.d_curTagNum++;
        Integer n4 = new Integer(n3);
        Integer n5 = new Integer(n);
        this.d_off2tagNum.put(n5, n4);
        this.d_tagNum2tagStr.put(n4, baseTag + n3);
        this.d_tagStr2tagNum.put(baseTag + n3, n4);
        return n3;
    }

    public byte[] getCode() {
        int[] nArray = new int[this.d_curTagNum];
        int n = 0;
        int n2 = 0;
        while (n2 < this.d_instructions.size()) {
            BaseInstruction baseInstruction = (BaseInstruction)this.d_instructions.elementAt(n2);
            if (baseInstruction.getOpCode() != 254) {
                if (baseInstruction.getTag() != null) {
                    nArray[this.tagFor((String)baseInstruction.getTag(), (boolean)false)] = n;
                }
                n += baseInstruction.getLength(n);
            }
            ++n2;
        }
        byte[] byArray = new byte[n];
        n = 0;
        int n3 = 0;
        while (n3 < this.d_instructions.size()) {
            BaseInstruction baseInstruction = (BaseInstruction)this.d_instructions.elementAt(n3);
            if (baseInstruction.getOpCode() != 254) {
                byte[] byArray2 = baseInstruction.getCode(nArray, n);
                System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
                D.assert(byArray2.length == baseInstruction.getLength(n), "Bad lengths in getCode");
                n += baseInstruction.getLength(n);
            }
            ++n3;
        }
        return byArray;
    }

    public void setInstructionFactory(InstructionFactory instructionFactory) {
        this.d_if = instructionFactory;
    }

    public int numTags() {
        return this.d_curTagNum;
    }

    public CodeAttrInfo.ExceptionInfo[] getExcTable() {
        int[] nArray = new int[this.d_curTagNum];
        int n = 0;
        int n2 = 0;
        while (n2 < this.d_instructions.size()) {
            BaseInstruction baseInstruction = (BaseInstruction)this.d_instructions.elementAt(n2);
            if (baseInstruction.getOpCode() != 254) {
                if (baseInstruction.getTag() != null) {
                    nArray[this.tagFor((String)baseInstruction.getTag(), (boolean)false)] = n;
                }
                n += baseInstruction.getLength(n);
            }
            ++n2;
        }
        CodeAttrInfo.ExceptionInfo[] exceptionInfoArray = new CodeAttrInfo.ExceptionInfo[this.d_numExceptions];
        int n3 = 0;
        while (n3 < this.d_numExceptions) {
            int n4 = this.d_exceptions[n3].getStart();
            int n5 = this.d_exceptions[n3].getEnd();
            int n6 = this.d_exceptions[n3].getHandler();
            exceptionInfoArray[n3] = new CodeAttrInfo.ExceptionInfo(this.d_cp, nArray[n4], nArray[n5], nArray[n6], this.d_exceptions[n3].getCatch());
            ++n3;
        }
        return exceptionInfoArray;
    }

    private void makeExcTable(CodeAttrInfo.ExceptionInfo[] exceptionInfoArray, int n) {
        this.d_numExceptions = n;
        this.d_exceptions = new CodeAttrInfo.ExceptionInfo[this.d_numExceptions];
        int n2 = 0;
        while (n2 < this.d_numExceptions) {
            int n3 = exceptionInfoArray[n2].getStart();
            int n4 = exceptionInfoArray[n2].getEnd();
            int n5 = exceptionInfoArray[n2].getHandler();
            this.d_exceptions[n2] = new CodeAttrInfo.ExceptionInfo(this.d_cp, this.addTag(n3), this.addTag(n4), this.addTag(n5), exceptionInfoArray[n2].getCatch());
            ++n2;
        }
    }
}

