/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.toad.cfparse.utils;

import com.ibm.toad.cfparse.ClassFile;
import com.ibm.toad.cfparse.ConstantPool;
import com.ibm.toad.cfparse.MethodInfoList;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public final class CFUtils {
    public static final int BYTES = 1;
    public static final int FILE = 2;
    public static final int CLASSFILE = 3;
    public static final int STRING = 4;

    public static String canonicalize(String string) {
        String string2 = string.replace('\\', '/').replace('.', '/');
        string2 = string2.endsWith("/class") ? string2.substring(0, string2.length() - 6) + ".class" : string2 + ".class";
        return string2;
    }

    public static String[] getClassNamesFromZip(String string, String string2) {
        Object[] objectArray;
        String string3 = string2.replace('\\', '/').replace('.', '/');
        if (string3.endsWith("*")) {
            string3 = string3.substring(0, string3.length() - 1);
        }
        if (!string3.endsWith("/")) {
            string3 = string3 + "/";
        }
        Vector<String> vector = new Vector<String>();
        try {
            objectArray = new ZipFile(string);
            Enumeration<? extends ZipEntry> enumeration = objectArray.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                if (!zipEntry.getName().startsWith(string3) || !zipEntry.getName().endsWith(".class") || zipEntry.isDirectory()) continue;
                String string4 = zipEntry.getName().replace('/', '.').substring(0, zipEntry.getName().length() - 6);
                vector.addElement(string4);
            }
        }
        catch (Exception exception) {
            return null;
        }
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static Vector getFileDeps(String string, String string2, boolean bl) {
        ClassFile classFile;
        Hashtable<String, ClassFile> hashtable = new Hashtable<String, ClassFile>();
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        if (hashtable.contains(string2 = CFUtils.canonicalize(string2))) {
            classFile = (ClassFile)hashtable.get(string2);
        } else {
            try {
                classFile = new ClassFile(string + string2);
            }
            catch (Exception exception) {
                System.out.println("oops ");
                exception.printStackTrace();
                return null;
            }
            hashtable.put(string2, classFile);
            hashtable2.put(string2, classFile.getSourceFilename());
        }
        ConstantPool constantPool = classFile.getCP();
        int n = 0;
        while (n < constantPool.length()) {
            String string3;
            if (!(constantPool.getType(n) != 7 || (string3 = CFUtils.canonicalize(constantPool.getAsString(n))).equals(string2) || string3.startsWith("java/") || string3.startsWith("com/sun/"))) {
                if (bl) {
                    if (!vector.contains(string3)) {
                        vector.addElement(string3);
                        vector2.addElement(string3);
                    }
                } else if (hashtable2.contains(string3)) {
                    vector2.addElement((String)hashtable2.get(string3));
                } else {
                    try {
                        classFile = new ClassFile(string + string3);
                        hashtable.put(string3, classFile);
                        hashtable2.put(string3, classFile.getSourceFilename());
                        if (!vector2.contains(classFile.getSourceFilename())) {
                            vector2.addElement(classFile.getSourceFilename());
                        }
                    }
                    catch (Exception exception) {
                        System.out.println("Failed to read " + string3);
                    }
                }
            }
            ++n;
        }
        return vector2;
    }

    public static int compress(ClassFile classFile, String string) {
        BitSet bitSet = classFile.uses();
        int[] nArray = new int[classFile.getCP().length()];
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < nArray.length) {
            if (bitSet.get(n3)) {
                nArray[n3] = n++;
            } else {
                ++n2;
                nArray[n3] = -1;
            }
            ++n3;
        }
        classFile.sort(nArray);
        if (string != null) {
            try {
                classFile.write(string);
            }
            catch (Exception exception) {
                return -1;
            }
        }
        return n2;
    }

    public static Object forName(String string, int n, boolean bl) {
        return CFUtils.forName(null, string, n, bl);
    }

    /*
     * Unable to fully structure code
     */
    public static Object forName(String[] var0, String var1_1, int var2_2, boolean var3_3) {
        var4_4 = CFUtils.canonicalize(var1_1);
        if (var0 == null) {
            var0 = CFUtils.getClassPath(var3_3);
        }
        var5_5 = 0;
        while (var5_5 < var0.length) {
            block17: {
                var6_6 = "";
                if (!var0[var5_5].endsWith("/")) break block17;
                var6_6 = var0[var5_5] + var4_4;
                ** GOTO lbl17
            }
            if (var0[var5_5].endsWith(".jar") || var0[var5_5].endsWith(".zip")) {
                var7_7 = CFUtils.forName(var0[var5_5], var1_1, var2_2);
                if (var7_7 != null) {
                    return var7_7;
                }
            } else {
                var6_6 = var0[var5_5] + "/" + var4_4;
lbl17:
                // 2 sources

                var7_7 = new File(var6_6);
                if (var7_7.isFile()) {
                    switch (var2_2) {
                        case 1: {
                            try {
                                var8_9 = new FileInputStream((File)var7_7);
                                var9_11 = new byte[var8_9.available()];
                                var10_12 = 0;
                                var11_13 = 0;
                                while (var11_13 < var9_11.length) {
                                    var10_12 = var8_9.read(var9_11, var11_13, var9_11.length - var11_13);
                                    if (var10_12 == -1) break;
                                    var11_13 += var10_12;
                                }
                                return var9_11;
                            }
                            catch (Exception v0) {
                                return null;
                            }
                        }
                        case 2: {
                            return var7_7;
                        }
                        case 4: {
                            return var6_6;
                        }
                        case 3: {
                            try {
                                var8_10 = new ClassFile(var6_6);
                                return var8_10;
                            }
                            catch (Exception var8_8) {
                                var8_8.printStackTrace();
                            }
                        }
                    }
                }
            }
            ++var5_5;
        }
        return null;
    }

    public static Object forName(String string, String string2, int n) {
        String string3 = CFUtils.canonicalize(string2);
        try {
            ZipFile zipFile = new ZipFile(string);
            ZipEntry zipEntry = zipFile.getEntry(string3);
            if (zipEntry != null) {
                InputStream inputStream = zipFile.getInputStream(zipEntry);
                if (n == 3) {
                    ClassFile classFile = new ClassFile(inputStream);
                    return classFile;
                }
                if (n == 1) {
                    byte[] byArray = new byte[(int)zipEntry.getSize()];
                    int n2 = 0;
                    int n3 = 0;
                    while (n3 < byArray.length) {
                        n2 = inputStream.read(byArray, n3, byArray.length - n3);
                        if (n2 == -1) break;
                        n3 += n2;
                    }
                    return byArray;
                }
                if (n == 4) {
                    return string;
                }
                return null;
            }
        }
        catch (Exception exception) {}
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public static String[] getClassNames(String var0, boolean var1_1) {
        var2_2 = var0.replace('\\', '/').replace('.', '/');
        if (var2_2.endsWith("*")) {
            var2_2 = var2_2.substring(0, var2_2.length() - 1);
        }
        if (!var2_2.endsWith("/")) {
            var2_2 = var2_2 + "/";
        }
        var3_3 = CFUtils.getClassPath(var1_1);
        var4_4 = new Vector<Object>();
        var5_5 = 0;
        while (var5_5 < var3_3.length) {
            block9: {
                var6_7 = "";
                if (!var3_3[var5_5].endsWith("/")) break block9;
                var6_7 = var3_3[var5_5] + var2_2;
                ** GOTO lbl26
            }
            if (var3_3[var5_5].endsWith(".jar") || var3_3[var5_5].endsWith(".zip")) {
                var7_8 = CFUtils.getClassNamesFromZip(var3_3[var5_5], var2_2);
                if (var7_8 != null) {
                    var8_9 = 0;
                    while (var8_9 < ((Object)var7_8).length) {
                        var4_4.addElement(var7_8[var8_9]);
                        ++var8_9;
                    }
                }
            } else {
                var6_7 = var3_3[var5_5] + "/" + var2_2;
lbl26:
                // 2 sources

                var7_8 = new File(var6_7);
                if (var7_8.isDirectory() && (var8_10 = var7_8.list(new FilenameFilter(){

                    public boolean accept(File file, String string) {
                        return string.endsWith(".class");
                    }
                })) != null) {
                    var9_11 = 0;
                    while (var9_11 < var8_10.length) {
                        var10_12 = (var2_2 + var8_10[var9_11].substring(0, var8_10[var9_11].length() - 6)).replace('/', '.');
                        var4_4.addElement(var10_12);
                        ++var9_11;
                    }
                }
            }
            ++var5_5;
        }
        var5_6 = new String[var4_4.size()];
        var4_4.copyInto(var5_6);
        return var5_6;
    }

    public static String[] getLocalMethodNames(ClassFile classFile) {
        MethodInfoList methodInfoList = classFile.getMethods();
        String[] stringArray = new String[methodInfoList.length()];
        int n = 0;
        while (n < methodInfoList.length()) {
            stringArray[n] = methodInfoList.getMethodName(n);
            ++n;
        }
        return stringArray;
    }

    public static String[] getUsedFieldNames(ClassFile classFile, String[] stringArray) {
        int n;
        ConstantPool constantPool = classFile.getCP();
        Vector<String> vector = new Vector<String>();
        int n2 = 0;
        while (n2 < constantPool.length()) {
            if (constantPool.getType(n2) == 9) {
                vector.addElement(constantPool.getAsJava(n2));
            }
            ++n2;
        }
        if (stringArray != null) {
            n2 = 0;
            while (n2 < stringArray.length) {
                n = stringArray[n2].indexOf("*");
                String string = n == -1 ? stringArray[n2] : stringArray[n2].substring(0, n);
                Vector vector2 = (Vector)vector.clone();
                vector.setSize(0);
                int n3 = 0;
                while (n3 < vector2.size()) {
                    String string2 = (String)vector2.elementAt(n3);
                    String string3 = string2.substring(string2.lastIndexOf(" ") + 1, string2.length());
                    if (!string3.startsWith(string)) {
                        vector.addElement(string2);
                    }
                    ++n3;
                }
                ++n2;
            }
        }
        String[] stringArray2 = new String[vector.size()];
        n = 0;
        while (n < vector.size()) {
            stringArray2[n] = (String)vector.elementAt(n);
            ++n;
        }
        return stringArray2;
    }

    public static String[] getUsedMethodNames(ClassFile classFile, String[] stringArray) {
        int n;
        ConstantPool constantPool = classFile.getCP();
        Vector<String> vector = new Vector<String>();
        int n2 = 0;
        while (n2 < constantPool.length()) {
            if (constantPool.getType(n2) == 10) {
                vector.addElement(constantPool.getAsJava(n2));
            }
            ++n2;
        }
        if (stringArray != null) {
            n2 = 0;
            while (n2 < stringArray.length) {
                n = stringArray[n2].indexOf("*");
                String string = n == -1 ? stringArray[n2] : stringArray[n2].substring(0, n);
                Vector vector2 = (Vector)vector.clone();
                vector.setSize(0);
                int n3 = 0;
                while (n3 < vector2.size()) {
                    String string2 = (String)vector2.elementAt(n3);
                    String string3 = string2.substring(string2.lastIndexOf(" ") + 1, string2.length());
                    if (!string3.startsWith(string)) {
                        vector.addElement(string2);
                    }
                    ++n3;
                }
                ++n2;
            }
        }
        String[] stringArray2 = new String[vector.size()];
        n = 0;
        while (n < vector.size()) {
            stringArray2[n] = (String)vector.elementAt(n);
            ++n;
        }
        return stringArray2;
    }

    public static String[] getClassPath(boolean bl) {
        Object object;
        StringTokenizer stringTokenizer = new StringTokenizer(System.getProperty("java.class.path"), File.pathSeparator);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken();
            if (!bl && (((String)object).endsWith(".jar") || ((String)object).endsWith(".zip"))) continue;
            stringArray[n++] = object;
        }
        object = new String[n];
        System.arraycopy(stringArray, 0, object, 0, n);
        return object;
    }
}

