/*
 * Decompiled with CFR 0.152.
 */
package padl.analysis;

import com.ibm.toad.cfparse.ClassFile;
import java.security.AccessControlException;
import java.util.ArrayList;
import padl.IFileRepository;
import padl.analysis.Analysis;
import util.PropertyManager;
import util.io.SubtypeLoader;

public class Repository {
    private static Repository UniqueInstance;
    private Analysis[] analyses;

    public static Repository getCurrentAnalysisManager(IFileRepository fileRepository) {
        if (UniqueInstance == null) {
            UniqueInstance = new Repository(fileRepository);
        }
        return UniqueInstance;
    }

    private Repository(IFileRepository fileRepository) {
        try {
            ClassFile[] classFiles = SubtypeLoader.loadSubtypesFromStream(PropertyManager.getAnalysisSupertype(), fileRepository.getFiles(), PropertyManager.getAnalysisPackage(), PropertyManager.getAnalysisExtension());
            ArrayList<Analysis> listOfAnalyses = new ArrayList<Analysis>(classFiles.length);
            int i = 0;
            while (i < classFiles.length) {
                try {
                    listOfAnalyses.add((Analysis)Class.forName(classFiles[i].getName()).newInstance());
                }
                catch (Throwable t) {
                    System.err.print("Cannot load analysis ");
                    System.err.print(classFiles[i].getName());
                    System.err.println(':');
                    t.printStackTrace();
                }
                ++i;
            }
            this.analyses = new Analysis[listOfAnalyses.size()];
            listOfAnalyses.toArray(this.analyses);
        }
        catch (AccessControlException ace) {
            this.analyses = new Analysis[0];
        }
    }

    public Analysis[] getAnalyses() {
        return this.analyses;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Analysis Repository:\n");
        int x = 0;
        while (x < this.getAnalyses().length) {
            buffer.append('\t');
            buffer.append(this.getAnalyses()[x].getName());
            buffer.append('\n');
            ++x;
        }
        return buffer.toString();
    }
}

