/*
 * Decompiled with CFR 0.152.
 */
package padl.analysis.repository;

import padl.analysis.Analysis;
import padl.analysis.repository.SystematicUMLAnalisysDataTypeCleaner;
import padl.analysis.repository.SystematicUMLAnalisysElementGenerator;
import padl.analysis.repository.SystematicUMLAnalisysEntityGenerator;
import padl.analysis.repository.SystematicUMLAnalisysOperationGenerator;
import padl.analysis.repository.SystematicUMLAnalisysStatistics;
import padl.kernel.IAbstractModel;
import padl.kernel.IIdiomLevelModel;
import padl.kernel.impl.v2.Factory;

public class SystematicUMLAnalisys
implements Analysis {
    public static final String OPERATION = "/* OPERATION */ ";
    public static final String TEMPLATE_METHOD = "/* TEMPLATE METHOD */ ";

    public IAbstractModel analysis(IAbstractModel anAbstractModel) {
        if (anAbstractModel instanceof IIdiomLevelModel) {
            long startTime = System.currentTimeMillis();
            Factory factory = Factory.getUniqueInstance();
            IIdiomLevelModel newIdiomLevelModel = factory.createIdiomLevelModel("Systematic UML analysis of " + anAbstractModel.getName());
            SystematicUMLAnalisysStatistics statistics = new SystematicUMLAnalisysStatistics();
            SystematicUMLAnalisysEntityGenerator entityGenerator = new SystematicUMLAnalisysEntityGenerator(factory, newIdiomLevelModel, statistics);
            anAbstractModel.walk(entityGenerator);
            SystematicUMLAnalisysElementGenerator elementGenerator = new SystematicUMLAnalisysElementGenerator(factory, newIdiomLevelModel, statistics);
            anAbstractModel.walk(elementGenerator);
            SystematicUMLAnalisysDataTypeCleaner dataTypeCleaner = new SystematicUMLAnalisysDataTypeCleaner(factory, newIdiomLevelModel, statistics);
            newIdiomLevelModel.walk(dataTypeCleaner);
            SystematicUMLAnalisysOperationGenerator operationGenerator = new SystematicUMLAnalisysOperationGenerator(factory, newIdiomLevelModel, statistics);
            newIdiomLevelModel.walk(operationGenerator);
            System.out.print(statistics);
            System.out.print("Analysis time: ");
            System.out.print(System.currentTimeMillis() - startTime);
            System.out.println(" ms.\n");
            return newIdiomLevelModel;
        }
        return anAbstractModel;
    }

    public String getName() {
        return "Systematic UML";
    }
}

