/*
 * Decompiled with CFR 0.152.
 */
package padl.analysis.repository;

import java.util.ArrayList;
import java.util.Iterator;
import padl.analysis.repository.SystematicUMLAnalisysStatistics;
import padl.kernel.IAbstractLevelModel;
import padl.kernel.IAggregation;
import padl.kernel.IAssociation;
import padl.kernel.IClass;
import padl.kernel.IComposition;
import padl.kernel.IConstructor;
import padl.kernel.IContainerAggregation;
import padl.kernel.IContainerComposition;
import padl.kernel.ICreation;
import padl.kernel.IDelegatingMethod;
import padl.kernel.IEntity;
import padl.kernel.IFactory;
import padl.kernel.IField;
import padl.kernel.IGhost;
import padl.kernel.IIdiomLevelModel;
import padl.kernel.IInterface;
import padl.kernel.IMethod;
import padl.kernel.IMethodInvocation;
import padl.kernel.IParameter;
import padl.kernel.IPatternModel;
import padl.kernel.IUseRelationship;
import padl.kernel.IWalker;

public class SystematicUMLAnalisysDataTypeCleaner
implements IWalker {
    private final IIdiomLevelModel newIdiomLevelModel;
    private final SystematicUMLAnalisysStatistics statistics;

    public SystematicUMLAnalisysDataTypeCleaner(IFactory aFactory, IIdiomLevelModel anIdiomLevelModel, SystematicUMLAnalisysStatistics aStatistics) {
        this.newIdiomLevelModel = anIdiomLevelModel;
        this.statistics = aStatistics;
    }

    private boolean areAllSuperEntitiesDataTypes(IEntity anEntity) {
        IEntity entity;
        if (anEntity instanceof IGhost) {
            return true;
        }
        if (anEntity.getDisplayName().indexOf("datatype") == -1) {
            return false;
        }
        ArrayList<IEntity> superEntities = new ArrayList<IEntity>();
        Iterator iterator = anEntity.listOfInheritedActors().iterator();
        while (iterator.hasNext()) {
            entity = (IEntity)iterator.next();
            superEntities.add(entity);
        }
        if (anEntity instanceof IClass) {
            iterator = ((IClass)anEntity).listOfImplementedEntities().iterator();
            while (iterator.hasNext()) {
                entity = (IEntity)iterator.next();
                superEntities.add(entity);
            }
        }
        iterator = superEntities.iterator();
        while (iterator.hasNext()) {
            entity = (IEntity)iterator.next();
            if (this.areAllSuperEntitiesDataTypes(entity)) continue;
            return false;
        }
        return true;
    }

    public void close(IAbstractLevelModel anAbstractLevelModel) {
    }

    public void close(IClass aClass) {
    }

    public void close(IGhost aGhost) {
    }

    public void close(IInterface anInterface) {
    }

    public void close(IPatternModel aPatternModel) {
    }

    public String getName() {
        return "SystematicUMLAnalisysDataTypeCleaner";
    }

    public Object getResult() {
        return this.newIdiomLevelModel;
    }

    public void open(IAbstractLevelModel anAbstractLevelModel) {
    }

    public void open(IClass aClass) {
        this.open((IEntity)aClass);
    }

    private void open(IEntity anEntity) {
        if (anEntity.getDisplayName().indexOf("datatype") > 0 && !this.areAllSuperEntitiesDataTypes(anEntity) && !anEntity.isAbstract()) {
            StringBuffer displayName = new StringBuffer();
            displayName.append("<<implementation>>\n");
            displayName.append(anEntity.getName());
            anEntity.setDisplayName(displayName.toString());
            this.statistics.dataTypeUnRecognized(anEntity);
            this.statistics.implementationClassRecognized(anEntity);
        }
    }

    public void open(IGhost aGhost) {
    }

    public void open(IInterface anInterface) {
        this.open((IEntity)anInterface);
    }

    public void open(IPatternModel aPatternModel) {
    }

    public void reset() {
    }

    public void visit(IAggregation anAggregation) {
    }

    public void visit(IAssociation anAssociation) {
    }

    public void visit(IComposition aComposition) {
    }

    public void visit(IConstructor aConstructor) {
    }

    public void visit(IContainerAggregation aContainerAggregation) {
    }

    public void visit(IContainerComposition aContainerComposition) {
    }

    public void visit(ICreation aCreation) {
    }

    public void visit(IDelegatingMethod aDelegatingMethod) {
    }

    public void visit(IField aField) {
    }

    public void visit(IMethod aMethod) {
    }

    public void visit(IMethodInvocation aMethodInvocation) {
    }

    public void visit(IParameter aParameter) {
    }

    public void visit(IUseRelationship aUse) {
    }
}

