/*
 * Decompiled with CFR 0.152.
 */
package padl.analysis.repository;

import java.util.Iterator;
import padl.analysis.repository.SystematicUMLAnalisysStatistics;
import padl.kernel.IAbstractLevelModel;
import padl.kernel.IAggregation;
import padl.kernel.IAssociation;
import padl.kernel.IClass;
import padl.kernel.IComposition;
import padl.kernel.IConstructor;
import padl.kernel.IContainerAggregation;
import padl.kernel.IContainerComposition;
import padl.kernel.ICreation;
import padl.kernel.IDelegatingMethod;
import padl.kernel.IEntity;
import padl.kernel.IFactory;
import padl.kernel.IField;
import padl.kernel.IGhost;
import padl.kernel.IIdiomLevelModel;
import padl.kernel.IInterface;
import padl.kernel.IMethod;
import padl.kernel.IMethodInvocation;
import padl.kernel.IParameter;
import padl.kernel.IPatternModel;
import padl.kernel.IRelationship;
import padl.kernel.IUseRelationship;
import padl.kernel.IWalker;
import padl.kernel.ModelDeclarationException;
import padl.kernel.impl.v2.MethodInvocation;

public class SystematicUMLAnalisysElementGenerator
implements IWalker {
    private final IFactory factory;
    private IEntity newEntity;
    private final IIdiomLevelModel newIdiomLevelModel;
    private IConstructor newMethod;
    private int parameterPosition;
    private final SystematicUMLAnalisysStatistics statistics;

    public SystematicUMLAnalisysElementGenerator(IFactory aFactory, IIdiomLevelModel anIdiomLevelModel, SystematicUMLAnalisysStatistics aStatistics) {
        this.factory = aFactory;
        this.newIdiomLevelModel = anIdiomLevelModel;
        this.statistics = aStatistics;
    }

    public void close(IAbstractLevelModel anAbstractLevelModel) {
    }

    public void close(IClass aClass) {
    }

    public void close(IGhost aGhost) {
    }

    public void close(IInterface anInterface) {
    }

    public void close(IPatternModel aPatternModel) {
    }

    public String getName() {
        return "SystematicUMLAnalisysElementGenerator";
    }

    public Object getResult() {
        return this.newIdiomLevelModel;
    }

    public void open(IAbstractLevelModel anAbstractLevelModel) {
    }

    public void open(IClass aClass) {
        this.open((IEntity)aClass);
        Iterator inheritedActors = aClass.listOfInheritedActors().iterator();
        while (inheritedActors.hasNext()) {
            try {
                this.newEntity.addInheritedActor((IEntity)this.newIdiomLevelModel.getActorFromID(((IEntity)inheritedActors.next()).getName()));
            }
            catch (ModelDeclarationException mde) {
                mde.printStackTrace();
            }
        }
        Iterator implementedEntities = aClass.listOfImplementedEntities().iterator();
        while (implementedEntities.hasNext()) {
            try {
                ((IClass)this.newEntity).addImplementedEntity((IEntity)this.newIdiomLevelModel.getActorFromID(((IEntity)implementedEntities.next()).getName()));
            }
            catch (ModelDeclarationException mde) {
                mde.printStackTrace();
            }
        }
    }

    private void open(IEntity anEntity) {
        this.newEntity = (IEntity)this.newIdiomLevelModel.getActorFromID(anEntity.getActorID());
    }

    public void open(IGhost aGhost) {
        this.open((IEntity)aGhost);
    }

    public void open(IInterface anInterface) {
        this.open((IEntity)anInterface);
        Iterator inheritedActors = anInterface.listOfInheritedActors().iterator();
        while (inheritedActors.hasNext()) {
            try {
                this.newEntity.addInheritedActor((IEntity)this.newIdiomLevelModel.getActorFromID(((IEntity)inheritedActors.next()).getName()));
            }
            catch (ModelDeclarationException mde) {
                mde.printStackTrace();
            }
        }
    }

    public void open(IPatternModel aPatternModel) {
    }

    public void reset() {
    }

    public void visit(IAggregation anAggregation) {
        this.visit((IRelationship)anAggregation);
    }

    public void visit(IAssociation anAssociation) {
        this.visit((IRelationship)anAssociation);
    }

    public void visit(IComposition aComposition) {
        this.visit((IRelationship)aComposition);
    }

    public void visit(IConstructor aConstructor) {
        try {
            this.newMethod = this.factory.createConstructor(aConstructor.getActorID());
            this.newMethod.setVisibility(aConstructor.getVisibility());
            this.newMethod.setName(aConstructor.getName());
            this.newEntity.addActor(this.newMethod);
            this.parameterPosition = 0;
        }
        catch (ModelDeclarationException mde) {
            mde.printStackTrace();
        }
    }

    public void visit(IContainerAggregation aContainerAggregation) {
        this.visit((IRelationship)aContainerAggregation);
    }

    public void visit(IContainerComposition aContainerComposition) {
        this.visit((IRelationship)aContainerComposition);
    }

    public void visit(ICreation aCreation) {
        this.visit((IRelationship)aCreation);
    }

    public void visit(IDelegatingMethod aDelegatingMethod) {
        this.visit((IMethod)aDelegatingMethod);
    }

    public void visit(IField aField) {
        try {
            this.newEntity.addActor(this.factory.createField(aField.getName(), aField.getType()));
        }
        catch (ModelDeclarationException mde) {
            mde.printStackTrace();
        }
    }

    public void visit(IMethod aMethod) {
        try {
            this.newMethod = this.factory.createMethod(aMethod.getActorID());
            this.newMethod.setVisibility(aMethod.getVisibility());
            ((IMethod)this.newMethod).setReturnType(aMethod.getReturnType());
            this.newMethod.setName(aMethod.getName());
            this.newEntity.addActor(this.newMethod);
            this.parameterPosition = 0;
        }
        catch (ModelDeclarationException mde) {
            mde.printStackTrace();
        }
    }

    public void visit(IMethodInvocation aMethodInvocation) {
        try {
            if (aMethodInvocation.getTargetEntity() != null) {
                MethodInvocation methodInvocation = new MethodInvocation((IEntity)this.newIdiomLevelModel.getActorFromID(aMethodInvocation.getOriginEntity().getActorID()), aMethodInvocation.getType(), aMethodInvocation.getCardinality(), (IEntity)this.newIdiomLevelModel.getActorFromID(aMethodInvocation.getTargetEntity().getActorID()));
                methodInvocation.setCallingField(aMethodInvocation.getCallingFields());
                methodInvocation.setCalledMethod((IConstructor)this.newEntity.getActorFromID(aMethodInvocation.getCalledMethod().getActorID()));
                this.newMethod.addActor(methodInvocation);
            }
        }
        catch (ModelDeclarationException modelDeclarationException) {
            // empty catch block
        }
    }

    public void visit(IParameter aParameter) {
        try {
            this.newMethod.addActor(this.factory.createParameter(this.parameterPosition++, aParameter.getName(), aParameter.getType()));
        }
        catch (ModelDeclarationException mde) {
            mde.printStackTrace();
        }
    }

    private void visit(IRelationship aRelationship) {
        try {
            this.newEntity.addActor(this.factory.createAggregationRelationship(aRelationship.getName(), (IEntity)this.newIdiomLevelModel.getActorFromID(aRelationship.getTargetActor().getActorID()), aRelationship.getCardinality()));
        }
        catch (ModelDeclarationException mde) {
            mde.printStackTrace();
        }
    }

    public void visit(IUseRelationship aUse) {
        this.visit((IRelationship)aUse);
    }
}

