/*
 * Decompiled with CFR 0.152.
 */
package padl.analysis.repository;

import java.util.ArrayList;
import java.util.List;
import padl.analysis.repository.SystematicUMLAnalisysStatistics;
import padl.kernel.IAbstractLevelModel;
import padl.kernel.IAggregation;
import padl.kernel.IAssociation;
import padl.kernel.IClass;
import padl.kernel.IComposition;
import padl.kernel.IConstructor;
import padl.kernel.IContainerAggregation;
import padl.kernel.IContainerComposition;
import padl.kernel.ICreation;
import padl.kernel.IDelegatingMethod;
import padl.kernel.IEntity;
import padl.kernel.IFactory;
import padl.kernel.IField;
import padl.kernel.IGhost;
import padl.kernel.IIdiomLevelModel;
import padl.kernel.IInterface;
import padl.kernel.IMethod;
import padl.kernel.IMethodInvocation;
import padl.kernel.IParameter;
import padl.kernel.IPatternModel;
import padl.kernel.IUseRelationship;
import padl.kernel.IWalker;
import padl.kernel.ModelDeclarationException;
import util.lang.Modifier;

public class SystematicUMLAnalisysEntityGenerator
implements IWalker {
    private final IFactory factory;
    private final IIdiomLevelModel newIdiomLevelModel;
    private final SystematicUMLAnalisysStatistics statistics;
    private final List fieldNames;
    private boolean hasConcreteMethods;
    private boolean hasInstanceMethods;
    private boolean hasMethods;
    private boolean hasPublicStaticFinalFieldsOnly;
    private boolean isMethod;
    private boolean hasPrivateNonStaticFieldsOnly;
    private boolean hasFields;
    private boolean hasFieldAssignments;

    public SystematicUMLAnalisysEntityGenerator(IFactory aFactory, IIdiomLevelModel anIdiomLevelModel, SystematicUMLAnalisysStatistics aStatistics) {
        this.factory = aFactory;
        this.newIdiomLevelModel = anIdiomLevelModel;
        this.statistics = aStatistics;
        this.fieldNames = new ArrayList();
    }

    public void close(IAbstractLevelModel anAbstractLevelModel) {
    }

    public void close(IClass aClass) {
        try {
            IClass newClass = this.factory.createClass(aClass.getActorID());
            this.close(aClass, newClass);
        }
        catch (ModelDeclarationException mde) {
            mde.printStackTrace();
        }
    }

    private void close(IEntity originalEntity, IEntity newEntity) {
        try {
            StringBuffer displayName = new StringBuffer();
            if (!this.hasConcreteMethods && this.hasMethods) {
                displayName.append("<<type>>\n");
                this.statistics.typeRecognized(newEntity);
            } else if (this.hasFields && this.hasPublicStaticFinalFieldsOnly && !this.hasMethods) {
                displayName.append("<<enumeration>>\n");
                this.statistics.enumerationRecognized(newEntity);
            } else if (originalEntity instanceof IClass) {
                if (!this.hasInstanceMethods && this.hasMethods) {
                    displayName.append("<<utility>>\n");
                    this.statistics.utilityClassRecognized(newEntity);
                } else if (this.hasPrivateNonStaticFieldsOnly && this.hasFields && !this.hasFieldAssignments && !originalEntity.isAbstract()) {
                    displayName.append("<<datatype>>\n");
                    this.statistics.dataTypeRecognized(newEntity);
                } else if (!originalEntity.isAbstract()) {
                    displayName.append("<<implementation>>\n");
                    this.statistics.implementationClassRecognized(newEntity);
                }
            }
            displayName.append(originalEntity.getName());
            newEntity.setName(originalEntity.getName());
            newEntity.setDisplayName(displayName.toString());
            this.newIdiomLevelModel.addActor(newEntity);
        }
        catch (ModelDeclarationException mde) {
            mde.printStackTrace();
        }
    }

    public void close(IGhost aGhost) {
        try {
            this.newIdiomLevelModel.addActor(this.factory.createGhost(aGhost.getName()));
        }
        catch (ModelDeclarationException mde) {
            mde.printStackTrace();
        }
    }

    public void close(IInterface anInterface) {
        try {
            IInterface newInterface = this.factory.createInterface(anInterface.getActorID());
            this.close(anInterface, newInterface);
        }
        catch (ModelDeclarationException mde) {
            mde.printStackTrace();
        }
    }

    public void close(IPatternModel aPatternModel) {
    }

    public String getName() {
        return "SystematicUMLAnalisysEntityGenerator";
    }

    public Object getResult() {
        return this.newIdiomLevelModel;
    }

    public void open(IAbstractLevelModel anAbstractLevelModel) {
        System.currentTimeMillis();
    }

    public void open(IClass aClass) {
        this.open();
    }

    private void open() {
        this.hasConcreteMethods = false;
        this.hasInstanceMethods = false;
        this.hasMethods = false;
        this.hasPublicStaticFinalFieldsOnly = true;
        this.hasPrivateNonStaticFieldsOnly = true;
        this.hasFields = false;
        this.hasFieldAssignments = false;
    }

    public void open(IGhost aGhost) {
        this.open();
    }

    public void open(IInterface anInterface) {
        this.open();
    }

    public void open(IPatternModel aPatternModel) {
    }

    public void reset() {
    }

    public void visit(IAggregation anAggregation) {
    }

    public void visit(IAssociation anAssociation) {
    }

    public void visit(IComposition aComposition) {
    }

    public void visit(IConstructor aConstructor) {
        this.isMethod = false;
    }

    public void visit(IContainerAggregation aContainerAggregation) {
    }

    public void visit(IContainerComposition aContainerComposition) {
    }

    public void visit(ICreation aCreation) {
    }

    public void visit(IDelegatingMethod aDelegatingMethod) {
    }

    public void visit(IField aField) {
        if (!(aField.isPublic() && aField.isStatic() && Modifier.isFinal(aField.getVisibility()))) {
            this.hasPublicStaticFinalFieldsOnly = false;
        }
        if (!aField.isStatic() && !aField.isPrivate()) {
            this.hasPrivateNonStaticFieldsOnly = false;
        }
        this.hasFields = true;
    }

    public void visit(IMethod aMethod) {
        if (!aMethod.isAbstract()) {
            this.hasConcreteMethods = true;
        }
        if (!aMethod.isStatic()) {
            this.hasInstanceMethods = true;
        }
        this.hasMethods = true;
        if (!aMethod.getName().equals("<clinit>")) {
            this.isMethod = true;
        }
    }

    public void visit(IMethodInvocation aMethodInvocation) {
        if (this.isMethod && aMethodInvocation.getCalledMethod() != null && aMethodInvocation.getCalledMethod().getName().equals("=")) {
            this.hasFieldAssignments = true;
        }
    }

    public void visit(IParameter aParameter) {
    }

    public void visit(IUseRelationship aUse) {
    }
}

