/*
 * Decompiled with CFR 0.152.
 */
package padl.analysis.repository;

import java.util.Iterator;
import padl.analysis.repository.SystematicUMLAnalisysStatistics;
import padl.kernel.IAbstractLevelModel;
import padl.kernel.IAggregation;
import padl.kernel.IAssociation;
import padl.kernel.IClass;
import padl.kernel.IComposition;
import padl.kernel.IConstructor;
import padl.kernel.IContainerAggregation;
import padl.kernel.IContainerComposition;
import padl.kernel.ICreation;
import padl.kernel.IDelegatingMethod;
import padl.kernel.IElement;
import padl.kernel.IEntity;
import padl.kernel.IFactory;
import padl.kernel.IField;
import padl.kernel.IGhost;
import padl.kernel.IIdiomLevelModel;
import padl.kernel.IInterface;
import padl.kernel.IMethod;
import padl.kernel.IMethodInvocation;
import padl.kernel.IParameter;
import padl.kernel.IPatternModel;
import padl.kernel.IUseRelationship;
import padl.kernel.IWalker;

public class SystematicUMLAnalisysOperationGenerator
implements IWalker {
    private IEntity currentEntity;
    private final IIdiomLevelModel currentIdiomLevelModel;
    private final IFactory factory;
    private final SystematicUMLAnalisysStatistics statistics;

    public SystematicUMLAnalisysOperationGenerator(IFactory aFactory, IIdiomLevelModel anIdiomLevelModel, SystematicUMLAnalisysStatistics aStatistics) {
        this.factory = aFactory;
        this.currentIdiomLevelModel = anIdiomLevelModel;
        this.statistics = aStatistics;
    }

    public void close(IAbstractLevelModel anAbstractLevelModel) {
    }

    public void close(IClass aClass) {
    }

    public void close(IGhost aGhost) {
    }

    public void close(IInterface anInterface) {
    }

    public void close(IPatternModel aPatternModel) {
    }

    public String getName() {
        return "SystematicUMLAnalisysOperationGenerator";
    }

    public Object getResult() {
        return this.currentIdiomLevelModel;
    }

    private void heuristic1(IMethod aMethod) {
        if (aMethod.isAbstract()) {
            boolean isTemplateMethod = false;
            Iterator iteratorOnMethods = this.currentEntity.listOfActors().iterator();
            while (iteratorOnMethods.hasNext() && !isTemplateMethod) {
                IElement methodElement = (IElement)iteratorOnMethods.next();
                if (!(methodElement instanceof IMethod)) continue;
                IMethod method = (IMethod)methodElement;
                Iterator interatorOnMethodInvocations = method.listOfActors().iterator();
                while (interatorOnMethodInvocations.hasNext() && !isTemplateMethod) {
                    IMethodInvocation methodInvocation;
                    IElement methodInvocationElement = (IElement)interatorOnMethodInvocations.next();
                    if (!(methodInvocationElement instanceof IMethodInvocation) || (methodInvocation = (IMethodInvocation)methodInvocationElement).getCalledMethod() == null || !methodInvocation.getCalledMethod().equals(aMethod)) continue;
                    isTemplateMethod = true;
                }
            }
            if (isTemplateMethod) {
                aMethod.setDisplayName("/* TEMPLATE METHOD */ " + aMethod.getName());
                this.statistics.operationRecognized(aMethod);
            } else {
                aMethod.setDisplayName("/* OPERATION */ " + aMethod.getName());
                this.statistics.operationRecognized(aMethod);
            }
        }
    }

    private void heuristic2(IMethod aMethod) {
        if (this.isMethodOverLoaded(aMethod, this.currentEntity)) {
            this.setMethodAsOperation(aMethod.getName(), this.currentEntity);
        }
    }

    private boolean isMethodOverLoaded(IMethod aMethod, IEntity anEntity) {
        boolean isOverLoaded = false;
        Iterator iteratorOnMethods = anEntity.listOfActors().iterator();
        while (iteratorOnMethods.hasNext() && !isOverLoaded) {
            IMethod method;
            IElement methodElement = (IElement)iteratorOnMethods.next();
            if (!(methodElement instanceof IMethod) || (method = (IMethod)methodElement).equals(aMethod) || !method.getName().equals(aMethod.getName())) continue;
            StringBuffer listOfParameters1 = new StringBuffer();
            Iterator iteratorOnParameters1 = method.listOfActors().iterator();
            while (iteratorOnParameters1.hasNext()) {
                IElement element = (IElement)iteratorOnParameters1.next();
                if (!(element instanceof IParameter)) continue;
                listOfParameters1.append(((IParameter)element).getType());
            }
            StringBuffer listOfParameters2 = new StringBuffer();
            Iterator iteratorOnParameters2 = aMethod.listOfActors().iterator();
            while (iteratorOnParameters2.hasNext()) {
                IElement element = (IElement)iteratorOnParameters2.next();
                if (!(element instanceof IParameter)) continue;
                listOfParameters2.append(((IParameter)element).getType());
            }
            if (listOfParameters1.equals(listOfParameters2)) continue;
            isOverLoaded = true;
        }
        Iterator iteratorOnSuperEntities = anEntity.listOfInheritedActors().iterator();
        while (iteratorOnSuperEntities.hasNext() && !isOverLoaded) {
            isOverLoaded = this.isMethodOverLoaded(aMethod, (IEntity)iteratorOnSuperEntities.next());
        }
        return isOverLoaded;
    }

    public void open(IAbstractLevelModel anAbstractLevelModel) {
    }

    public void open(IClass aClass) {
        this.open((IEntity)aClass);
    }

    private void open(IEntity anEntity) {
        this.currentEntity = (IEntity)this.currentIdiomLevelModel.getActorFromID(anEntity.getActorID());
    }

    public void open(IGhost aGhost) {
        this.open((IEntity)aGhost);
    }

    public void open(IInterface anInterface) {
        this.open((IEntity)anInterface);
    }

    public void open(IPatternModel aPatternModel) {
    }

    public void reset() {
    }

    private void setMethodAsOperation(String aName, IEntity anEntity) {
        Iterator iteratorOnMethods = anEntity.listOfActors().iterator();
        while (iteratorOnMethods.hasNext()) {
            IMethod method;
            IElement methodElement = (IElement)iteratorOnMethods.next();
            if (!(methodElement instanceof IMethod) || !(method = (IMethod)methodElement).getName().equals(aName)) continue;
            method.setDisplayName("/* OPERATION */ " + method.getName());
            this.statistics.operationRecognized(method);
        }
        Iterator iteratorOnSuperEntities = anEntity.listOfInheritedActors().iterator();
        while (iteratorOnSuperEntities.hasNext()) {
            this.setMethodAsOperation(aName, (IEntity)iteratorOnSuperEntities.next());
        }
    }

    public void visit(IAggregation anAggregation) {
    }

    public void visit(IAssociation anAssociation) {
    }

    public void visit(IComposition aComposition) {
    }

    public void visit(IConstructor aConstructor) {
    }

    public void visit(IContainerAggregation aContainerAggregation) {
    }

    public void visit(IContainerComposition aContainerComposition) {
    }

    public void visit(ICreation aCreation) {
    }

    public void visit(IDelegatingMethod aDelegatingMethod) {
    }

    public void visit(IField aField) {
    }

    public void visit(IMethod aMethod) {
        this.heuristic1(aMethod);
        this.heuristic2(aMethod);
    }

    public void visit(IMethodInvocation aMethodInvocation) {
    }

    public void visit(IParameter aParameter) {
    }

    public void visit(IUseRelationship aUse) {
    }
}

