/*
 * Decompiled with CFR 0.152.
 */
package padl.kernel.impl.v1;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import padl.event.EntityEvent;
import padl.kernel.IAbstractLevelModel;
import padl.kernel.IAbstractModel;
import padl.kernel.IConstituent;
import padl.kernel.IEntity;
import padl.kernel.IFactory;
import padl.kernel.IGenerator;
import padl.kernel.IGhost;
import padl.kernel.IWalker;
import padl.kernel.ListenerManager;
import padl.kernel.ModelDeclarationException;
import util.io.OutputManager;

abstract class AbstractLevelModel
implements IAbstractLevelModel,
PropertyChangeListener,
VetoableChangeListener {
    private IFactory factory;
    private List listOfEntities = new ArrayList();

    AbstractLevelModel() {
    }

    public void addActor(IConstituent constituent) throws ModelDeclarationException {
        if (this.listOfActors().contains(constituent)) {
            throw new ModelDeclarationException("Duplicate ActorID: " + constituent.getActorID());
        }
        this.listOfEntities.add(constituent);
    }

    public void addGhostActor(String aName) throws ModelDeclarationException {
        IGhost ghost = this.getFactory().createGhost(aName);
        if (this.listOfActors().contains(ghost)) {
            throw new ModelDeclarationException("Duplicate ActorID: " + ghost.getActorID());
        }
        this.listOfEntities.add(ghost);
    }

    public final String generate(IGenerator builder) {
        builder.open(this);
        Iterator iterator = this.listOfEntities.iterator();
        while (iterator.hasNext()) {
            ((IConstituent)iterator.next()).accept(builder);
        }
        builder.close(this);
        return builder.getCode();
    }

    public final Object clone() throws CloneNotSupportedException {
        AbstractLevelModel clonedModel = (AbstractLevelModel)super.clone();
        clonedModel.listOfEntities = new ArrayList();
        Iterator iterator = this.listOfEntities.iterator();
        while (iterator.hasNext()) {
            IEntity pEntity = (IEntity)iterator.next();
            pEntity.startCloneSession();
            try {
                clonedModel.addActor((IEntity)pEntity.getClone());
            }
            catch (ModelDeclarationException pde) {
                pde.printStackTrace(OutputManager.getCurrentOutputManager().getErrorOutput());
            }
        }
        iterator = this.listOfEntities.iterator();
        while (iterator.hasNext()) {
            ((IEntity)iterator.next()).performCloneSession();
        }
        iterator = this.listOfEntities.iterator();
        while (iterator.hasNext()) {
            ((IEntity)iterator.next()).endCloneSession();
        }
        return clonedModel;
    }

    public final boolean doesContainActorWithID(String anID) {
        Iterator iterator = this.listOfEntities.iterator();
        while (iterator.hasNext()) {
            IConstituent currentConsituent = (IConstituent)iterator.next();
            if (!currentConsituent.getActorID().equals(anID)) continue;
            return true;
        }
        return false;
    }

    public final boolean doesContainActorWithName(String aName) {
        Iterator iterator = this.listOfEntities.iterator();
        while (iterator.hasNext()) {
            IConstituent currentConsituent = (IConstituent)iterator.next();
            if (!currentConsituent.getName().equals(aName)) continue;
            return true;
        }
        return false;
    }

    public final IConstituent getActorFromID(String anID) {
        Iterator iterator = this.listOfEntities.iterator();
        while (iterator.hasNext()) {
            IConstituent currentElement = (IConstituent)iterator.next();
            if (!currentElement.getActorID().equals(anID)) continue;
            return currentElement;
        }
        return null;
    }

    public final IConstituent getActorFromName(String aName) {
        Iterator iterator = this.listOfEntities.iterator();
        while (iterator.hasNext()) {
            IConstituent currentElement = (IConstituent)iterator.next();
            if (!currentElement.getName().equals(aName)) continue;
            return currentElement;
        }
        return null;
    }

    public IFactory getFactory() {
        return this.factory;
    }

    public abstract String getName();

    public final List listOfActors() {
        return this.listOfEntities;
    }

    public void propertyChange(PropertyChangeEvent e) {
    }

    private final void removeActor(IEntity aPEntity) {
        this.listOfEntities.remove(aPEntity);
        ListenerManager.getCurrentListenerManager().fireModelChange("entityRemoved", new EntityEvent(this, aPEntity));
    }

    public final void removeActor(String anActorID) {
        this.removeActor((IEntity)this.getActorFromID(anActorID));
    }

    public final void removeAllActors() {
        while (this.listOfEntities.size() > 0) {
            this.removeActor((IEntity)this.listOfEntities.get(0));
        }
    }

    public void setFactory(IFactory aFactory) {
        this.factory = aFactory;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        Iterator iterator = this.listOfEntities.iterator();
        while (iterator.hasNext()) {
            buffer.append(iterator.next().toString());
            if (!iterator.hasNext()) continue;
            buffer.append('\n');
        }
        return buffer.toString();
    }

    public final void vetoableChange(PropertyChangeEvent e) throws PropertyVetoException {
    }

    public final Object walk(IWalker walker) {
        walker.open(this);
        Iterator iterator = this.listOfEntities.iterator();
        while (iterator.hasNext()) {
            ((IConstituent)iterator.next()).accept(walker);
        }
        walker.close(this);
        return walker.getResult();
    }

    public abstract List compare(IAbstractModel var1);
}

