/*
 * Decompiled with CFR 0.152.
 */
package padl.kernel.impl.v1;

import com.ibm.toad.cfparse.utils.Access;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import padl.kernel.IClass;
import padl.kernel.IEntity;
import padl.kernel.IEntityMarker;
import padl.kernel.IInterface;
import padl.kernel.ModelDeclarationException;
import padl.kernel.impl.v1.Element;
import padl.kernel.impl.v1.Entity;
import padl.kernel.impl.v1.Interface;
import util.io.OutputManager;

class Class
extends Entity
implements IEntityMarker,
IClass {
    private boolean forceAbstract = false;
    private List listOfSuperInterfaces = new ArrayList();

    public Class(String anActorID) {
        super(anActorID);
    }

    public Class(String anActorID, IEntity inheritedEntity) {
        super(anActorID);
        try {
            this.addInheritedActor(inheritedEntity);
        }
        catch (ModelDeclarationException modelDeclarationException) {
            // empty catch block
        }
    }

    public void addImplementedEntity(IEntity anEntity) throws ModelDeclarationException {
        if (this.listOfSuperInterfaces.contains(anEntity)) {
            throw new ModelDeclarationException(String.valueOf(anEntity.getActorID()) + " is already implemented by " + this.getActorID());
        }
        try {
            ArrayList oldListShouldImplement = new ArrayList(this.listOfSuperInterfaces);
            this.fireVetoableChange("AddShouldImplement", oldListShouldImplement, anEntity);
            this.listOfSuperInterfaces.add(anEntity);
            this.firePropertyChange("AddShouldImplement", oldListShouldImplement, anEntity);
        }
        catch (PropertyVetoException e) {
            e.printStackTrace(OutputManager.getCurrentOutputManager().getErrorOutput());
        }
    }

    public void assumeAllInterfaces() {
        try {
            Iterator iterator = this.listOfSuperInterfaces.iterator();
            while (iterator.hasNext()) {
                this.assumeInterface((Interface)iterator.next());
            }
        }
        catch (ModelDeclarationException modelDeclarationException) {
            // empty catch block
        }
    }

    public void assumeInterface(IInterface anInterface) throws ModelDeclarationException {
        if (!this.listOfSuperInterfaces.contains(anInterface)) {
            throw new ModelDeclarationException(String.valueOf(anInterface.getActorID()) + " is not implemented by " + this.getActorID());
        }
        Iterator iterator = anInterface.listOfActors().iterator();
        while (iterator.hasNext()) {
            try {
                Element orgElement = (Element)iterator.next();
                orgElement.startCloneSession();
                Element dupElement = (Element)orgElement.getClone();
                orgElement.endCloneSession();
                dupElement.setAbstract(false);
                dupElement.attachTo(orgElement);
                this.addActor(dupElement);
            }
            catch (ModelDeclarationException modelDeclarationException) {
                // empty catch block
            }
        }
    }

    public IEntity getImplementedEntity(String anEntityName) {
        Iterator iterator = this.listOfImplementedEntities().iterator();
        while (iterator.hasNext()) {
            Entity implementedEntity = (Entity)iterator.next();
            if (!implementedEntity.getName().equals(anEntityName)) continue;
            return implementedEntity;
        }
        return null;
    }

    public boolean isForceAbstract() {
        return this.forceAbstract;
    }

    public List listOfImplementedEntities() {
        return this.listOfSuperInterfaces;
    }

    public void performCloneSession() {
        super.performCloneSession();
        Class clonedPClass = (Class)this.getClone();
        clonedPClass.listOfSuperInterfaces = new ArrayList(this.listOfSuperInterfaces.size());
        Iterator iterator = this.listOfSuperInterfaces.iterator();
        while (iterator.hasNext()) {
            Entity currentInterface = (Entity)iterator.next();
            if (currentInterface.getClone() == null) continue;
            clonedPClass.listOfSuperInterfaces.add((Entity)currentInterface.getClone());
        }
    }

    public void propertyChange(PropertyChangeEvent e) {
        super.propertyChange(e);
        if (this.listOfActors().contains(e.getSource()) && e.getPropertyName().equals("Visibility") && !this.isForceAbstract()) {
            if (Access.isAbstract((Integer)e.getNewValue())) {
                try {
                    this.setAbstract(true);
                }
                catch (ModelDeclarationException ex) {}
            } else if (this.isAbstract()) {
                Iterator iterator = this.listOfActors().iterator();
                boolean oneAbstract = false;
                while (iterator.hasNext() && !oneAbstract) {
                    oneAbstract = ((Element)iterator.next()).isAbstract();
                }
                if (!oneAbstract) {
                    try {
                        this.setAbstract(false);
                    }
                    catch (ModelDeclarationException modelDeclarationException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public void removeImplementedEntity(IEntity anEntity) {
        try {
            List oldListOfImplementedEntities = this.listOfImplementedEntities();
            this.fireVetoableChange("RemoveImplementedEntity", oldListOfImplementedEntities, anEntity);
            this.listOfSuperInterfaces.remove(anEntity);
            this.firePropertyChange("RemoveImplementedEntity", oldListOfImplementedEntities, anEntity);
        }
        catch (PropertyVetoException e) {
            e.printStackTrace(OutputManager.getCurrentOutputManager().getErrorOutput());
        }
    }

    public void setAbstract(boolean aBoolean) throws ModelDeclarationException {
        this.forceAbstract = aBoolean;
        super.setAbstract(aBoolean);
    }

    public void setVisibility(int visibility) throws ModelDeclarationException {
        super.setVisibility(this.isForceAbstract() ? visibility | 0x400 : visibility);
    }

    public String toString() {
        StringBuffer codeEq = new StringBuffer();
        codeEq.append(super.toString());
        codeEq.append(" class ");
        codeEq.append(this.getName());
        if (this.listOfInheritedActors().size() > 0) {
            codeEq.append(" extends ");
            Iterator iterator = this.listOfInheritedActors().iterator();
            while (iterator.hasNext()) {
                codeEq.append(((Entity)iterator.next()).getName());
                if (!iterator.hasNext()) continue;
                codeEq.append(", ");
            }
        }
        if (this.listOfImplementedEntities().size() > 0) {
            codeEq.append(" implements ");
            Iterator iterator = this.listOfSuperInterfaces.iterator();
            while (iterator.hasNext()) {
                codeEq.append(((Entity)iterator.next()).getName());
                if (!iterator.hasNext()) continue;
                codeEq.append(", ");
            }
        }
        return codeEq.toString();
    }
}

