/*
 * Decompiled with CFR 0.152.
 */
package padl.kernel.impl.v1;

import com.ibm.toad.cfparse.utils.Access;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import padl.kernel.IConstituent;
import padl.kernel.IIdiomLevelModel;
import padl.kernel.IVisitor;
import padl.kernel.ModelDeclarationException;
import padl.util.Misc;
import util.io.OutputManager;

abstract class Constituent
implements PropertyChangeListener,
VetoableChangeListener,
IConstituent {
    private String actorID;
    private PropertyChangeSupport boundList = new PropertyChangeSupport(this);
    private Constituent clone;
    private List clonedBoundEventList = new ArrayList(0);
    private List clonedVetoEventList = new ArrayList(0);
    private String[] codeLines;
    private String comment;
    private String name;
    private String displayName;
    private VetoableChangeSupport vetoList = new VetoableChangeSupport(this);
    private int visibility = 1;
    private int weight = 100;

    public static List recognize(List listOfSubmittedConstituents, IIdiomLevelModel aPatternIntrospector) {
        return listOfSubmittedConstituents;
    }

    public static int recognizeRequestOrder() {
        return 50;
    }

    public Constituent(String actorID) {
        this.actorID = actorID;
        this.setName(actorID);
    }

    public void accept(IVisitor visitor) {
        this.accept(visitor, "visit");
    }

    protected void accept(IVisitor visitor, String methodName) {
        try {
            Class[] argument = new Class[]{Class.forName(this.getClass().getName().replaceAll(".impl.v1.", ".I"))};
            Method method = visitor.getClass().getMethod(methodName, argument);
            method.invoke((Object)visitor, this);
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace(OutputManager.getCurrentOutputManager().getErrorOutput());
        }
        catch (NoSuchMethodException nsme) {
            nsme.printStackTrace(OutputManager.getCurrentOutputManager().getErrorOutput());
        }
        catch (IllegalAccessException iae) {
            iae.printStackTrace(OutputManager.getCurrentOutputManager().getErrorOutput());
        }
        catch (InvocationTargetException ite) {
            ite.printStackTrace(OutputManager.getCurrentOutputManager().getErrorOutput());
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener aListener) {
        this.boundList.addPropertyChangeListener(aListener);
        aListener.propertyChange(new PropertyChangeEvent(this, "Name", this.getName(), this.getName()));
        aListener.propertyChange(new PropertyChangeEvent(this, "Visibility", new Integer(this.getVisibility()), new Integer(this.getVisibility())));
    }

    public void addVetoableChangeListener(VetoableChangeListener aListener) {
        this.vetoList.addVetoableChangeListener(aListener);
    }

    public void endCloneSession() {
        this.clone = null;
        this.clonedBoundEventList.clear();
        this.clonedVetoEventList.clear();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof IConstituent)) {
            return false;
        }
        return this.actorID.equals(((Constituent)obj).getActorID());
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.boundList.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void fireVetoableChange(String propertyName, Object oldValue, Object newValue) throws PropertyVetoException {
        this.vetoList.fireVetoableChange(propertyName, oldValue, newValue);
    }

    public String getActorID() {
        return this.actorID;
    }

    public IConstituent getClone() {
        return this.clone;
    }

    public String[] getCodeLines() {
        return this.codeLines;
    }

    public String getComment() {
        return this.comment;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getName() {
        return this.name;
    }

    public int getVisibility() {
        return this.visibility;
    }

    public int getWeight() {
        return this.weight;
    }

    public int hashCode() {
        return this.actorID.hashCode();
    }

    public boolean isAbstract() {
        return Access.isAbstract(this.visibility);
    }

    public boolean isPrivate() {
        return Access.isPrivate(this.visibility);
    }

    public boolean isPublic() {
        return Access.isPublic(this.visibility);
    }

    public boolean isStatic() {
        return Access.isStatic(this.visibility);
    }

    public void performCloneSession() {
    }

    public void removePropertyChangeListener(PropertyChangeListener aListener) {
        this.boundList.removePropertyChangeListener(aListener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener aListener) {
        this.vetoList.removeVetoableChangeListener(aListener);
    }

    public void resetCodeLines() throws ModelDeclarationException {
        this.setCodeLines((String)null);
    }

    public void setAbstract(boolean aBoolean) throws ModelDeclarationException {
        this.setVisibility(aBoolean ? this.getVisibility() | 0x400 : this.getVisibility() & 0xFFFFFBFF);
    }

    public void setCodeLines(String code) throws ModelDeclarationException {
        this.setCodeLines(new String[]{code});
    }

    public void setCodeLines(String[] code) throws ModelDeclarationException {
        if (this.isAbstract()) {
            throw new ModelDeclarationException("This Element can't contain code definition");
        }
        try {
            String[] oldCodeLines = this.getCodeLines();
            this.fireVetoableChange("StringCode", oldCodeLines, code);
            this.codeLines = code;
            this.firePropertyChange("StringCode", oldCodeLines, code);
        }
        catch (PropertyVetoException e) {
            e.printStackTrace(OutputManager.getCurrentOutputManager().getErrorOutput());
        }
    }

    public void setComment(String aComment) {
        this.comment = aComment;
    }

    public void setDisplayName(String aName) {
        this.displayName = aName;
    }

    public void setName(String aName) {
        try {
            this.fireVetoableChange("Name", this.name, aName);
            this.name = aName;
            this.displayName = aName;
            this.firePropertyChange("Name", this.name, aName);
        }
        catch (PropertyVetoException e) {
            e.printStackTrace(OutputManager.getCurrentOutputManager().getErrorOutput());
        }
    }

    public void setPrivate(boolean aBoolean) {
        try {
            this.setVisibility(aBoolean ? (this.getVisibility() | 2) & 0xFFFFFFFA : this.getVisibility() & 0xFFFFFFFD);
        }
        catch (ModelDeclarationException modelDeclarationException) {
            // empty catch block
        }
    }

    public void setPublic(boolean aBoolean) {
        try {
            this.setVisibility(aBoolean ? (this.getVisibility() | 1) & 0xFFFFFFF9 : this.getVisibility() & 0xFFFFFFFE);
        }
        catch (ModelDeclarationException modelDeclarationException) {
            // empty catch block
        }
    }

    public void setStatic(boolean aBoolean) {
        try {
            this.setVisibility(aBoolean ? this.getVisibility() | 8 : this.getVisibility() & 0xFFFFFFF7);
        }
        catch (ModelDeclarationException modelDeclarationException) {
            // empty catch block
        }
    }

    public void setVisibility(int visibility) throws ModelDeclarationException {
        if (this.getCodeLines() != null && Access.isAbstract(visibility)) {
            throw new ModelDeclarationException("This element can't be abstract");
        }
        try {
            int oldVisibility = this.getVisibility();
            this.fireVetoableChange("Visibility", new Integer(oldVisibility), new Integer(visibility));
            this.visibility = visibility;
            this.firePropertyChange("Visibility", new Integer(oldVisibility), new Integer(visibility));
        }
        catch (PropertyVetoException e) {
            e.printStackTrace(OutputManager.getCurrentOutputManager().getErrorOutput());
        }
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }

    public void startCloneSession() {
        try {
            Constituent tmpObject = (Constituent)super.clone();
            tmpObject.boundList = new PropertyChangeSupport(tmpObject);
            PropertyChangeListener[] propertyChangeListeners = this.boundList.getPropertyChangeListeners();
            int i = 0;
            while (i < propertyChangeListeners.length) {
                tmpObject.boundList.addPropertyChangeListener(propertyChangeListeners[i]);
                ++i;
            }
            tmpObject.vetoList = new VetoableChangeSupport(tmpObject);
            VetoableChangeListener[] vetoableChangeListeners = this.vetoList.getVetoableChangeListeners();
            int i2 = 0;
            while (i2 < vetoableChangeListeners.length) {
                tmpObject.vetoList.addVetoableChangeListener(vetoableChangeListeners[i2]);
                ++i2;
            }
            this.clone = tmpObject;
            tmpObject.clone = null;
            Iterator iterator = this.clonedBoundEventList.iterator();
            while (iterator.hasNext()) {
                this.propertyChange((PropertyChangeEvent)iterator.next());
            }
            iterator = this.clonedVetoEventList.iterator();
            while (iterator.hasNext()) {
                try {
                    this.vetoableChange((PropertyChangeEvent)iterator.next());
                }
                catch (PropertyVetoException pve) {
                    pve.printStackTrace(OutputManager.getCurrentOutputManager().getErrorOutput());
                }
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int tab) {
        StringBuffer codeEq = new StringBuffer();
        Misc.addTabs(tab, codeEq);
        if (this.getComment() != null) {
            codeEq.append("/* ");
            codeEq.append(this.getComment());
            codeEq.append(" */\n");
            Misc.addTabs(tab, codeEq);
        }
        codeEq.append(Modifier.toString(this.getVisibility()));
        return codeEq.toString();
    }

    public abstract void vetoableChange(PropertyChangeEvent var1) throws PropertyVetoException;

    public abstract void propertyChange(PropertyChangeEvent var1);
}

