/*
 * Decompiled with CFR 0.152.
 */
package padl.kernel.impl.v1;

import com.ibm.toad.cfparse.MethodInfo;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import padl.kernel.IConstituent;
import padl.kernel.IConstructor;
import padl.kernel.IElement;
import padl.kernel.IElementMarker;
import padl.kernel.IMethod;
import padl.kernel.IMethodInvocation;
import padl.kernel.IParameter;
import padl.kernel.IVisitor;
import padl.kernel.ModelDeclarationException;
import padl.kernel.impl.v1.Attribute;
import padl.kernel.impl.v1.Constituent;
import padl.kernel.impl.v1.Parameter;
import padl.util.Misc;
import util.io.OutputManager;

class Constructor
extends Attribute
implements IElementMarker,
PropertyChangeListener,
IConstructor {
    private List listOfParameters = new ArrayList(0);

    public Constructor(IMethod attachedMethod) throws ModelDeclarationException {
        this(attachedMethod.getActorID(), attachedMethod);
    }

    public Constructor(MethodInfo aMethod) {
        this(aMethod.getName(), aMethod);
    }

    public Constructor(String anActorID) {
        super(anActorID);
    }

    public Constructor(String anActorID, IMethod attachedMethod) throws ModelDeclarationException {
        super(anActorID);
        if (attachedMethod != null) {
            this.attachTo(attachedMethod);
        }
    }

    public Constructor(String anActorID, MethodInfo aMethod) {
        super(anActorID);
        try {
            this.setVisibility(aMethod.getAccess());
        }
        catch (ModelDeclarationException modelDeclarationException) {
            // empty catch block
        }
        String[] detectedParameters = aMethod.getParams();
        int x = 0;
        while (x < detectedParameters.length) {
            this.addActor(new Parameter(Misc.stripAndCapQualifiedName(detectedParameters[x++])));
        }
    }

    public void accept(IVisitor visitor) {
        super.accept(visitor);
        Iterator e = this.listOfActors().iterator();
        while (e.hasNext()) {
            ((Parameter)e.next()).accept(visitor);
        }
    }

    public final void addActor(IConstituent aConstituent) throws ModelDeclarationException {
        if (aConstituent instanceof IParameter) {
            this.addActor((IParameter)aConstituent);
        } else if (aConstituent instanceof IMethodInvocation) {
            this.addActor((IMethodInvocation)aConstituent);
        } else {
            throw new ModelDeclarationException("Only a parameter or a method invocation can be added to a method.");
        }
    }

    public void addActor(IMethodInvocation aMethodInvocation) {
        try {
            ArrayList oldListOfElements = new ArrayList(this.listOfActors());
            this.fireVetoableChange("AddMethodInvocation", oldListOfElements, aMethodInvocation);
            this.listOfActors().add(aMethodInvocation);
            this.firePropertyChange("AddMethodInvocation", oldListOfElements, aMethodInvocation);
        }
        catch (PropertyVetoException e) {
            e.printStackTrace(OutputManager.getCurrentOutputManager().getErrorOutput());
        }
    }

    public void addActor(IParameter aParameter) {
        try {
            ArrayList oldListOfElements = new ArrayList(this.listOfActors());
            this.fireVetoableChange("AddParameter", oldListOfElements, aParameter);
            this.listOfActors().add(aParameter);
            this.firePropertyChange("AddParameter", oldListOfElements, aParameter);
        }
        catch (PropertyVetoException e) {
            e.printStackTrace(OutputManager.getCurrentOutputManager().getErrorOutput());
        }
    }

    public boolean doesContainActorWithID(String anActorID) {
        return this.listOfActors().contains(anActorID);
    }

    public boolean doesContainActorWithName(String anActorID) {
        return this.listOfActors().contains(anActorID);
    }

    public IConstituent getActorFromID(String anID) {
        Iterator iterator = this.listOfParameters.iterator();
        while (iterator.hasNext()) {
            Constituent currentElement = (Constituent)iterator.next();
            if (!currentElement.getActorID().equals(anID)) continue;
            return currentElement;
        }
        return null;
    }

    public IConstituent getActorFromName(String aName) {
        Iterator iterator = this.listOfParameters.iterator();
        while (iterator.hasNext()) {
            Constituent currentElement = (Constituent)iterator.next();
            if (!currentElement.getName().equals(aName)) continue;
            return currentElement;
        }
        return null;
    }

    public String getCallDeclaration() {
        StringBuffer codeEq = new StringBuffer();
        codeEq.append(this.getName());
        codeEq.append("(");
        Iterator iterator = this.listOfActors().iterator();
        while (iterator.hasNext()) {
            codeEq.append(((Parameter)iterator.next()).getName());
            if (!iterator.hasNext()) continue;
            codeEq.append(",");
        }
        codeEq.append(")");
        return codeEq.toString();
    }

    public List listOfActors() {
        if (this.getAttachedElement() == null) {
            return this.listOfParameters;
        }
        return ((Constructor)this.getAttachedElement()).listOfActors();
    }

    public void propertyChange(PropertyChangeEvent e) {
        super.propertyChange(e);
        if (e.getSource() == this.getAttachedElement() && (e.getPropertyName().equals("ReturnType") || e.getPropertyName().equals("AddParameter") || e.getPropertyName().equals("RemoveParameter"))) {
            this.firePropertyChange(e.getPropertyName(), e.getOldValue(), e.getNewValue());
        }
    }

    private void removeActor(Parameter aParameter) {
        try {
            ArrayList oldListOfParameters = new ArrayList(this.listOfActors());
            this.fireVetoableChange("RemoveParameter", oldListOfParameters, aParameter);
            this.listOfActors().remove(aParameter);
            this.firePropertyChange("RemoveParameter", oldListOfParameters, aParameter);
        }
        catch (PropertyVetoException e) {
            e.printStackTrace(OutputManager.getCurrentOutputManager().getErrorOutput());
        }
    }

    public void removeActor(String anID) {
        this.removeActor((Parameter)this.getActorFromID(anID));
    }

    public void removeAllActors() {
        Iterator iterator = this.listOfActors().iterator();
        while (iterator.hasNext()) {
            this.removeActor((Parameter)iterator.next());
        }
    }

    public void startCloneSession() {
        super.startCloneSession();
        ((Constructor)this.getClone()).listOfParameters = new ArrayList(this.listOfActors());
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int tab) {
        StringBuffer codeEq = new StringBuffer();
        codeEq.append(super.toString(tab));
        codeEq.append(' ');
        codeEq.append(this.getName());
        codeEq.append('(');
        Iterator iterator = this.listOfActors().iterator();
        while (iterator.hasNext()) {
            codeEq.append(iterator.next().toString());
            if (!iterator.hasNext()) continue;
            codeEq.append(", ");
        }
        codeEq.append(')');
        if (this.isAbstract()) {
            return String.valueOf(codeEq.toString()) + ';';
        }
        codeEq.append(" {\n");
        String[] codeLines = this.getCodeLines();
        if (codeLines != null) {
            int i = 0;
            while (i < codeLines.length) {
                Misc.addTabs(tab + 1, codeEq);
                codeEq.append(codeLines[i]);
                codeEq.append('\n');
                ++i;
            }
        }
        Misc.addTabs(tab, codeEq);
        codeEq.append('}');
        return codeEq.toString();
    }

    public void vetoableChange(PropertyChangeEvent e) throws PropertyVetoException {
        super.vetoableChange(e);
        if (((IElement)e.getSource()).getAttachedElement() == this && (e.getPropertyName().equals("ReturnType") || e.getPropertyName().equals("AddParameter") || e.getPropertyName().equals("RemoveParameter"))) {
            throw new PropertyVetoException("Attached Element", e);
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof IConstructor)) {
            return false;
        }
        return this.getActorID().equals(((IConstructor)o).getActorID());
    }
}

