/*
 * Decompiled with CFR 0.152.
 */
package padl.kernel.impl.v1;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import padl.kernel.IConstituent;
import padl.kernel.IContainer;
import padl.kernel.IContainerAggregation;
import padl.kernel.IElementMarker;
import padl.kernel.IEntity;
import padl.kernel.ModelDeclarationException;
import padl.kernel.impl.v1.Association;
import padl.kernel.impl.v1.Constituent;
import padl.kernel.impl.v1.Entity;
import padl.kernel.impl.v1.Field;
import padl.kernel.impl.v1.Method;
import padl.kernel.impl.v1.Parameter;
import padl.util.Misc;
import util.io.OutputManager;

class ContainerAggregation
extends Association
implements IContainer,
IElementMarker,
PropertyChangeListener,
IContainerAggregation {
    private List associationElements;
    private final boolean isFromVoid;
    private Field originField;
    private Method originGetterMethod;
    private Method originSetterMethod;

    public ContainerAggregation(Association pAssociation) throws ModelDeclarationException {
        this(pAssociation.getActorID(), pAssociation.getTargetActor(), pAssociation.getCardinality());
    }

    public ContainerAggregation(String anActorID, IEntity aTargetEntity, int cardinality) throws ModelDeclarationException {
        super(anActorID, aTargetEntity, cardinality);
        this.isFromVoid = true;
        this.updateAssociation();
    }

    public void addActor(IConstituent aConstituent) throws ModelDeclarationException {
        throw new ModelDeclarationException("Elements only can be attached to a container aggregation at instantiation.");
    }

    public boolean doesContainActorWithID(String anID) {
        return this.associationElements.contains(this.getActorFromID(anID));
    }

    public boolean doesContainActorWithName(String aName) {
        return this.associationElements.contains(this.getActorFromName(aName));
    }

    public void endCloneSession() {
        ContainerAggregation clonedAggregation = (ContainerAggregation)this.getClone();
        if (this.isFromVoid) {
            clonedAggregation.updateAssociation();
        } else {
            clonedAggregation.originField = (Field)this.originField.getClone();
            clonedAggregation.originGetterMethod = (Method)this.originGetterMethod.getClone();
            clonedAggregation.originSetterMethod = (Method)this.originSetterMethod.getClone();
            clonedAggregation.associationElements.clear();
            if (!clonedAggregation.isAbstract()) {
                clonedAggregation.associationElements.add(this.originField);
            }
            clonedAggregation.associationElements.add(this.originGetterMethod);
            clonedAggregation.associationElements.add(this.originSetterMethod);
        }
    }

    public IConstituent getActorFromID(String anID) {
        Iterator iterator = this.associationElements.iterator();
        while (iterator.hasNext()) {
            Constituent currentElement = (Constituent)iterator.next();
            if (!currentElement.getActorID().equals(anID)) continue;
            return currentElement;
        }
        return null;
    }

    public IConstituent getActorFromName(String aName) {
        Iterator iterator = this.associationElements.iterator();
        while (iterator.hasNext()) {
            Constituent currentElement = (Constituent)iterator.next();
            if (!currentElement.getName().equals(aName)) continue;
            return currentElement;
        }
        return null;
    }

    public String getFieldType() {
        return this.originField.getType();
    }

    public List listOfActors() {
        return this.associationElements;
    }

    public void propertyChange(PropertyChangeEvent e) {
        super.propertyChange(e);
        if (e.getSource() == this.getTargetActor()) {
            this.updateAssociation();
        }
    }

    public void removeActor(String anID) {
        this.associationElements.remove(this.getActorFromID(anID));
    }

    public void removeAllActors() {
        this.associationElements.clear();
    }

    public void setCardinality(int cardinality) throws ModelDeclarationException {
        super.setCardinality(cardinality);
        if (this.isFromVoid) {
            this.updateAssociation();
        }
    }

    public void setName(String aName) {
        super.setName(aName);
        if (this.isFromVoid) {
            this.updateAssociation();
        }
    }

    public void setTargetActor(Entity aPEntity) {
        super.setTargetActor(aPEntity);
        if (aPEntity != null && this.isFromVoid) {
            this.updateAssociation();
        }
    }

    public void setVisibility(int visibility) throws ModelDeclarationException {
        super.setVisibility(visibility);
        this.updateAssociation();
    }

    public void startCloneSession() {
        super.startCloneSession();
        ContainerAggregation clone = (ContainerAggregation)this.getClone();
        clone.associationElements = new ArrayList(3);
        this.originField.startCloneSession();
        clone.originField = (Field)this.originField.getClone();
        this.originGetterMethod.startCloneSession();
        clone.originGetterMethod = (Method)this.originGetterMethod.getClone();
        this.originSetterMethod.startCloneSession();
        clone.originSetterMethod = (Method)this.originSetterMethod.getClone();
    }

    public String toString(int tab) {
        StringBuffer codeEq = new StringBuffer();
        codeEq.append(super.toString(tab));
        Misc.addTabs(tab, codeEq);
        Iterator iterator = this.associationElements.iterator();
        while (iterator.hasNext()) {
            codeEq.append(((Constituent)iterator.next()).toString(tab));
            if (!iterator.hasNext()) continue;
            codeEq.append('\n');
        }
        return codeEq.toString();
    }

    private void updateAssociation() {
        try {
            this.originField = new Field("~ID1");
            this.originField.setName(this.getName());
            this.originField.setVisibility(this.getVisibility());
            this.originField.setPrivate(true);
            this.originField.resetCodeLines();
            this.originGetterMethod = new Method("~ID2");
            this.originGetterMethod.setVisibility(this.getVisibility());
            this.originGetterMethod.resetCodeLines();
            this.originSetterMethod = new Method("~ID3");
            this.originSetterMethod.setVisibility(this.getVisibility());
            this.originSetterMethod.resetCodeLines();
            Parameter parameter = new Parameter(0, Misc.stripAndCapQualifiedName(this.getTargetActor().getName()), this.getTargetActor().getName());
            if (this.getCardinality() > 1) {
                this.originField.setType("java.util.List");
                this.originGetterMethod.setName("remove" + this.getTargetActor().getName());
                this.originGetterMethod.addActor(parameter);
                this.originGetterMethod.setReturnType("void");
                this.originSetterMethod.setName("add" + this.getTargetActor().getName());
                this.originSetterMethod.addActor(parameter);
                this.originSetterMethod.setReturnType("void");
                if (!this.isAbstract()) {
                    this.originField.setCodeLines("new java.util.ArrayList()");
                    this.originGetterMethod.setCodeLines(String.valueOf(this.getName()) + ".add(" + parameter.getName() + ");");
                    this.originGetterMethod.setReturnType("void");
                    this.originSetterMethod.setCodeLines(String.valueOf(this.getName()) + ".remove(" + parameter.getName() + ");");
                }
            } else {
                this.originField.setType(this.getTargetActor().getName());
                this.originGetterMethod.setName("get" + this.getTargetActor().getName());
                this.originGetterMethod.setReturnType(this.getTargetActor().getName());
                this.originSetterMethod.setName("set" + this.getTargetActor().getName());
                this.originSetterMethod.setReturnType("void");
                this.originSetterMethod.addActor(parameter);
                if (!this.isAbstract()) {
                    this.originGetterMethod.setCodeLines("return " + this.getName() + ";");
                    this.originSetterMethod.setCodeLines(String.valueOf(this.getName()) + " = " + this.getTargetActor().getName() + ';');
                }
            }
            if (this.associationElements == null) {
                this.associationElements = new ArrayList(3);
            } else {
                this.associationElements.clear();
            }
            if (!this.isAbstract()) {
                this.associationElements.add(this.originField);
            }
            this.associationElements.add(this.originGetterMethod);
            this.associationElements.add(this.originSetterMethod);
        }
        catch (ModelDeclarationException pde) {
            pde.printStackTrace(OutputManager.getCurrentOutputManager().getErrorOutput());
        }
    }
}

