/*
 * Decompiled with CFR 0.152.
 */
package padl.kernel.impl.v1;

import com.ibm.toad.cfparse.utils.Access;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import padl.kernel.IAssociation;
import padl.kernel.IDelegatingMethod;
import padl.kernel.IElementMarker;
import padl.kernel.IMethod;
import padl.kernel.ModelDeclarationException;
import padl.kernel.impl.v1.Association;
import padl.kernel.impl.v1.Method;
import padl.util.Misc;
import util.io.OutputManager;

class DelegatingMethod
extends Method
implements IElementMarker,
PropertyChangeListener,
IDelegatingMethod {
    private IAssociation targetAssoc;
    private IMethod targetMethod;
    private Association temporaryTargetAssociation;
    private Method temporaryTargetMethod;

    public DelegatingMethod(String anActorID, IAssociation targetAssoc) throws ModelDeclarationException {
        this(anActorID, targetAssoc, null);
    }

    public DelegatingMethod(String anActorID, IAssociation targetAssoc, IMethod targetMethod) throws ModelDeclarationException {
        super(anActorID, targetMethod);
        this.setTargetAssoc(targetAssoc);
        if (targetMethod == null) {
            this.setTargetMethod(this);
        } else {
            this.setTargetMethod(targetMethod);
        }
        ((Association)this.getTargetAssoc()).addPropertyChangeListener(this);
        ((Method)this.getTargetMethod()).addPropertyChangeListener(this);
    }

    public void endCloneSession() {
        super.endCloneSession();
        this.temporaryTargetAssociation = null;
        this.temporaryTargetMethod = null;
    }

    public IAssociation getTargetAssoc() {
        return this.targetAssoc;
    }

    public IMethod getTargetMethod() {
        return this.targetMethod;
    }

    public void setTargetAssoc(IAssociation anAssociation) {
        IAssociation oldTargetAssoc = this.getTargetAssoc();
        try {
            this.fireVetoableChange("TargetAssoc", oldTargetAssoc, anAssociation);
            if (oldTargetAssoc != null) {
                this.removePropertyChangeListener((Association)oldTargetAssoc);
            }
            this.targetAssoc = anAssociation;
            this.addPropertyChangeListener((Association)this.targetAssoc);
            this.firePropertyChange("TargetAssoc", oldTargetAssoc, anAssociation);
        }
        catch (PropertyVetoException e) {
            e.printStackTrace(OutputManager.getCurrentOutputManager().getErrorOutput());
        }
    }

    public void setTargetMethod(IMethod aMethod) {
        IMethod oldTargetMethod = this.getTargetMethod();
        try {
            this.fireVetoableChange("TargetMethod", oldTargetMethod, aMethod);
            if (oldTargetMethod != null) {
                this.removePropertyChangeListener((Method)oldTargetMethod);
            }
            this.targetMethod = aMethod;
            this.addPropertyChangeListener((Association)this.targetAssoc);
            this.firePropertyChange("TargetMethod", oldTargetMethod, aMethod);
        }
        catch (PropertyVetoException e) {
            e.printStackTrace(OutputManager.getCurrentOutputManager().getErrorOutput());
        }
    }

    public void setVisibility(int visibility) throws ModelDeclarationException {
        if (Access.isAbstract(visibility)) {
            throw new ModelDeclarationException(this.getClass() + " can't be abstract.");
        }
        super.setVisibility(visibility);
    }

    public void startCloneSession() {
        super.startCloneSession();
        DelegatingMethod clone = (DelegatingMethod)this.getClone();
        if (this.temporaryTargetAssociation != null) {
            clone.targetAssoc = this.temporaryTargetAssociation;
        }
        if (this.temporaryTargetMethod != null) {
            clone.targetMethod = this.temporaryTargetMethod;
        }
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int tab) {
        try {
            if (this.getTargetAssoc().getCardinality() > 1) {
                this.setCodeLines("for (Enumeration enum = " + this.targetAssoc.getName() + ".elements(); enum.hasMoreElements(); ((" + this.getTargetAssoc().getTargetActor().getName() + ") enum.nextElement())." + this.getTargetMethod().getCallDeclaration() + ");");
            } else {
                this.setCodeLines(String.valueOf(this.getTargetAssoc().getName()) + "." + this.getTargetMethod().getCallDeclaration() + ";");
            }
        }
        catch (ModelDeclarationException modelDeclarationException) {
            // empty catch block
        }
        StringBuffer codeEq = new StringBuffer();
        Misc.addTabs(tab, codeEq);
        codeEq.append("// Method linked to: ");
        codeEq.append(this.getTargetAssoc().getName());
        codeEq.append('\n');
        codeEq.append(super.toString(tab));
        return codeEq.toString();
    }
}

