/*
 * Decompiled with CFR 0.152.
 */
package padl.kernel.impl.v1;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import padl.kernel.IElement;
import padl.kernel.ModelDeclarationException;
import padl.kernel.impl.v1.Constituent;
import util.io.OutputManager;

abstract class Element
extends Constituent
implements IElement {
    private IElement attachedElement;

    public Element(String actorID) {
        super(actorID);
    }

    public void attachTo(IElement anElement) throws ModelDeclarationException {
        IElement oldAttachedElement = this.getAttachedElement();
        if (anElement == this) {
            throw new ModelDeclarationException("A Element cannot be attached to itself.");
        }
        if (!anElement.getClass().isInstance(this)) {
            throw new ModelDeclarationException(this.getClass() + " cannot be attached to " + anElement.getClass());
        }
        try {
            this.fireVetoableChange("AttachTo", oldAttachedElement, anElement);
            this.detach();
            this.attachedElement = anElement;
            this.addVetoableChangeListener((Element)anElement);
            ((Element)anElement).addPropertyChangeListener(this);
            this.firePropertyChange("AttachTo", oldAttachedElement, anElement);
        }
        catch (PropertyVetoException e) {
            e.printStackTrace(OutputManager.getCurrentOutputManager().getErrorOutput());
        }
    }

    public void detach() {
        IElement oldAttachedElement = this.getAttachedElement();
        if (oldAttachedElement == null) {
            return;
        }
        try {
            this.fireVetoableChange("Detach", oldAttachedElement, null);
            ((Element)this.getAttachedElement()).removePropertyChangeListener(this);
            this.removeVetoableChangeListener((Element)this.getAttachedElement());
            this.attachedElement = null;
            this.firePropertyChange("Detach", oldAttachedElement, null);
        }
        catch (PropertyVetoException e) {
            e.printStackTrace(OutputManager.getCurrentOutputManager().getErrorOutput());
        }
    }

    public IElement getAttachedElement() {
        return this.attachedElement;
    }

    public String getName() {
        if (this.getAttachedElement() == null) {
            return super.getName();
        }
        return this.getAttachedElement().getName();
    }

    public void performCloneSession() {
        if (this.getAttachedElement() != null) {
            ((Element)this.getClone()).attachedElement = (Element)this.getAttachedElement().getClone();
        }
        super.performCloneSession();
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (e.getSource() == this.getAttachedElement() && e.getPropertyName().equals("Name")) {
            this.firePropertyChange("Name", e.getOldValue(), e.getNewValue());
        }
    }

    public void startCloneSession() {
        super.startCloneSession();
        ((Element)this.getClone()).attachedElement = null;
    }

    public void vetoableChange(PropertyChangeEvent e) throws PropertyVetoException {
        if (((IElement)e.getSource()).getAttachedElement() == this && e.getPropertyName().equals("Name")) {
            throw new PropertyVetoException("Attached Element", e);
        }
    }
}

