/*
 * Decompiled with CFR 0.152.
 */
package padl.kernel.impl.v1;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import padl.event.ElementEvent;
import padl.kernel.IConstituent;
import padl.kernel.IContainer;
import padl.kernel.IElement;
import padl.kernel.IEntity;
import padl.kernel.IVisitor;
import padl.kernel.ListenerManager;
import padl.kernel.ModelDeclarationException;
import padl.kernel.impl.v1.Constituent;
import padl.kernel.impl.v1.Element;
import padl.util.Misc;
import util.io.OutputManager;

abstract class Entity
extends Constituent
implements IContainer,
PropertyChangeListener,
IEntity {
    private List listOfElements = new ArrayList();
    private List listOfInheritedEntities = new ArrayList();
    private List listOfInheritingEntities = new ArrayList();
    private String purpose;

    public Entity(String actorID) {
        super(actorID);
    }

    public void accept(IVisitor visitor) {
        this.accept(visitor, "open");
        Iterator iterator = this.listOfElements.iterator();
        while (iterator.hasNext()) {
            ((IConstituent)iterator.next()).accept(visitor);
        }
        this.accept(visitor, "close");
    }

    public void addActor(IConstituent constituent) throws ModelDeclarationException {
        if (!(constituent instanceof IElement)) {
            throw new ModelDeclarationException("Only an element can be added to an entity.");
        }
        this.addActor((IElement)constituent);
    }

    public void addActor(IElement anElement) throws ModelDeclarationException {
        if (this.listOfActors().contains(anElement)) {
            throw new ModelDeclarationException("Duplicate Actor ID: " + anElement.getActorID());
        }
        if (this.doesContainActorWithName(anElement.getName())) {
            throw new ModelDeclarationException("Duplicate Element Name: " + anElement.getName());
        }
        try {
            ArrayList oldListOfElements = new ArrayList(this.listOfElements);
            this.fireVetoableChange("AddPElement", oldListOfElements, anElement);
            this.listOfElements.add(anElement);
            ((Element)anElement).addPropertyChangeListener(this);
            ((Element)anElement).addVetoableChangeListener(this);
            this.firePropertyChange("AddPElement", oldListOfElements, anElement);
        }
        catch (PropertyVetoException e) {
            e.printStackTrace(OutputManager.getCurrentOutputManager().getErrorOutput());
        }
        ListenerManager.getCurrentListenerManager().fireModelChange("elementAdded", new ElementEvent(this, anElement));
    }

    public void addInheritedActor(IEntity anEntity) throws ModelDeclarationException {
        if (anEntity == this) {
            throw new ModelDeclarationException("An Entity can't inherit from itself");
        }
        if (this.listOfInheritedEntities.contains(anEntity)) {
            throw new ModelDeclarationException(String.valueOf(anEntity.getActorID()) + " is already inherited from " + this.getActorID());
        }
        try {
            ArrayList oldListInherits = new ArrayList(this.listOfInheritedEntities);
            this.fireVetoableChange("AddInherits", oldListInherits, anEntity);
            this.listOfInheritedEntities.add(anEntity);
            this.firePropertyChange("AddInherits", oldListInherits, anEntity);
        }
        catch (PropertyVetoException e) {
            e.printStackTrace(OutputManager.getCurrentOutputManager().getErrorOutput());
        }
    }

    public void addInheritingActor(IEntity anEntity) throws ModelDeclarationException {
        if (anEntity == this) {
            throw new ModelDeclarationException("An Entity can't inherit from itself");
        }
        if (this.listOfInheritedEntities.contains(anEntity)) {
            throw new ModelDeclarationException(String.valueOf(anEntity.getActorID()) + " is already inheriting from " + this.getActorID());
        }
        this.listOfInheritingEntities.add(anEntity);
    }

    public boolean doesContainActorWithID(String anID) {
        Iterator iterator = this.listOfElements.iterator();
        while (iterator.hasNext()) {
            if (!((IElement)iterator.next()).getActorID().equals(anID)) continue;
            return true;
        }
        return false;
    }

    public boolean doesContainActorWithName(String aName) {
        Iterator iterator = this.listOfElements.iterator();
        while (iterator.hasNext()) {
            if (!((IElement)iterator.next()).getName().equals(aName)) continue;
            return true;
        }
        return false;
    }

    public void endCloneSession() {
        super.endCloneSession();
        Iterator iterator = this.listOfElements.iterator();
        while (iterator.hasNext()) {
            ((IConstituent)iterator.next()).endCloneSession();
        }
    }

    public IConstituent getActorFromID(String anID) {
        Iterator iterator = this.listOfElements.iterator();
        while (iterator.hasNext()) {
            Constituent currentElement = (Constituent)iterator.next();
            if (!currentElement.getActorID().equals(anID)) continue;
            return currentElement;
        }
        return null;
    }

    public IConstituent getActorFromName(String aName) {
        Iterator iterator = this.listOfElements.iterator();
        while (iterator.hasNext()) {
            Constituent currentElement = (Constituent)iterator.next();
            if (!currentElement.getName().equals(aName)) continue;
            return currentElement;
        }
        return null;
    }

    public IEntity getInheritedActor(String anEntityName) {
        Iterator iterator = this.listOfInheritedEntities.iterator();
        while (iterator.hasNext()) {
            Entity inheritedEntity = (Entity)iterator.next();
            if (!inheritedEntity.getName().equals(anEntityName)) continue;
            return inheritedEntity;
        }
        return null;
    }

    public String getPurpose() {
        return this.purpose;
    }

    public boolean isAboveInHierarchy(IEntity pEntity) {
        if (this.equals(pEntity)) {
            return true;
        }
        Iterator iterator = pEntity.listOfInheritedActors().iterator();
        if (iterator.hasNext()) {
            IEntity s = (IEntity)iterator.next();
            if (this.equals(s)) {
                return true;
            }
            return this.isAboveInHierarchy(s);
        }
        return false;
    }

    public List listOfActors() {
        return this.listOfElements;
    }

    public List listOfInheritedActors() {
        return this.listOfInheritedEntities;
    }

    public List listOfInheritingActors() {
        return this.listOfInheritingEntities;
    }

    public void performCloneSession() {
        IElement element;
        super.performCloneSession();
        Entity clonedEntity = (Entity)this.getClone();
        clonedEntity.listOfInheritedEntities = new ArrayList();
        Iterator iterator = this.listOfInheritedEntities.iterator();
        while (iterator.hasNext()) {
            Entity currentPEntity = (Entity)iterator.next();
            if (currentPEntity.getClone() == null) continue;
            clonedEntity.listOfInheritedEntities.add(currentPEntity.getClone());
        }
        clonedEntity.listOfElements = new ArrayList();
        iterator = this.listOfActors().iterator();
        while (iterator.hasNext()) {
            element = (IElement)iterator.next();
            element.startCloneSession();
        }
        iterator = this.listOfElements.iterator();
        while (iterator.hasNext()) {
            element = (Element)iterator.next();
            ((Element)element).performCloneSession();
            clonedEntity.listOfElements.add(((Constituent)((Object)element)).getClone());
        }
    }

    public void propertyChange(PropertyChangeEvent e) {
    }

    private void removeActor(IElement anElement) {
        try {
            ArrayList oldListOfElements = new ArrayList(this.listOfElements);
            this.fireVetoableChange("RemovePElement", oldListOfElements, anElement);
            this.listOfElements.remove(anElement);
            ((Element)anElement).removePropertyChangeListener(this);
            ((Element)anElement).removeVetoableChangeListener(this);
            this.firePropertyChange("RemovePElement", oldListOfElements, anElement);
        }
        catch (PropertyVetoException e) {
            e.printStackTrace(OutputManager.getCurrentOutputManager().getErrorOutput());
        }
        ListenerManager.getCurrentListenerManager().fireModelChange("elementRemoved", new ElementEvent(this, anElement));
    }

    public void removeActor(String anID) {
        this.removeActor((IElement)this.getActorFromID(anID));
    }

    public void removeAllActors() {
        Iterator iterator = this.listOfElements.iterator();
        while (iterator.hasNext()) {
            this.removeActor((IElement)iterator.next());
        }
    }

    public void removeInheritedActor(IEntity anEntity) {
        try {
            ArrayList oldListOfInheritedEntities = new ArrayList(this.listOfInheritedEntities);
            this.fireVetoableChange("RemoveInherits", oldListOfInheritedEntities, anEntity);
            this.listOfInheritedEntities.remove(anEntity);
            this.firePropertyChange("RemoveInherits", oldListOfInheritedEntities, anEntity);
        }
        catch (PropertyVetoException e) {
            e.printStackTrace(OutputManager.getCurrentOutputManager().getErrorOutput());
        }
    }

    public void removeInheritingActor(IEntity anEntity) {
        this.listOfInheritingEntities.remove(anEntity);
    }

    public void setPurpose(String purpose) {
        this.purpose = purpose;
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int tab) {
        StringBuffer codeEq = new StringBuffer();
        if (this.getPurpose() != null) {
            Misc.addTabs(tab, codeEq);
            codeEq.append("/* ");
            codeEq.append(this.getActorID());
            codeEq.append(" : Purpose\n");
            Misc.addTabs(tab, codeEq);
            codeEq.append(this.getPurpose());
            Misc.addTabs(tab, codeEq);
            codeEq.append("\n*/\n");
        }
        codeEq.append(super.toString(tab));
        return codeEq.toString();
    }

    public void vetoableChange(PropertyChangeEvent e) throws PropertyVetoException {
        if (e.getPropertyName().equals("Name") && this.doesContainActorWithName((String)e.getNewValue())) {
            throw new PropertyVetoException("Duplicate name: " + e.getNewValue(), e);
        }
    }
}

