/*
 * Decompiled with CFR 0.152.
 */
package padl.kernel.impl.v1;

import padl.kernel.IAggregation;
import padl.kernel.IAssociation;
import padl.kernel.IClass;
import padl.kernel.IComposition;
import padl.kernel.IConstructor;
import padl.kernel.IContainerAggregation;
import padl.kernel.IContainerComposition;
import padl.kernel.ICreation;
import padl.kernel.IDelegatingMethod;
import padl.kernel.IEntity;
import padl.kernel.IFactory;
import padl.kernel.IField;
import padl.kernel.IGhost;
import padl.kernel.IIdiomLevelModel;
import padl.kernel.IInterface;
import padl.kernel.IMethod;
import padl.kernel.IParameter;
import padl.kernel.IUseRelationship;
import padl.kernel.ModelDeclarationException;
import padl.kernel.impl.v1.Aggregation;
import padl.kernel.impl.v1.Association;
import padl.kernel.impl.v1.Class;
import padl.kernel.impl.v1.Composition;
import padl.kernel.impl.v1.Constructor;
import padl.kernel.impl.v1.ContainerAggregation;
import padl.kernel.impl.v1.ContainerComposition;
import padl.kernel.impl.v1.Creation;
import padl.kernel.impl.v1.DelegatingMethod;
import padl.kernel.impl.v1.Field;
import padl.kernel.impl.v1.Ghost;
import padl.kernel.impl.v1.IdiomLevelModel;
import padl.kernel.impl.v1.Interface;
import padl.kernel.impl.v1.Method;
import padl.kernel.impl.v1.Parameter;
import padl.kernel.impl.v1.UseRelationship;
import padl.util.Misc;

public class Factory
implements IFactory {
    private static Factory UNIQUE_INSTANCE;

    public static Factory getUniqueInstance() {
        if (UNIQUE_INSTANCE == null) {
            UNIQUE_INSTANCE = new Factory();
        }
        return UNIQUE_INSTANCE;
    }

    private Factory() {
    }

    public IAggregation createAggregationRelationship(String aName, IEntity aTargetEntity, int aCardinality) throws ModelDeclarationException {
        return new Aggregation(aName, aTargetEntity, aCardinality);
    }

    public IAssociation createAssociationRelationship(String anActorID, IEntity aTargetEntity, int aCardinality) throws ModelDeclarationException {
        return new Association(anActorID, aTargetEntity, aCardinality);
    }

    public IClass createClass(String aName) throws ModelDeclarationException {
        return new Class(aName);
    }

    public IClass createClass(String aName, IEntity aSuperEntity) throws ModelDeclarationException {
        return new Class(aName, aSuperEntity);
    }

    public IComposition createCompositionRelationship(IAssociation anAssociation) throws ModelDeclarationException {
        return new Composition(anAssociation);
    }

    public IComposition createCompositionRelationship(String anActorID, IEntity aTargetEntity, int aCardinality) throws ModelDeclarationException {
        return new Composition(anActorID, aTargetEntity, aCardinality);
    }

    public IConstructor createConstructor(String aName) throws ModelDeclarationException {
        return new Constructor(aName);
    }

    public IContainerAggregation createContainerAggregationRelationship(String anActorID, IEntity aTargetEntity, int aCardinality) throws ModelDeclarationException {
        return new ContainerAggregation(anActorID, aTargetEntity, aCardinality);
    }

    public IContainerComposition createContainerCompositionRelationship(IAssociation anAssociation) throws ModelDeclarationException {
        return new ContainerComposition(anAssociation);
    }

    public ICreation createCreationRelationship(String anActorID, IEntity aTargetEntity, int aCardinality) throws ModelDeclarationException {
        return new Creation(anActorID, aTargetEntity, aCardinality);
    }

    public IDelegatingMethod createDelegatingMethod(String aName, IAssociation aTargetAssociation) throws ModelDeclarationException {
        return new DelegatingMethod(aName, aTargetAssociation);
    }

    public IDelegatingMethod createDelegatingMethod(String aName, IAssociation aTargetAssociation, IMethod aSupportMethod) throws ModelDeclarationException {
        return new DelegatingMethod(aName, aTargetAssociation, aSupportMethod);
    }

    public IField createField(String aName, String aType) throws ModelDeclarationException {
        return new Field(aName, aType);
    }

    public IGhost createGhost(String aName) throws ModelDeclarationException {
        int bracketIndex = aName.indexOf(91);
        if (bracketIndex > -1) {
            aName = aName.substring(0, bracketIndex);
        }
        if (Misc.isPrimtiveType(aName)) {
            throw new ModelDeclarationException("Cannot add array or primitive types.");
        }
        return new Ghost(aName);
    }

    public IIdiomLevelModel createIdiomLevelModel(String aName) {
        IdiomLevelModel idiomLevelModel = new IdiomLevelModel(aName);
        idiomLevelModel.setFactory(this);
        return idiomLevelModel;
    }

    public IInterface createInterface(String aName) throws ModelDeclarationException {
        return new Interface(aName);
    }

    public IMethod createMethod(String aName) throws ModelDeclarationException {
        return new Method(aName);
    }

    public IParameter createParameter(int aPosition, String aName, String aType) throws ModelDeclarationException {
        return new Parameter(aPosition, aName, aType);
    }

    public IUseRelationship createUseRelationship(String anActorID, IEntity aTargetEntity, int aCardinality) throws ModelDeclarationException {
        return new UseRelationship(anActorID, aTargetEntity, aCardinality);
    }
}

