/*
 * Decompiled with CFR 0.152.
 */
package padl.kernel.impl.v1;

import java.beans.PropertyVetoException;
import padl.kernel.IElementMarker;
import padl.kernel.IField;
import padl.kernel.ModelDeclarationException;
import padl.kernel.impl.v1.Attribute;
import padl.util.Misc;
import util.io.OutputManager;

class Field
extends Attribute
implements IElementMarker,
IField {
    private String fieldType;

    public Field(String actorID) {
        this(actorID, null);
    }

    public Field(String actorID, String fieldType) {
        super(actorID);
        this.setType(fieldType);
    }

    public String getType() {
        return this.fieldType;
    }

    public void setType(String fieldType) {
        String oldFieldType = this.getType();
        try {
            this.fireVetoableChange("FieldType", oldFieldType, fieldType);
            this.fieldType = fieldType;
            this.firePropertyChange("FieldType", oldFieldType, fieldType);
        }
        catch (PropertyVetoException e) {
            e.printStackTrace(OutputManager.getCurrentOutputManager().getErrorOutput());
        }
    }

    public void setVisibility(int visibility) throws ModelDeclarationException {
        super.setVisibility(visibility & 0xFFFFFBFF);
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int tab) {
        StringBuffer codeEq = new StringBuffer();
        codeEq.append(super.toString(tab));
        codeEq.append(' ');
        codeEq.append(this.getType());
        codeEq.append(' ');
        codeEq.append(this.getName());
        String[] codeLines = this.getCodeLines();
        if (codeLines != null) {
            codeEq.append(" = ");
            int i = 0;
            while (i < codeLines.length) {
                codeEq.append('\n');
                Misc.addTabs(tab + 1, codeEq);
                codeEq.append(codeLines[i]);
                ++i;
            }
        }
        codeEq.append(';');
        return codeEq.toString();
    }
}

