/*
 * Decompiled with CFR 0.152.
 */
package padl.kernel.impl.v1;

import com.ibm.toad.cfparse.MethodInfo;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import padl.kernel.IElementMarker;
import padl.kernel.IMethod;
import padl.kernel.ModelDeclarationException;
import padl.kernel.impl.v1.Constructor;
import padl.kernel.impl.v1.Parameter;
import padl.util.Misc;
import util.io.OutputManager;

class Method
extends Constructor
implements IElementMarker,
PropertyChangeListener,
IMethod {
    private List listOfParameters = new ArrayList(0);
    private String returnType = "void";

    public Method(IMethod attachedMethod) throws ModelDeclarationException {
        this(attachedMethod.getActorID(), attachedMethod);
    }

    public Method(MethodInfo aMethod) {
        this(aMethod.getName(), aMethod);
    }

    public Method(String anActorID) {
        super(anActorID);
    }

    public Method(String anActorID, IMethod attachedMethod) throws ModelDeclarationException {
        super(anActorID);
        if (attachedMethod != null) {
            this.attachTo(attachedMethod);
        }
    }

    public Method(String anActorID, MethodInfo aMethod) {
        super(anActorID);
        try {
            this.setVisibility(aMethod.getAccess());
        }
        catch (ModelDeclarationException modelDeclarationException) {
            // empty catch block
        }
        this.setReturnType(aMethod.getReturnType());
        String[] detectedParameters = aMethod.getParams();
        int x = 0;
        while (x < detectedParameters.length) {
            this.addActor(new Parameter(Misc.stripAndCapQualifiedName(detectedParameters[x++])));
        }
    }

    public String getReturnType() {
        if (this.getAttachedElement() == null) {
            return this.returnType;
        }
        return ((IMethod)this.getAttachedElement()).getReturnType();
    }

    public List listOfActors() {
        if (this.getAttachedElement() == null) {
            return this.listOfParameters;
        }
        return ((Method)this.getAttachedElement()).listOfActors();
    }

    public void setReturnType(String aType) {
        String oldReturnType = this.getReturnType();
        try {
            this.fireVetoableChange("returnType", oldReturnType, aType);
            this.returnType = aType;
            this.firePropertyChange("ReturnType", oldReturnType, aType);
        }
        catch (PropertyVetoException e) {
            e.printStackTrace(OutputManager.getCurrentOutputManager().getErrorOutput());
        }
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int tab) {
        StringBuffer codeEq = new StringBuffer();
        codeEq.append(super.toString(tab));
        codeEq.append(' ');
        codeEq.append(this.getReturnType());
        codeEq.append(' ');
        codeEq.append(this.getName());
        codeEq.append('(');
        Iterator iterator = this.listOfActors().iterator();
        while (iterator.hasNext()) {
            codeEq.append(iterator.next().toString());
            if (!iterator.hasNext()) continue;
            codeEq.append(", ");
        }
        codeEq.append(')');
        if (this.isAbstract()) {
            return String.valueOf(codeEq.toString()) + ';';
        }
        codeEq.append(" {\n");
        String[] codeLines = this.getCodeLines();
        if (codeLines != null) {
            int i = 0;
            while (i < codeLines.length) {
                Misc.addTabs(tab + 1, codeEq);
                codeEq.append(codeLines[i]);
                codeEq.append('\n');
                ++i;
            }
        }
        Misc.addTabs(tab, codeEq);
        codeEq.append('}');
        return codeEq.toString();
    }
}

