/*
 * Decompiled with CFR 0.152.
 */
package padl.kernel.impl.v1;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import padl.kernel.IConstructor;
import padl.kernel.IEntity;
import padl.kernel.IField;
import padl.kernel.IMethodInvocation;
import padl.kernel.impl.v1.Element;

public class MethodInvocation
extends Element
implements IMethodInvocation {
    private static int COUNTER = 0;
    private IConstructor calledMethod = null;
    private List callingFields = new ArrayList();
    private final int cardinality;
    private IEntity entityDeclaringField;
    private final IEntity originEntity;
    private final IEntity targetEntity;
    private final int type;

    public MethodInvocation(IEntity originEntity, IEntity targetEntity, IEntity entityDeclaringField) {
        super(String.valueOf(originEntity.getName()) + COUNTER++ + ":");
        this.originEntity = originEntity;
        this.targetEntity = targetEntity;
        this.entityDeclaringField = entityDeclaringField;
        this.type = -1;
        this.cardinality = 1;
    }

    public MethodInvocation(IEntity originEntity, int type, int cardinality, IEntity targetEntity) {
        super(String.valueOf(originEntity.getName()) + ":" + targetEntity.getName() + ":" + type + ":" + cardinality);
        this.originEntity = originEntity;
        this.type = type;
        this.cardinality = cardinality;
        this.targetEntity = targetEntity;
    }

    public void addCallingField(IField field) {
        this.callingFields.add(field);
    }

    public boolean equals(IMethodInvocation messageType) {
        return this.getTargetEntity() == messageType.getTargetEntity() && this.getType() == messageType.getType();
    }

    public boolean equals(Object object) {
        if (object instanceof IMethodInvocation) {
            return this.equals((IMethodInvocation)object);
        }
        return super.equals(object);
    }

    public IConstructor getCalledMethod() {
        return this.calledMethod;
    }

    public List getCallingFields() {
        return this.callingFields;
    }

    public int getCardinality() {
        return this.cardinality;
    }

    public IEntity getFieldDeclaringEntity() {
        return this.entityDeclaringField;
    }

    public IEntity getMethodDeclaringEntity() {
        return this.targetEntity;
    }

    public IField getFirstCallingField() {
        return (IField)this.callingFields.get(0);
    }

    public IEntity getOriginEntity() {
        return this.originEntity;
    }

    public IEntity getTargetEntity() {
        return this.targetEntity;
    }

    public int getType() {
        return this.type;
    }

    public void setCalledMethod(IConstructor calledMethod) {
        this.calledMethod = calledMethod;
    }

    public void setCallingField(List callingFields) {
        this.callingFields = callingFields;
    }

    public String toString() {
        StringBuffer buffer;
        String originEntityName = null;
        String targetEntityName = null;
        String fieldName = null;
        String methodName = null;
        String entityDeclaringFieldName = null;
        if (this.originEntity != null) {
            originEntityName = this.originEntity.getName();
        }
        if (this.targetEntity != null) {
            targetEntityName = this.targetEntity.getName();
        }
        if (this.callingFields != null || this.callingFields.size() > 0) {
            buffer = new StringBuffer();
            Iterator iter = this.callingFields.iterator();
            while (iter.hasNext()) {
                IField element = (IField)iter.next();
                buffer.append(element.getName());
                if (!iter.hasNext()) continue;
                buffer.append(".");
            }
            fieldName = buffer.toString();
        } else {
            fieldName = "null";
        }
        if (this.calledMethod != null) {
            methodName = this.calledMethod.getName();
        }
        if (this.entityDeclaringField != null) {
            entityDeclaringFieldName = this.entityDeclaringField.getName();
        }
        buffer = new StringBuffer();
        buffer.append("[");
        buffer.append(originEntityName);
        buffer.append(",");
        buffer.append(fieldName);
        buffer.append(",");
        buffer.append(methodName);
        buffer.append(",");
        buffer.append(targetEntityName);
        buffer.append(",");
        buffer.append(entityDeclaringFieldName);
        buffer.append("]");
        return buffer.toString();
    }
}

