/*
 * Decompiled with CFR 0.152.
 */
package padl.kernel.impl.v1;

import padl.kernel.IEntity;
import padl.kernel.IParameter;
import padl.kernel.IVisitor;
import padl.kernel.impl.v1.Element;

class Parameter
extends Element
implements IParameter {
    private String name;
    private String type;

    public Parameter(String aType) {
        super(aType);
        int index = aType.indexOf(91);
        if (index > -1) {
            this.setName(aType.substring(0, index));
        } else {
            this.setName(aType);
        }
        this.setType(aType);
    }

    public Parameter(String aName, IEntity anEntity) {
        super(aName);
        this.setName(aName);
        this.setType(anEntity.getName());
    }

    public Parameter(int aPosition, String aName, String aType) {
        super(String.valueOf(aName) + ':' + aPosition);
        this.setName(aName);
        this.setType(aType);
    }

    public void accept(IVisitor visitor) {
        visitor.visit(this);
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public void setName(String aName) {
        StringBuffer buffer = new StringBuffer(aName.length() + 1);
        buffer.append('a');
        buffer.append(Character.toUpperCase(aName.charAt(0)));
        buffer.append(aName.substring(1));
        this.name = buffer.toString();
    }

    public void setType(String aType) {
        this.type = aType;
    }

    public String toString() {
        return String.valueOf(this.getType()) + ' ' + this.getName();
    }
}

