/*
 * Decompiled with CFR 0.152.
 */
package padl.kernel.impl.v1;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import padl.event.EntityEvent;
import padl.kernel.IAbstractModel;
import padl.kernel.IConstituent;
import padl.kernel.IDetector;
import padl.kernel.IEntity;
import padl.kernel.IFactory;
import padl.kernel.IGenerator;
import padl.kernel.IPatternModel;
import padl.kernel.IWalker;
import padl.kernel.ListenerManager;
import padl.kernel.ModelDeclarationException;
import padl.kernel.impl.v1.Constituent;
import padl.kernel.impl.v1.Entity;
import padl.pattern.Detector;
import util.io.OutputManager;

public abstract class PatternModel
extends Constituent
implements IPatternModel {
    private IDetector defaultDetector;
    private IFactory factory;
    private List listOfEntities = new ArrayList();

    public PatternModel(String actorID) {
        super(actorID);
    }

    public final void addActor(IConstituent aConstituent) throws ModelDeclarationException {
        if (!(aConstituent instanceof IEntity)) {
            throw new ModelDeclarationException("Only an entity can be added to a design motif model.");
        }
        this.addActor((Entity)aConstituent);
    }

    public final void addActor(IEntity anEntity) throws ModelDeclarationException {
        if (this.listOfActors().contains(anEntity)) {
            throw new ModelDeclarationException("Duplicate ActorID: " + anEntity.getActorID());
        }
        this.listOfEntities.add(anEntity);
        ListenerManager.getCurrentListenerManager().fireModelChange("entityAdded", new EntityEvent(this, anEntity));
    }

    public final String generate(IGenerator builder) {
        builder.open(this);
        Iterator iterator = this.listOfEntities.iterator();
        while (iterator.hasNext()) {
            ((IConstituent)iterator.next()).accept(builder);
        }
        builder.close(this);
        return builder.getCode();
    }

    public final Object clone() throws CloneNotSupportedException {
        PatternModel clonedPattern = (PatternModel)super.clone();
        clonedPattern.listOfEntities = new ArrayList();
        Iterator iterator = this.listOfEntities.iterator();
        while (iterator.hasNext()) {
            Entity pEntity = (Entity)iterator.next();
            pEntity.startCloneSession();
            try {
                clonedPattern.addActor((Entity)pEntity.getClone());
            }
            catch (ModelDeclarationException pde) {
                pde.printStackTrace(OutputManager.getCurrentOutputManager().getErrorOutput());
            }
        }
        iterator = this.listOfEntities.iterator();
        while (iterator.hasNext()) {
            ((IEntity)iterator.next()).performCloneSession();
        }
        iterator = this.listOfEntities.iterator();
        while (iterator.hasNext()) {
            ((IEntity)iterator.next()).endCloneSession();
        }
        return clonedPattern;
    }

    public List compare(IAbstractModel model) {
        ArrayList<Map> solutions = new ArrayList<Map>();
        if (this.getDetector() == null) {
            OutputManager.getCurrentOutputManager().getErrorOutput().println("Error: unable to initialize AbstractLevelModel Detector.");
            return new ArrayList();
        }
        this.getDetector().setPattern(this);
        Map partialSolutions = ((Detector)this.getDetector()).buildPartialSolution(model);
        if (partialSolutions.size() > 0 && (partialSolutions = ((Detector)this.getDetector()).applyCriterias(partialSolutions, 7)).size() > 0) {
            solutions.add(partialSolutions);
        }
        return solutions;
    }

    public final boolean doesContainActorWithName(String aName) {
        Iterator iterator = this.listOfActors().iterator();
        while (iterator.hasNext()) {
            if (!aName.equals(((IEntity)iterator.next()).getName())) continue;
            return true;
        }
        return false;
    }

    public final IConstituent getActorFromName(String aName) {
        Iterator iterator = this.listOfEntities.iterator();
        while (iterator.hasNext()) {
            Constituent currentElement = (Constituent)iterator.next();
            if (!currentElement.getName().equals(aName)) continue;
            return currentElement;
        }
        return null;
    }

    public abstract int getClassification();

    public final IDetector getDetector() {
        return this.defaultDetector;
    }

    public IFactory getFactory() {
        return this.factory;
    }

    public abstract String getIdiom();

    public abstract String getIntent();

    public final List listOfActors() {
        return this.listOfEntities;
    }

    public void propertyChange(PropertyChangeEvent evt) {
    }

    private final void removeActor(IEntity anEntity) {
        this.listOfEntities.remove(anEntity);
        ListenerManager.getCurrentListenerManager().fireModelChange("entityRemoved", new EntityEvent(this, anEntity));
    }

    public final void removeActor(String anID) {
        this.removeActor((Entity)this.getActorFromID(anID));
    }

    public final void removeAllActors() {
        Iterator iterator = this.listOfActors().iterator();
        while (iterator.hasNext()) {
            this.removeActor((IEntity)iterator.next());
        }
    }

    public final void setDetector(IDetector aPatternDetector) {
        this.defaultDetector = aPatternDetector;
    }

    public void setFactory(IFactory aFactory) {
        this.factory = aFactory;
    }

    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
    }

    public final Object walk(IWalker walker) {
        walker.open(this);
        Iterator iterator = this.listOfEntities.iterator();
        while (iterator.hasNext()) {
            ((IConstituent)iterator.next()).accept(walker);
        }
        walker.close(this);
        return walker.getResult();
    }

    public abstract boolean doesContainActorWithID(String var1);

    public abstract IConstituent getActorFromID(String var1);
}

