/*
 * Decompiled with CFR 0.152.
 */
package padl.kernel.impl.v1;

import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import padl.kernel.IElementMarker;
import padl.kernel.IEntity;
import padl.kernel.IUseRelationship;
import padl.kernel.ModelDeclarationException;
import padl.kernel.impl.v1.Entity;
import padl.kernel.impl.v1.Relationship;
import util.io.OutputManager;

class UseRelationship
extends Relationship
implements IElementMarker,
PropertyChangeListener,
IUseRelationship {
    private int cardinality;
    private IEntity targetPEntity;

    public UseRelationship(String anActorID, IEntity targetPEntity, int cardinality) throws ModelDeclarationException {
        super(anActorID);
        if (cardinality < 1) {
            throw new ModelDeclarationException("The cardinality of an association must be one or more (was " + cardinality + ").");
        }
        this.setTargetActor(targetPEntity);
        this.setCardinality(cardinality);
    }

    public int getCardinality() {
        return this.cardinality;
    }

    public IEntity getTargetActor() {
        return this.targetPEntity;
    }

    public void performCloneSession() {
        super.performCloneSession();
        UseRelationship clone = (UseRelationship)this.getClone();
        clone.targetPEntity = (Entity)this.targetPEntity.getClone();
    }

    public void setCardinality(int cardinality) throws ModelDeclarationException {
        int oldCardinality = this.cardinality;
        if (cardinality < 1) {
            throw new ModelDeclarationException("The cardinality of an association must be 1 or more.");
        }
        try {
            this.fireVetoableChange("Cardinality", new Integer(oldCardinality), new Integer(cardinality));
            this.cardinality = cardinality;
            this.firePropertyChange("Cardinality", new Integer(oldCardinality), new Integer(cardinality));
        }
        catch (PropertyVetoException e) {
            e.printStackTrace(OutputManager.getCurrentOutputManager().getErrorOutput());
        }
    }

    public void setTargetActor(IEntity anEntity) {
        IEntity oldTargetEntity = this.targetPEntity;
        try {
            this.fireVetoableChange("TargetEntity", oldTargetEntity, anEntity);
            this.targetPEntity = anEntity;
            if (oldTargetEntity != null) {
                ((Entity)oldTargetEntity).removePropertyChangeListener(this);
            }
            this.firePropertyChange("TargetEntity", oldTargetEntity, anEntity);
        }
        catch (PropertyVetoException e) {
            e.printStackTrace(OutputManager.getCurrentOutputManager().getErrorOutput());
        }
    }
}

