/*
 * Decompiled with CFR 0.152.
 */
package padl.kernel.impl.v2;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import padl.event.ElementEvent;
import padl.event.EntityEvent;
import padl.kernel.IAbstractLevelModel;
import padl.kernel.IConstituent;
import padl.kernel.IContainer;
import padl.kernel.IElement;
import padl.kernel.IEntity;
import padl.kernel.ListenerManager;
import padl.kernel.ModelDeclarationException;

abstract class AbstractContainer
implements IContainer {
    private List listOfActors = new ArrayList();

    AbstractContainer() {
    }

    public void addActor(IConstituent aConstituent) throws ModelDeclarationException {
        if (this.doesContainActorWithID(aConstituent.getActorID())) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Duplicate actorID: ");
            buffer.append(aConstituent.getActorID());
            buffer.append(" (");
            buffer.append(aConstituent.getClass());
            buffer.append(") in ");
            buffer.append(this.getClass());
            throw new ModelDeclarationException(buffer.toString());
        }
        int index = 0;
        int size = this.listOfActors.size();
        String constituentName = aConstituent.getName();
        while (index < size && ((IConstituent)this.listOfActors.get(index)).getName().compareTo(constituentName) < 0) {
            ++index;
        }
        this.listOfActors.add(index, aConstituent);
        if (this instanceof IAbstractLevelModel) {
            ListenerManager.getCurrentListenerManager().fireModelChange("entityAdded", new EntityEvent((IAbstractLevelModel)((Object)this), (IEntity)aConstituent));
        } else if (this instanceof IEntity) {
            ListenerManager.getCurrentListenerManager().fireModelChange("elementAdded", new ElementEvent((IEntity)((Object)this), (IElement)aConstituent));
        }
    }

    public boolean doesContainActorWithName(String aName) {
        return this.getActorFromName(aName) != null;
    }

    public boolean doesContainActorWithID(String anID) {
        return this.getActorFromID(anID) != null;
    }

    public IConstituent getActorFromID(String anID) {
        Iterator iterator = this.listOfActors().iterator();
        while (iterator.hasNext()) {
            IConstituent constituent = (IConstituent)iterator.next();
            if (!constituent.getActorID().equals(anID)) continue;
            return constituent;
        }
        return null;
    }

    public IConstituent getActorFromName(String aName) {
        Iterator iterator = this.listOfActors().iterator();
        while (iterator.hasNext()) {
            IConstituent constituent = (IConstituent)iterator.next();
            if (!constituent.getName().equals(aName)) continue;
            return constituent;
        }
        return null;
    }

    public List listOfActors() {
        return this.listOfActors;
    }

    public void removeActor(String anID) {
        this.removeActor(this.getActorFromID(anID));
    }

    private final void removeActor(IConstituent aConstituent) {
        this.listOfActors().remove(aConstituent);
        if (this instanceof IAbstractLevelModel) {
            ListenerManager.getCurrentListenerManager().fireModelChange("entityRemoved", new EntityEvent((IAbstractLevelModel)((Object)this), (IEntity)aConstituent));
        } else if (this instanceof IEntity) {
            ListenerManager.getCurrentListenerManager().fireModelChange("elementRemoved", new ElementEvent((IEntity)((Object)this), (IElement)aConstituent));
        }
    }

    public void removeAllActors() {
        while (this.listOfActors.size() > 0) {
            this.removeActor((IConstituent)this.listOfActors.get(0));
        }
    }

    public void resetListOfActors() {
        this.listOfActors = new ArrayList();
    }
}

