/*
 * Decompiled with CFR 0.152.
 */
package padl.kernel.impl.v2;

import java.util.Iterator;
import java.util.List;
import padl.kernel.IAbstractLevelModel;
import padl.kernel.IAbstractModel;
import padl.kernel.IConstituent;
import padl.kernel.IEntity;
import padl.kernel.IFactory;
import padl.kernel.IGenerator;
import padl.kernel.IWalker;
import padl.kernel.ModelDeclarationException;
import padl.kernel.impl.v2.AbstractContainer;
import util.io.OutputManager;

abstract class AbstractLevelModel
extends AbstractContainer
implements IAbstractLevelModel {
    private IFactory factory;

    AbstractLevelModel() {
    }

    public void addGhostActor(String aName) throws ModelDeclarationException {
        super.addActor(this.getFactory().createGhost(aName));
    }

    public final Object clone() throws CloneNotSupportedException {
        AbstractLevelModel clonedModel = (AbstractLevelModel)super.clone();
        clonedModel.removeAllActors();
        Iterator iterator = this.listOfActors().iterator();
        while (iterator.hasNext()) {
            IEntity pEntity = (IEntity)iterator.next();
            pEntity.startCloneSession();
            try {
                clonedModel.addActor((IEntity)pEntity.getClone());
            }
            catch (ModelDeclarationException pde) {
                pde.printStackTrace(OutputManager.getCurrentOutputManager().getErrorOutput());
            }
        }
        iterator = this.listOfActors().iterator();
        while (iterator.hasNext()) {
            ((IEntity)iterator.next()).performCloneSession();
        }
        iterator = this.listOfActors().iterator();
        while (iterator.hasNext()) {
            ((IEntity)iterator.next()).endCloneSession();
        }
        return clonedModel;
    }

    public final String generate(IGenerator builder) {
        builder.open(this);
        Iterator iterator = this.listOfActors().iterator();
        while (iterator.hasNext()) {
            ((IConstituent)iterator.next()).accept(builder);
        }
        builder.close(this);
        return builder.getCode();
    }

    public IFactory getFactory() {
        return this.factory;
    }

    public void setFactory(IFactory aFactory) {
        this.factory = aFactory;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        Iterator iterator = this.listOfActors().iterator();
        while (iterator.hasNext()) {
            buffer.append(iterator.next().toString());
            if (!iterator.hasNext()) continue;
            buffer.append('\n');
        }
        return buffer.toString();
    }

    public final Object walk(IWalker walker) {
        walker.open(this);
        Iterator iterator = this.listOfActors().iterator();
        while (iterator.hasNext()) {
            ((IConstituent)iterator.next()).accept(walker);
        }
        walker.close(this);
        return walker.getResult();
    }

    public abstract List compare(IAbstractModel var1);

    public abstract String getName();
}

