/*
 * Decompiled with CFR 0.152.
 */
package padl.kernel.impl.v2;

import com.ibm.toad.cfparse.utils.Access;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import padl.kernel.IConstituent;
import padl.kernel.IVisitor;
import padl.kernel.ModelDeclarationException;
import padl.kernel.impl.v2.AbstractContainer;
import padl.util.Misc;

abstract class Constituent
extends AbstractContainer
implements IConstituent {
    private String actorID;
    private Constituent clone;
    private List clonedBoundEventList = new ArrayList(0);
    private List clonedVetoEventList = new ArrayList(0);
    private String[] codeLines;
    private String comment;
    private String name;
    private String displayName;
    private int visibility = 1;
    private int weight = 100;

    public Constituent(String actorID) {
        this.actorID = actorID;
        this.setName(actorID);
    }

    public void accept(IVisitor visitor) {
        this.accept(visitor, "visit");
    }

    protected void accept(IVisitor visitor, String methodName) {
        try {
            Class[] argument = new Class[]{Class.forName(this.getClass().getName().replaceAll(".impl.v2.", ".I"))};
            Method method = visitor.getClass().getMethod(methodName, argument);
            method.invoke((Object)visitor, this);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void endCloneSession() {
        this.clone = null;
        this.clonedBoundEventList.clear();
        this.clonedVetoEventList.clear();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof IConstituent)) {
            return false;
        }
        return this.actorID.equals(((Constituent)obj).getActorID());
    }

    public String getActorID() {
        return this.actorID;
    }

    public IConstituent getClone() {
        return this.clone;
    }

    public String[] getCodeLines() {
        return this.codeLines;
    }

    public String getComment() {
        return this.comment;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public int getVisibility() {
        return this.visibility;
    }

    public int getWeight() {
        return this.weight;
    }

    public int hashCode() {
        return this.actorID.hashCode();
    }

    public boolean isAbstract() {
        return Access.isAbstract(this.visibility);
    }

    public boolean isPrivate() {
        return Access.isPrivate(this.visibility);
    }

    public boolean isPublic() {
        return Access.isPublic(this.visibility);
    }

    public boolean isStatic() {
        return Access.isStatic(this.visibility);
    }

    public void performCloneSession() {
    }

    public void resetCodeLines() throws ModelDeclarationException {
        this.setCodeLines("");
    }

    public void setAbstract(boolean aBoolean) throws ModelDeclarationException {
        this.setVisibility(aBoolean ? this.getVisibility() | 0x400 : this.getVisibility() & 0xFFFFFBFF);
    }

    public void setCodeLines(String code) throws ModelDeclarationException {
        this.setCodeLines(new String[]{code});
    }

    public void setCodeLines(String[] code) throws ModelDeclarationException {
        if (this.isAbstract()) {
            throw new ModelDeclarationException("This Element can't contain code definition");
        }
        this.codeLines = code;
    }

    public void setComment(String aComment) {
        this.comment = aComment;
    }

    public void setName(String aName) {
        this.name = aName;
        this.setDisplayName(aName);
    }

    public void setDisplayName(String aName) {
        this.displayName = aName;
    }

    public void setPrivate(boolean aBoolean) {
        try {
            this.setVisibility(aBoolean ? (this.getVisibility() | 2) & 0xFFFFFFFA : this.getVisibility() & 0xFFFFFFFD);
        }
        catch (ModelDeclarationException modelDeclarationException) {
            // empty catch block
        }
    }

    public void setPublic(boolean aBoolean) {
        try {
            this.setVisibility(aBoolean ? (this.getVisibility() | 1) & 0xFFFFFFF9 : this.getVisibility() & 0xFFFFFFFE);
        }
        catch (ModelDeclarationException modelDeclarationException) {
            // empty catch block
        }
    }

    public void setStatic(boolean aBoolean) {
        try {
            this.setVisibility(aBoolean ? this.getVisibility() | 8 : this.getVisibility() & 0xFFFFFFF7);
        }
        catch (ModelDeclarationException modelDeclarationException) {
            // empty catch block
        }
    }

    public void setVisibility(int visibility) throws ModelDeclarationException {
        if (this.getCodeLines() != null && Access.isAbstract(visibility)) {
            throw new ModelDeclarationException("This element can't be abstract");
        }
        this.visibility = visibility;
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }

    public void startCloneSession() {
        try {
            Constituent tmpObject;
            this.clone = tmpObject = (Constituent)super.clone();
            tmpObject.clone = null;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int tab) {
        StringBuffer codeEq = new StringBuffer();
        Misc.addTabs(tab, codeEq);
        if (this.getComment() != null) {
            codeEq.append("/* ");
            codeEq.append(this.getComment());
            codeEq.append(" */\n");
            Misc.addTabs(tab, codeEq);
        }
        codeEq.append(Modifier.toString(this.getVisibility()));
        return codeEq.toString();
    }
}

