/*
 * Decompiled with CFR 0.152.
 */
package padl.kernel.impl.v2;

import com.ibm.toad.cfparse.MethodInfo;
import java.util.Iterator;
import padl.kernel.IConstituent;
import padl.kernel.IConstructor;
import padl.kernel.IElement;
import padl.kernel.IElementMarker;
import padl.kernel.IMethod;
import padl.kernel.IMethodInvocation;
import padl.kernel.IParameter;
import padl.kernel.IVisitor;
import padl.kernel.ModelDeclarationException;
import padl.kernel.impl.v2.Attribute;
import padl.kernel.impl.v2.Parameter;
import padl.util.Misc;
import util.lang.Modifier;

class Constructor
extends Attribute
implements IElementMarker,
IConstructor {
    public Constructor(IMethod attachedMethod) throws ModelDeclarationException {
        this(attachedMethod.getActorID(), attachedMethod);
    }

    public Constructor(MethodInfo aMethod) {
        this(aMethod.getName(), aMethod);
    }

    public Constructor(String anActorID) {
        super(anActorID);
    }

    public Constructor(String anActorID, IMethod attachedMethod) throws ModelDeclarationException {
        super(anActorID);
        if (attachedMethod != null) {
            this.attachTo(attachedMethod);
        }
    }

    public Constructor(String anActorID, MethodInfo aMethod) {
        super(anActorID);
        try {
            this.setVisibility(aMethod.getAccess());
        }
        catch (ModelDeclarationException modelDeclarationException) {
            // empty catch block
        }
        String[] detectedParameters = aMethod.getParams();
        int i = 0;
        while (i < detectedParameters.length) {
            try {
                this.addActor(new Parameter(Misc.stripAndCapQualifiedName(detectedParameters[i])));
            }
            catch (ModelDeclarationException modelDeclarationException) {
                // empty catch block
            }
            ++i;
        }
    }

    public void accept(IVisitor visitor) {
        super.accept(visitor);
        Iterator e = this.listOfActors().iterator();
        while (e.hasNext()) {
            ((IElement)e.next()).accept(visitor);
        }
    }

    public void addActor(IConstituent aConstituent) throws ModelDeclarationException {
        if (aConstituent instanceof IParameter) {
            this.addActor((IParameter)aConstituent);
        } else if (aConstituent instanceof IMethodInvocation) {
            this.addActor((IMethodInvocation)aConstituent);
        } else {
            throw new ModelDeclarationException("Only a parameter or a method invocation can be added to a method.");
        }
    }

    public void addActor(IMethodInvocation aMethodInvocation) throws ModelDeclarationException {
        super.addActor(aMethodInvocation);
    }

    public void addActor(IParameter aParameter) throws ModelDeclarationException {
        super.addActor(aParameter);
    }

    public boolean equals(Object o) {
        if (!(o instanceof IConstructor)) {
            return false;
        }
        return this.getActorID().equals(((IConstructor)o).getActorID());
    }

    public String getCallDeclaration() {
        StringBuffer codeEq = new StringBuffer();
        codeEq.append(this.getName());
        codeEq.append("(");
        Iterator iterator = this.listOfActors().iterator();
        boolean hasPredecessor = false;
        while (iterator.hasNext()) {
            IConstituent constituent = (IConstituent)iterator.next();
            if (!(constituent instanceof IParameter)) continue;
            if (hasPredecessor) {
                codeEq.append(",");
            } else {
                hasPredecessor = true;
            }
            codeEq.append(constituent.getName());
        }
        codeEq.append(")");
        return codeEq.toString();
    }

    public void startCloneSession() {
        super.startCloneSession();
        ((Constructor)this.getClone()).resetListOfActors();
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int tab) {
        StringBuffer codeEq = new StringBuffer();
        this.toStringStart(tab, codeEq);
        this.toStringSignature(codeEq);
        this.toStringBody(tab, codeEq);
        return codeEq.toString();
    }

    protected void toStringBody(int tab, StringBuffer codeEq) {
        codeEq.append(" {\n");
        Iterator enum2 = this.listOfActors().iterator();
        while (enum2.hasNext()) {
            IElement element = (IElement)enum2.next();
            if (!(element instanceof IMethodInvocation)) continue;
            Misc.addTabs(tab + 1, codeEq);
            codeEq.append("// Method invocation: ");
            codeEq.append(element.toString());
            codeEq.append('\n');
        }
        String[] codeLines = this.getCodeLines();
        if (codeLines != null) {
            int i = 0;
            while (i < codeLines.length) {
                Misc.addTabs(tab + 1, codeEq);
                codeEq.append(codeLines[i]);
                codeEq.append('\n');
                ++i;
            }
        }
        Misc.addTabs(tab, codeEq);
        codeEq.append('}');
    }

    protected void toStringSignature(StringBuffer codeEq) {
        codeEq.append(' ');
        codeEq.append(this.getName());
        codeEq.append('(');
        Iterator iterator = this.listOfActors().iterator();
        while (iterator.hasNext()) {
            IElement element = (IElement)iterator.next();
            if (!(element instanceof IParameter)) continue;
            codeEq.append(element.toString());
            if (!iterator.hasNext()) continue;
            codeEq.append(", ");
        }
        codeEq.append(')');
    }

    protected void toStringStart(int tab, StringBuffer codeEq) {
        Misc.addTabs(tab, codeEq);
        if (this.getComment() != null) {
            codeEq.append("/* ");
            codeEq.append(this.getComment());
            codeEq.append(" */\n");
            Misc.addTabs(tab, codeEq);
        }
        codeEq.append(Modifier.toString(this.getVisibility()));
    }
}

