/*
 * Decompiled with CFR 0.152.
 */
package padl.kernel.impl.v2;

import com.ibm.toad.cfparse.utils.Access;
import padl.kernel.IAssociation;
import padl.kernel.IDelegatingMethod;
import padl.kernel.IElementMarker;
import padl.kernel.IMethod;
import padl.kernel.ModelDeclarationException;
import padl.kernel.impl.v2.Association;
import padl.kernel.impl.v2.Method;
import padl.util.Misc;

class DelegatingMethod
extends Method
implements IElementMarker,
IDelegatingMethod {
    private IAssociation targetAssoc;
    private IMethod targetMethod;
    private Association temporaryTargetAssociation;
    private Method temporaryTargetMethod;

    public DelegatingMethod(String anActorID, IAssociation targetAssoc) throws ModelDeclarationException {
        this(anActorID, targetAssoc, null);
    }

    public DelegatingMethod(String anActorID, IAssociation targetAssoc, IMethod targetMethod) throws ModelDeclarationException {
        super(anActorID, targetMethod);
        this.setTargetAssoc(targetAssoc);
        if (targetMethod == null) {
            this.setTargetMethod(this);
        } else {
            this.setTargetMethod(targetMethod);
        }
    }

    public void endCloneSession() {
        super.endCloneSession();
        this.temporaryTargetAssociation = null;
        this.temporaryTargetMethod = null;
    }

    public IAssociation getTargetAssoc() {
        return this.targetAssoc;
    }

    public IMethod getTargetMethod() {
        return this.targetMethod;
    }

    public void setTargetAssoc(IAssociation anAssociation) {
        this.targetAssoc = anAssociation;
    }

    public void setTargetMethod(IMethod aMethod) {
        this.targetMethod = aMethod;
    }

    public void setVisibility(int visibility) throws ModelDeclarationException {
        if (Access.isAbstract(visibility)) {
            throw new ModelDeclarationException(this.getClass() + " can't be abstract.");
        }
        super.setVisibility(visibility);
    }

    public void startCloneSession() {
        super.startCloneSession();
        DelegatingMethod clone = (DelegatingMethod)this.getClone();
        if (this.temporaryTargetAssociation != null) {
            clone.targetAssoc = this.temporaryTargetAssociation;
        }
        if (this.temporaryTargetMethod != null) {
            clone.targetMethod = this.temporaryTargetMethod;
        }
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int tab) {
        try {
            if (this.getTargetAssoc().getCardinality() > 1) {
                this.setCodeLines("for (Enumeration enum = " + this.targetAssoc.getName() + ".elements(); enum.hasMoreElements(); ((" + this.getTargetAssoc().getTargetActor().getName() + ") enum.nextElement())." + this.getTargetMethod().getCallDeclaration() + ");");
            } else {
                this.setCodeLines(String.valueOf(this.getTargetAssoc().getName()) + "." + this.getTargetMethod().getCallDeclaration() + ";");
            }
        }
        catch (ModelDeclarationException modelDeclarationException) {
            // empty catch block
        }
        StringBuffer codeEq = new StringBuffer();
        Misc.addTabs(tab, codeEq);
        codeEq.append("// Method linked to: ");
        codeEq.append(this.getTargetAssoc().getName());
        codeEq.append('\n');
        codeEq.append(super.toString(tab));
        return codeEq.toString();
    }
}

