/*
 * Decompiled with CFR 0.152.
 */
package padl.kernel.impl.v2;

import padl.kernel.IElement;
import padl.kernel.ModelDeclarationException;
import padl.kernel.impl.v2.Constituent;

abstract class Element
extends Constituent
implements IElement {
    private IElement attachedElement;

    public Element(String actorID) {
        super(actorID);
    }

    public void attachTo(IElement anElement) throws ModelDeclarationException {
        if (anElement == this) {
            throw new ModelDeclarationException("A Element cannot be attached to itself.");
        }
        if (!anElement.getClass().isInstance(this)) {
            throw new ModelDeclarationException(this.getClass() + " cannot be attached to " + anElement.getClass());
        }
        this.detach();
        this.attachedElement = anElement;
    }

    public void detach() {
        IElement oldAttachedElement = this.getAttachedElement();
        if (oldAttachedElement == null) {
            return;
        }
        this.attachedElement = null;
    }

    public IElement getAttachedElement() {
        return this.attachedElement;
    }

    public String getName() {
        if (this.getAttachedElement() == null) {
            return super.getName();
        }
        return this.getAttachedElement().getName();
    }

    public void performCloneSession() {
        if (this.getAttachedElement() != null) {
            ((Element)this.getClone()).attachedElement = (Element)this.getAttachedElement().getClone();
        }
        super.performCloneSession();
    }

    public void startCloneSession() {
        super.startCloneSession();
        ((Element)this.getClone()).attachedElement = null;
    }
}

