/*
 * Decompiled with CFR 0.152.
 */
package padl.kernel.impl.v2;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import padl.kernel.IConstituent;
import padl.kernel.IElement;
import padl.kernel.IEntity;
import padl.kernel.IVisitor;
import padl.kernel.ModelDeclarationException;
import padl.kernel.impl.v2.Constituent;
import padl.kernel.impl.v2.Element;
import padl.util.Misc;

abstract class Entity
extends Constituent
implements IEntity {
    private List listOfInheritedEntities = new ArrayList();
    private List listOfInheritingEntities = new ArrayList();
    private String purpose;

    public Entity(String actorID) {
        super(actorID);
    }

    public void accept(IVisitor visitor) {
        this.accept(visitor, "open");
        Iterator iterator = this.listOfActors().iterator();
        while (iterator.hasNext()) {
            ((IConstituent)iterator.next()).accept(visitor);
        }
        this.accept(visitor, "close");
    }

    public void addActor(IConstituent aConstituent) throws ModelDeclarationException {
        if (!(aConstituent instanceof IElement)) {
            throw new ModelDeclarationException("Only an element can be added to an entity.");
        }
        this.addActor((IElement)aConstituent);
    }

    public void addActor(IElement anElement) throws ModelDeclarationException {
        super.addActor(anElement);
    }

    public void addInheritedActor(IEntity anEntity) throws ModelDeclarationException {
        if (anEntity == this) {
            throw new ModelDeclarationException("An Entity can't inherit from itself");
        }
        if (this.listOfInheritedEntities.contains(anEntity)) {
            throw new ModelDeclarationException(String.valueOf(anEntity.getActorID()) + " is already inherited from " + this.getActorID());
        }
        this.listOfInheritedEntities.add(anEntity);
        ((Entity)anEntity).addInheritingActor(this);
    }

    public void addInheritingActor(IEntity anEntity) throws ModelDeclarationException {
        if (anEntity == this) {
            throw new ModelDeclarationException("An Entity can't inherit from itself");
        }
        if (this.listOfInheritedEntities.contains(anEntity)) {
            throw new ModelDeclarationException(String.valueOf(anEntity.getActorID()) + " is already inheriting from " + this.getActorID());
        }
        this.listOfInheritingEntities.add(anEntity);
    }

    public void endCloneSession() {
        super.endCloneSession();
        Iterator iterator = this.listOfActors().iterator();
        while (iterator.hasNext()) {
            ((IConstituent)iterator.next()).endCloneSession();
        }
    }

    public IEntity getInheritedActor(String anEntityName) {
        Iterator iterator = this.listOfInheritedEntities.iterator();
        while (iterator.hasNext()) {
            Entity inheritedEntity = (Entity)iterator.next();
            if (!inheritedEntity.getName().equals(anEntityName)) continue;
            return inheritedEntity;
        }
        return null;
    }

    public String getPurpose() {
        return this.purpose;
    }

    public boolean isAboveInHierarchy(IEntity pEntity) {
        if (this.equals(pEntity)) {
            return true;
        }
        Iterator iterator = pEntity.listOfInheritedActors().iterator();
        if (iterator.hasNext()) {
            IEntity s = (IEntity)iterator.next();
            if (this.equals(s)) {
                return true;
            }
            return this.isAboveInHierarchy(s);
        }
        return false;
    }

    public List listOfInheritingActors() {
        return this.listOfInheritingEntities;
    }

    public List listOfInheritedActors() {
        return this.listOfInheritedEntities;
    }

    public void performCloneSession() {
        IElement element;
        super.performCloneSession();
        Entity clonedEntity = (Entity)this.getClone();
        clonedEntity.listOfInheritedEntities = new ArrayList();
        Iterator iterator = this.listOfInheritedEntities.iterator();
        while (iterator.hasNext()) {
            Entity currentPEntity = (Entity)iterator.next();
            if (currentPEntity.getClone() == null) continue;
            clonedEntity.listOfInheritedEntities.add(currentPEntity.getClone());
        }
        clonedEntity.resetListOfActors();
        iterator = this.listOfActors().iterator();
        while (iterator.hasNext()) {
            element = (IElement)iterator.next();
            element.startCloneSession();
        }
        iterator = this.listOfActors().iterator();
        while (iterator.hasNext()) {
            element = (Element)iterator.next();
            ((Element)element).performCloneSession();
            clonedEntity.listOfActors().add(((Constituent)((Object)element)).getClone());
        }
    }

    public void removeInheritedActor(IEntity anEntity) {
        this.listOfInheritedEntities.remove(anEntity);
    }

    public void removeInheritingActor(IEntity anEntity) {
        this.listOfInheritingEntities.remove(anEntity);
    }

    public void setPurpose(String purpose) {
        this.purpose = purpose;
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int tab) {
        StringBuffer codeEq = new StringBuffer();
        if (this.getPurpose() != null) {
            Misc.addTabs(tab, codeEq);
            codeEq.append("/* ");
            codeEq.append(this.getActorID());
            codeEq.append(" : Purpose\n");
            Misc.addTabs(tab, codeEq);
            codeEq.append(this.getPurpose());
            Misc.addTabs(tab, codeEq);
            codeEq.append("\n*/\n");
        }
        codeEq.append(super.toString(tab));
        return codeEq.toString();
    }
}

