/*
 * Decompiled with CFR 0.152.
 */
package padl.kernel.impl.v2;

import com.ibm.toad.cfparse.MethodInfo;
import padl.kernel.IElementMarker;
import padl.kernel.IMethod;
import padl.kernel.ModelDeclarationException;
import padl.kernel.impl.v2.Constructor;
import padl.kernel.impl.v2.Parameter;
import padl.util.Misc;

class Method
extends Constructor
implements IElementMarker,
IMethod {
    private String returnType = "void";

    public Method(IMethod attachedMethod) throws ModelDeclarationException {
        this(attachedMethod.getActorID(), attachedMethod);
    }

    public Method(MethodInfo aMethod) {
        this(aMethod.getName(), aMethod);
    }

    public Method(String anActorID) {
        super(anActorID);
    }

    public Method(String anActorID, IMethod attachedMethod) throws ModelDeclarationException {
        super(anActorID);
        if (attachedMethod != null) {
            this.attachTo(attachedMethod);
        }
    }

    public Method(String anActorID, MethodInfo aMethod) {
        super(anActorID);
        try {
            this.setVisibility(aMethod.getAccess());
        }
        catch (ModelDeclarationException modelDeclarationException) {
            // empty catch block
        }
        this.setReturnType(aMethod.getReturnType());
        String[] detectedParameters = aMethod.getParams();
        int i = 0;
        while (i < detectedParameters.length) {
            try {
                this.addActor(new Parameter(Misc.stripAndCapQualifiedName(detectedParameters[i])));
            }
            catch (ModelDeclarationException modelDeclarationException) {
                // empty catch block
            }
            ++i;
        }
    }

    public String getReturnType() {
        if (this.getAttachedElement() == null) {
            return this.returnType;
        }
        return ((IMethod)this.getAttachedElement()).getReturnType();
    }

    public void setReturnType(String aType) {
        this.returnType = aType;
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int tab) {
        StringBuffer codeEq = new StringBuffer();
        this.toStringStart(tab, codeEq);
        codeEq.append(' ');
        codeEq.append(this.getReturnType());
        this.toStringSignature(codeEq);
        if (this.isAbstract()) {
            return String.valueOf(codeEq.toString()) + ';';
        }
        this.toStringBody(tab, codeEq);
        return codeEq.toString();
    }
}

