/*
 * Decompiled with CFR 0.152.
 */
package padl.kernel.impl.v2;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import padl.kernel.IAbstractModel;
import padl.kernel.IConstituent;
import padl.kernel.IDetector;
import padl.kernel.IEntity;
import padl.kernel.IFactory;
import padl.kernel.IGenerator;
import padl.kernel.IPatternModel;
import padl.kernel.IWalker;
import padl.kernel.ModelDeclarationException;
import padl.kernel.impl.v2.Constituent;
import padl.kernel.impl.v2.Entity;
import padl.pattern.Detector;
import util.io.OutputManager;

public abstract class PatternModel
extends Constituent
implements IPatternModel {
    private IDetector defaultDetector;
    private IFactory factory;

    public PatternModel(String actorID) {
        super(actorID);
    }

    public final void addActor(IConstituent constituent) throws ModelDeclarationException {
        if (!(constituent instanceof IEntity)) {
            throw new ModelDeclarationException("Only an entity can be added to a model.");
        }
        super.addActor((Entity)constituent);
    }

    public final String generate(IGenerator builder) {
        builder.open(this);
        Iterator iterator = this.listOfActors().iterator();
        while (iterator.hasNext()) {
            ((IConstituent)iterator.next()).accept(builder);
        }
        builder.close(this);
        return builder.getCode();
    }

    public final Object clone() throws CloneNotSupportedException {
        PatternModel clonedPattern = (PatternModel)super.clone();
        clonedPattern.resetListOfActors();
        Iterator iterator = this.listOfActors().iterator();
        while (iterator.hasNext()) {
            Entity pEntity = (Entity)iterator.next();
            pEntity.startCloneSession();
            try {
                clonedPattern.addActor((Entity)pEntity.getClone());
            }
            catch (ModelDeclarationException pde) {
                pde.printStackTrace(OutputManager.getCurrentOutputManager().getErrorOutput());
            }
        }
        iterator = this.listOfActors().iterator();
        while (iterator.hasNext()) {
            ((IEntity)iterator.next()).performCloneSession();
        }
        iterator = this.listOfActors().iterator();
        while (iterator.hasNext()) {
            ((IEntity)iterator.next()).endCloneSession();
        }
        return clonedPattern;
    }

    public List compare(IAbstractModel model) {
        ArrayList<Map> solutions = new ArrayList<Map>();
        if (this.getDetector() == null) {
            OutputManager.getCurrentOutputManager().getErrorOutput().println("Error: unable to initialize AbstractLevelModel Detector.");
            return new ArrayList();
        }
        this.getDetector().setPattern(this);
        Map partialSolutions = ((Detector)this.getDetector()).buildPartialSolution(model);
        if (partialSolutions.size() > 0 && (partialSolutions = ((Detector)this.getDetector()).applyCriterias(partialSolutions, 7)).size() > 0) {
            solutions.add(partialSolutions);
        }
        return solutions;
    }

    public abstract int getClassification();

    public final IDetector getDetector() {
        return this.defaultDetector;
    }

    public IFactory getFactory() {
        return this.factory;
    }

    public abstract String getIdiom();

    public abstract String getIntent();

    public final void setDetector(IDetector aPatternDetector) {
        this.defaultDetector = aPatternDetector;
    }

    public void setFactory(IFactory aFactory) {
        this.factory = aFactory;
    }

    public final Object walk(IWalker walker) {
        walker.open(this);
        Iterator iterator = this.listOfActors().iterator();
        while (iterator.hasNext()) {
            ((IConstituent)iterator.next()).accept(walker);
        }
        walker.close(this);
        return walker.getResult();
    }
}

