/*
 * Decompiled with CFR 0.152.
 */
package padl.kernel.impl.v2;

import padl.kernel.IElementMarker;
import padl.kernel.IEntity;
import padl.kernel.IUseRelationship;
import padl.kernel.ModelDeclarationException;
import padl.kernel.impl.v2.Entity;
import padl.kernel.impl.v2.Relationship;

class UseRelationship
extends Relationship
implements IElementMarker,
IUseRelationship {
    private int cardinality;
    private IEntity targetPEntity;

    public UseRelationship(String anActorID, IEntity targetPEntity, int cardinality) throws ModelDeclarationException {
        super(anActorID);
        if (cardinality < 1) {
            throw new ModelDeclarationException("The cardinality of an association must be one or more (was " + cardinality + ").");
        }
        this.setTargetActor(targetPEntity);
        this.setCardinality(cardinality);
    }

    public int getCardinality() {
        return this.cardinality;
    }

    public IEntity getTargetActor() {
        return this.targetPEntity;
    }

    public void performCloneSession() {
        super.performCloneSession();
        UseRelationship clone = (UseRelationship)this.getClone();
        clone.targetPEntity = (Entity)this.targetPEntity.getClone();
    }

    public void setCardinality(int cardinality) throws ModelDeclarationException {
        if (cardinality < 1) {
            throw new ModelDeclarationException("The cardinality of an association must be 1 or more.");
        }
        this.cardinality = cardinality;
    }

    public void setTargetActor(IEntity anEntity) {
        this.targetPEntity = anEntity;
    }
}

