/*
 * Decompiled with CFR 0.152.
 */
package padl.pattern.repository;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import padl.event.IListener;
import padl.kernel.IAssociation;
import padl.kernel.IClass;
import padl.kernel.IComposition;
import padl.kernel.IDelegatingMethod;
import padl.kernel.IElement;
import padl.kernel.IInterface;
import padl.kernel.IMethod;
import padl.kernel.IPatternModel;
import padl.kernel.ListenerManager;
import padl.kernel.ModelDeclarationException;
import padl.kernel.impl.v2.Factory;
import padl.pattern.Detector;
import padl.pattern.StructuralPatternModel;
import padl.util.ModelStatistics;
import padl.visitor.JavaGenerator;
import padl.visitor.PtidejSolver2AC4DomainGenerator;
import padl.visitor.PtidejSolverCustomConstraintGenerator;
import util.io.OutputManager;

public class Composite
extends StructuralPatternModel
implements Cloneable {
    public Composite() throws CloneNotSupportedException, ModelDeclarationException {
        this((IListener)null);
    }

    public Composite(IListener patternListener) throws CloneNotSupportedException, ModelDeclarationException {
        super("CompositeActor");
        this.setFactory(Factory.getUniqueInstance());
        ListenerManager.getCurrentListenerManager().addModelListener(patternListener);
        IInterface iComponent = this.getFactory().createInterface("Component");
        IMethod mOperation = this.getFactory().createMethod("operation");
        iComponent.addActor(mOperation);
        this.addActor(iComponent);
        IComposition aComposition = this.getFactory().createCompositionRelationship("children", iComponent, 2);
        IClass cComposite = this.getFactory().createClass("Composite");
        cComposite.addImplementedEntity(iComponent);
        cComposite.addActor(aComposition);
        IDelegatingMethod mDelegation = this.getFactory().createDelegatingMethod("operation", aComposition);
        mDelegation.attachTo(mOperation);
        cComposite.addActor(mDelegation);
        this.addActor(cComposite);
        this.addLeaf(new String[]{"Leaf"});
    }

    public void addLeaf(String[] names) throws ModelDeclarationException, CloneNotSupportedException {
        String leafName = names[0];
        IClass aClass = this.getFactory().createClass(leafName);
        aClass.addImplementedEntity((IInterface)this.getActorFromName("Component"));
        aClass.assumeAllInterfaces();
        this.addActor(aClass);
    }

    public List compare(IPatternModel model) {
        ArrayList<Map> solutions = new ArrayList<Map>();
        if (this.getDetector() == null) {
            OutputManager.getCurrentOutputManager().getErrorOutput().println("Error: unable to initialize the AbstractLevelModel detector.");
            return solutions;
        }
        this.getDetector().setPattern(this);
        Map partialSolutions = ((Detector)this.getDetector()).buildPartialSolution(model);
        if (partialSolutions.size() > 0 && (partialSolutions = ((Detector)this.getDetector()).applyCriterias(partialSolutions, 4)).size() > 0) {
            solutions.add(partialSolutions);
        }
        if (solutions.size() != 1) {
            return solutions;
        }
        Map matched = (Map)solutions.get(0);
        solutions.clear();
        Iterator iterator = ((List)matched.get("Component")).iterator();
        while (iterator.hasNext()) {
            IClass currentClass;
            IClass currentPInterface = (IClass)iterator.next();
            ArrayList<IClass> tmpVector = new ArrayList<IClass>();
            ArrayList<IClass> tmpVector2 = new ArrayList<IClass>();
            tmpVector2.add(currentPInterface);
            HashMap<String, ArrayList<IClass>> currentSolution = new HashMap<String, ArrayList<IClass>>();
            currentSolution.put("Component", tmpVector2);
            Iterator iterator2 = ((List)matched.get("Composite")).iterator();
            while (iterator2.hasNext()) {
                currentClass = (IClass)iterator2.next();
                Iterator iterator3 = currentClass.listOfActors().iterator();
                while (iterator3.hasNext()) {
                    IElement pElement = (IElement)iterator3.next();
                    if (!(pElement instanceof IAssociation) || ((IAssociation)pElement).getTargetActor() != currentPInterface) continue;
                    tmpVector.add(currentClass);
                }
            }
            if (tmpVector.size() > 0) {
                currentSolution.put("Composite", tmpVector);
            }
            tmpVector.clear();
            iterator2 = ((List)matched.get("Leaf")).iterator();
            while (iterator2.hasNext()) {
                currentClass = (IClass)iterator2.next();
                if (!currentClass.listOfInheritedActors().contains(currentPInterface) || ((List)currentSolution.get("Composite")).contains(currentClass)) continue;
                tmpVector.add(currentClass);
            }
            if (tmpVector.size() > 0) {
                currentSolution.put("Leaf", tmpVector);
            }
            if (currentSolution.size() != this.listOfActors().size()) continue;
            solutions.add(currentSolution);
        }
        return solutions;
    }

    public String getIdiom() {
        return "None";
    }

    public String getIntent() {
        return "Compose objects into tree structures\nto represent part-whole hierarchies.\nComposite lets clients treat individual\nobjects and compositions of objects\nuniformly.";
    }

    public String getName() {
        return "Composite";
    }

    public static void main(String[] args) throws CloneNotSupportedException, ModelDeclarationException {
        ModelStatistics patternListener = new ModelStatistics();
        Composite composite = new Composite(patternListener);
        JavaGenerator javaGenerator = new JavaGenerator();
        PtidejSolverCustomConstraintGenerator constraintGenerator = new PtidejSolverCustomConstraintGenerator();
        PtidejSolver2AC4DomainGenerator domainGenerator = new PtidejSolver2AC4DomainGenerator();
        OutputManager.getCurrentOutputManager().getNormalOutput().println(composite);
        OutputManager.getCurrentOutputManager().getNormalOutput().println("----");
        composite.generate(javaGenerator);
        OutputManager.getCurrentOutputManager().getNormalOutput().println(javaGenerator.getCode());
        OutputManager.getCurrentOutputManager().getNormalOutput().println("----");
        composite.generate(constraintGenerator);
        OutputManager.getCurrentOutputManager().getNormalOutput().println(constraintGenerator.getCode());
        OutputManager.getCurrentOutputManager().getNormalOutput().println("----");
        composite.walk(domainGenerator);
        OutputManager.getCurrentOutputManager().getNormalOutput().println(domainGenerator.getResult());
        OutputManager.getCurrentOutputManager().getNormalOutput().println("----");
        javaGenerator.reset();
        composite.generate(javaGenerator);
        OutputManager.getCurrentOutputManager().getNormalOutput().println(javaGenerator.getCode());
        OutputManager.getCurrentOutputManager().getNormalOutput().println("----");
        OutputManager.getCurrentOutputManager().getNormalOutput().println(patternListener);
    }

    public void removeLeaf(String[] names) {
        String leafName = names[0];
        if (this.listOfActors().size() > 3) {
            this.removeActor(leafName);
        }
    }
}

