/*
 * Decompiled with CFR 0.152.
 */
package padl.pattern.repository;

import padl.kernel.IAssociation;
import padl.kernel.IClass;
import padl.kernel.IDelegatingMethod;
import padl.kernel.IMethod;
import padl.kernel.ModelDeclarationException;
import padl.kernel.impl.v2.Factory;
import padl.pattern.StructuralPatternModel;
import padl.visitor.PtidejSolver2AC4DomainGenerator;
import padl.visitor.PtidejSolverAC4ConstraintGenerator;
import util.io.OutputManager;

public class Facade
extends StructuralPatternModel
implements Cloneable {
    public Facade() throws CloneNotSupportedException, ModelDeclarationException {
        super("Facade");
        this.setFactory(Factory.getUniqueInstance());
        IClass aFacade = this.getFactory().createClass("Facade");
        this.addActor(aFacade);
        this.addSubsystemClass("SubsystemClass", new String[]{"aRealOperation"});
        this.addClient(new String[]{"Client", "aFacadeSideOperationOnARealOperation"});
    }

    public void addClient(String[] names) throws ModelDeclarationException, CloneNotSupportedException {
        String clientName = names[0];
        String[] facadeMethodNames = new String[names.length - 1];
        System.arraycopy(names, 1, facadeMethodNames, 0, names.length - 1);
        IClass facadeClass = (IClass)this.getActorFromID("Facade");
        IClass aClient = this.getFactory().createClass(clientName);
        IAssociation aClientFacadeAssoc = this.getFactory().createAssociationRelationship("clientFacadeAssociation", facadeClass, 1);
        aClient.addActor(aClientFacadeAssoc);
        int i = 0;
        while (i < facadeMethodNames.length) {
            IDelegatingMethod facadeMethod = (IDelegatingMethod)facadeClass.getActorFromID(facadeMethodNames[i]);
            IDelegatingMethod clientMethod = this.getFactory().createDelegatingMethod("clientSideOperationOn" + facadeMethodNames[i].substring(0, 1).toUpperCase() + facadeMethodNames[i].substring(1), aClientFacadeAssoc);
            clientMethod.attachTo(facadeMethod);
            aClient.addActor(clientMethod);
            ++i;
        }
        this.addActor(aClient);
    }

    public void addSubsystemClass(String subsystemClassName, String[] subsystemClassMethodNames) throws ModelDeclarationException, CloneNotSupportedException {
        IClass facadeClass = (IClass)this.getActorFromID("Facade");
        IClass aSubsystemClass = this.getFactory().createClass(subsystemClassName);
        IAssociation aFacadeSubsystemClassAssoc = this.getFactory().createAssociationRelationship("facadeSubsystemClassAssociation", aSubsystemClass, 1);
        facadeClass.addActor(aFacadeSubsystemClassAssoc);
        int i = 0;
        while (i < subsystemClassMethodNames.length) {
            IMethod subsystemClassMethod = this.getFactory().createMethod(subsystemClassMethodNames[i]);
            aSubsystemClass.addActor(subsystemClassMethod);
            IDelegatingMethod facadeMethod = this.getFactory().createDelegatingMethod("aFacadeSideOperationOn" + subsystemClassMethodNames[i].substring(0, 1).toUpperCase() + subsystemClassMethodNames[i].substring(1), aFacadeSubsystemClassAssoc);
            facadeMethod.attachTo(subsystemClassMethod);
            facadeClass.addActor(facadeMethod);
            ++i;
        }
        this.addActor(aSubsystemClass);
    }

    public String getIdiom() {
        return "None";
    }

    public String getIntent() {
        return "Provide a unified interface to a set\nof interfaces in a subsystem.\nFacade defines a higher-level interface\nthat makes the subsystem easier to use.";
    }

    public String getName() {
        return "Facade";
    }

    public static void main(String[] args) throws CloneNotSupportedException, ModelDeclarationException {
        Facade facade = new Facade();
        PtidejSolverAC4ConstraintGenerator constraintGenerator = new PtidejSolverAC4ConstraintGenerator();
        PtidejSolver2AC4DomainGenerator domainGenerator = new PtidejSolver2AC4DomainGenerator();
        facade.generate(constraintGenerator);
        OutputManager.getCurrentOutputManager().getNormalOutput().println(constraintGenerator.getCode());
        OutputManager.getCurrentOutputManager().getNormalOutput().println("----");
        facade.walk(domainGenerator);
        OutputManager.getCurrentOutputManager().getNormalOutput().println(domainGenerator.getResult());
    }

    public void removeClient(String[] names) {
        String clientName = names[0];
        this.removeActor(clientName);
    }

    public void removeSubsystemClass(String subsystemClassName) {
        this.removeActor(subsystemClassName);
    }
}

