/*
 * Decompiled with CFR 0.152.
 */
package padl.pattern.repository;

import padl.kernel.IClass;
import padl.kernel.ICreation;
import padl.kernel.IInterface;
import padl.kernel.IMethod;
import padl.kernel.IUseRelationship;
import padl.kernel.ModelDeclarationException;
import padl.kernel.impl.v2.Factory;
import padl.pattern.CreationalPatternModel;

public class FactoryMethod
extends CreationalPatternModel
implements Cloneable {
    public FactoryMethod() throws CloneNotSupportedException, ModelDeclarationException {
        super("FactoryMethod");
        this.setFactory(Factory.getUniqueInstance());
        IInterface abstractFactory = this.getFactory().createInterface("AbstractFactory");
        IClass concreteFactory = this.getFactory().createClass("ConcreteFactory");
        concreteFactory.addInheritedActor(abstractFactory);
        this.addActor(abstractFactory);
        this.addActor(concreteFactory);
        this.addProduct(new String[]{"AbstractProduct", "ConcreteProduct"});
    }

    public void addProduct(String[] names) throws ModelDeclarationException {
        String abstractProductName = names[0];
        String concreteProductName = names[1];
        IInterface abstractFactory = (IInterface)this.getActorFromName("AbstractFactory");
        IClass concreteFactory = (IClass)this.getActorFromName("ConcreteFactory");
        IInterface abstractProduct = this.getFactory().createInterface(abstractProductName);
        IClass concreteProduct = this.getFactory().createClass(concreteProductName);
        concreteProduct.addImplementedEntity(abstractProduct);
        IUseRelationship knowledgeLink = this.getFactory().createUseRelationship("know", abstractProduct, 1);
        abstractFactory.addActor(knowledgeLink);
        IMethod abstractCreateMethod = this.getFactory().createMethod("create" + abstractProductName);
        abstractCreateMethod.setReturnType(abstractProductName);
        abstractCreateMethod.setVisibility(1024);
        abstractFactory.addActor(abstractCreateMethod);
        IMethod concreteCreateMethod = this.getFactory().createMethod("create" + abstractProductName);
        concreteCreateMethod.setCodeLines("return new " + concreteProductName + "();");
        concreteCreateMethod.attachTo(abstractCreateMethod);
        concreteFactory.addActor(concreteCreateMethod);
        ICreation creationLink = this.getFactory().createCreationRelationship("create", concreteProduct, 1);
        concreteFactory.addActor(creationLink);
        this.addActor(abstractProduct);
        this.addActor(concreteProduct);
    }

    public String getIdiom() {
        return "None";
    }

    public String getIntent() {
        return "Define an interface for creating\na familly of objects, but let subclasses decide\nwhich class to instantiate.\nFactory Method lets a class defer\ninstantiation to subclasses.";
    }

    public String getName() {
        return "FactoryMethod";
    }

    public void removeProduct(String[] names) throws ModelDeclarationException {
    }
}

