/*
 * Decompiled with CFR 0.152.
 */
package padl.pattern.repository;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import padl.kernel.IClass;
import padl.kernel.IContainerAggregation;
import padl.kernel.IDelegatingMethod;
import padl.kernel.IEntity;
import padl.kernel.IInterface;
import padl.kernel.IMethod;
import padl.kernel.ModelDeclarationException;
import padl.kernel.impl.v2.Factory;
import padl.pattern.BehaviouralPatternModel;
import padl.visitor.PtidejSolver2AC4DomainGenerator;
import padl.visitor.PtidejSolverAC4ConstraintGenerator;
import util.io.OutputManager;

public class Observer
extends BehaviouralPatternModel
implements PropertyChangeListener,
Cloneable {
    private IClass aClass;
    private IClass a2Class;
    private IInterface anInterface;
    private IDelegatingMethod aPDelegatingMethod;
    private IMethod abMethod;
    private IMethod acMethod;

    public Observer() throws CloneNotSupportedException, ModelDeclarationException {
        super("Observer");
        this.setFactory(Factory.getUniqueInstance());
        this.anInterface = this.getFactory().createInterface("Observer");
        this.abMethod = this.getFactory().createMethod("Update");
        this.anInterface.addActor(this.abMethod);
        this.anInterface.setPurpose("Defines a common interface for objects that should be notified when the subject changes.");
        this.addActor(this.anInterface);
        IContainerAggregation anAssoc = this.getFactory().createContainerAggregationRelationship("observers", this.anInterface, 2);
        this.aClass = this.getFactory().createClass("Subject");
        this.aClass.setAbstract(true);
        this.aClass.addActor(anAssoc);
        this.aPDelegatingMethod = this.getFactory().createDelegatingMethod("Notify", anAssoc, this.abMethod);
        this.aClass.addActor(this.aPDelegatingMethod);
        this.aClass.assumeAllInterfaces();
        this.aClass.setPurpose("1. Knows  its observers. Any number of Observer objects may observe a subject\n2. Provides an interface for attaching and detaching Observer objects");
        this.addActor(this.aClass);
        this.acMethod = this.getFactory().createMethod("getState");
        this.a2Class = this.getFactory().createClass("ConcreteSubject", this.aClass);
        this.a2Class.setPurpose("1. Stores state of interest to ConcreteObserver objects\n2. Sends a notification to its observers when its state changes");
        this.a2Class.addActor(this.acMethod);
        this.a2Class.assumeAllInterfaces();
        this.addActor(this.a2Class);
        IContainerAggregation a2Assoc = this.getFactory().createContainerAggregationRelationship("subject", this.a2Class, 1);
        this.aPDelegatingMethod = this.getFactory().createDelegatingMethod("Update", a2Assoc, this.acMethod);
        this.aPDelegatingMethod.setComment("Add specific operations in this method");
        this.aPDelegatingMethod.attachTo(this.abMethod);
        this.a2Class = this.getFactory().createClass("ConcreteObserver");
        this.a2Class.setPurpose("1. Maintains a reference to a ConcreteSubject object\n2. Stores state that should stay consistent with the subject's\n3. Implements the Observer updating interface to keep its state consistent with the subject's");
        this.a2Class.addImplementedEntity(this.anInterface);
        this.a2Class.addActor(a2Assoc);
        this.a2Class.addActor(this.aPDelegatingMethod);
        this.a2Class.assumeAllInterfaces();
        this.addActor(this.a2Class);
    }

    private void codeForSetMethod() {
        if (this.getActorFromName("ConcreteObserver") == null || this.getActorFromName("Subject") == null) {
            return;
        }
        IContainerAggregation a2Assoc = (IContainerAggregation)((IEntity)this.getActorFromName("ConcreteObserver")).getActorFromName("subject");
        IContainerAggregation anAssoc = (IContainerAggregation)((IEntity)this.getActorFromName("Subject")).getActorFromName("observers");
        IMethod sMethod = (IMethod)a2Assoc.getActorFromName("~ID3");
        String[] codeLines = new String[]{"if (" + a2Assoc.getActorFromName("~ID1").getName() + " != null)", "     " + a2Assoc.getActorFromName("~ID1").getName() + '.' + anAssoc.getActorFromName("~ID3").getName() + "(this);", String.valueOf(a2Assoc.getActorFromName("~ID1").getName()) + " = a" + a2Assoc.getTargetActor().getName() + ';', String.valueOf(a2Assoc.getActorFromName("~ID1").getName()) + '.' + anAssoc.getActorFromName("~ID2").getName() + "(this);"};
        try {
            sMethod.setCodeLines(codeLines);
        }
        catch (ModelDeclarationException modelDeclarationException) {
            // empty catch block
        }
    }

    public String getIdiom() {
        return "Exist in package java.util as class Observer.";
    }

    public String getIntent() {
        return "Define a one-to-many dependancy\nbetween objects.\nWhen one object changes state,\nall its dependants are notified\nand updated automatically.";
    }

    public String getName() {
        return "Observer";
    }

    public static void main(String[] args) throws CloneNotSupportedException, ModelDeclarationException {
        Observer observer = new Observer();
        PtidejSolverAC4ConstraintGenerator constraintGenerator = new PtidejSolverAC4ConstraintGenerator();
        PtidejSolver2AC4DomainGenerator domainGenerator = new PtidejSolver2AC4DomainGenerator();
        observer.generate(constraintGenerator);
        OutputManager.getCurrentOutputManager().getNormalOutput().println(constraintGenerator.getCode());
        OutputManager.getCurrentOutputManager().getNormalOutput().println("----");
        observer.walk(domainGenerator);
        OutputManager.getCurrentOutputManager().getNormalOutput().println(domainGenerator.getResult());
    }

    public void propertyChange(PropertyChangeEvent e) {
        this.codeForSetMethod();
    }
}

